/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.CmVariableRecognizer;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.KeyValueFileReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class VariableListArranger {
    private Map<String, String> cmVarPrefixes;
    private static VariableListArranger variableListArranger = null;

    public static VariableListArranger getInstance() {
        if (variableListArranger == null) {
            variableListArranger = new VariableListArranger();
        }
        return variableListArranger;
    }

    private VariableListArranger() {
        KeyValueFileReader reader = new KeyValueFileReader();
        try {
            FileInputStream inStream = new FileInputStream(Globs.CM_VARS_FILE_PATH);
            this.cmVarPrefixes = reader.convertFileToMap(inStream);
        }
        catch (FileNotFoundException e) {
            this.cmVarPrefixes = new HashMap<String, String>();
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    public VariableListArranger(Map<String, String> cmVarPrefixes) {
        this.cmVarPrefixes = cmVarPrefixes;
    }

    public List<Properties> arrangeList(List<Properties> variables, String jobType) {
        List<Properties> regularVariables = this.extractVariables(variables, jobType);
        List<Properties> cmVars = this.extractCmVariables(variables, jobType);
        List<Properties> bmcOrigTypeVars = this.extractBmcOrigTypeVariable(variables);
        ArrayList<Properties> validOrderList = new ArrayList<Properties>();
        validOrderList.addAll(regularVariables);
        validOrderList.addAll(bmcOrigTypeVars);
        validOrderList.addAll(cmVars);
        return validOrderList;
    }

    public List<Properties> extractVariables(List<Properties> variables, String jobType) {
        List<Properties> cmVars = this.extractCmVariables(variables, jobType);
        List<Properties> bmcOrigTypeVars = this.extractBmcOrigTypeVariable(variables);
        return variables.stream().filter(v -> !cmVars.contains(v)).filter(v -> !bmcOrigTypeVars.contains(v)).map(this::replaceNewLineWithBlank).collect(Collectors.toList());
    }

    public List<Properties> extractBmcOrigTypeVariable(List<Properties> variables) {
        return variables.stream().filter(v -> {
            String variableName = v.getProperty("NAME");
            return variableName.startsWith("%%$BMC");
        }).map(this::replaceNewLineWithBlank).collect(Collectors.toList());
    }

    public List<Properties> extractCmVariables(List<Properties> variables, String jobType) {
        return Optional.ofNullable(jobType).map(type -> {
            CmVariableRecognizer cmRecognizer = new CmVariableRecognizer(this.cmVarPrefixes, (String)type);
            return variables.stream().filter(cmRecognizer::isCmVariable).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }

    private Properties replaceNewLineWithBlank(Properties variables) {
        variables.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String newValue = value.toString().replaceAll("[\\n\\r]+", " ");
            variables.setProperty((String)key, newValue);
        }));
        return variables;
    }
}

