/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.CsvFile;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.io.InputStream;
import java.util.HashMap;

public class RecordsHolder
extends CsvFile {
    private HashMap<Integer, AttrHolderList> m_records = new HashMap();
    private String m_keyName;
    private String m_csvFileName;

    public RecordsHolder(String csvFileName, String keyName) {
        this.m_keyName = keyName;
        this.m_csvFileName = csvFileName;
        this.load();
    }

    public RecordsHolder(InputStream inputStream, String keyName) {
        this.m_keyName = keyName;
        super.load(inputStream, false);
    }

    public void load() {
        super.load(this.m_csvFileName, false);
    }

    public String keyName() {
        return this.m_keyName;
    }

    @Override
    protected void handleRecord(IAttrHolder record, int record_number) {
        int id;
        String id_str = record.getAttr(this.m_keyName);
        if (id_str.isEmpty()) {
            return;
        }
        try {
            id = Integer.parseInt(id_str);
        }
        catch (NumberFormatException ex) {
            return;
        }
        AttrHolderList list = this.m_records.get(id_str);
        if (list == null) {
            list = new AttrHolderList();
            this.m_records.put(id, list);
        }
        list.add(record);
    }

    public IAttrHolder get(int id) {
        AttrHolderList list = this.m_records.get(id);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (IAttrHolder)list.get(0);
    }

    public AttrHolderList getList(int id) {
        return this.m_records.get(id);
    }

    public AttrHolderList getAllRecords() {
        AttrHolderList retList = new AttrHolderList();
        for (Integer key : this.m_records.keySet()) {
            retList.addAll(this.m_records.get(key));
        }
        return retList;
    }
}

