/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.VendorDataManager;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;

public class Params {
    public static final String HELIX_SERVER_NAME = "IN01";
    private boolean duplicatedJobNames = false;
    private boolean duplicatedResourceNames = false;
    private static Params m_params = null;
    private String hostName;
    private boolean isNewConversion;
    private boolean isZos = false;
    private String conversionDescription;
    private String defaultDatacenterName;
    private String firstDayOfTheWeek = "Monday";
    private ArrayList<File> toCleanup;
    private String defaultMFDatacenterName;
    private File jobTracOutputFile;
    private String jobTracFileNameData;
    private File zekeOutputFile;
    private String zekeFileNameData;
    private File mainFrameOutputFile;
    private String mainFrameFileNameData;

    private Params() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            ExceptionHandler.writeToExceptionFile(e);
            this.hostName = "";
        }
        this.defaultMFDatacenterName = "MVS_DATACENTER";
        this.defaultDatacenterName = this.hostName.isEmpty() ? "DATACENTER" : this.hostName;
    }

    public static Params instance() {
        if (m_params == null) {
            m_params = new Params();
        }
        return m_params;
    }

    public static String getWorkingDir() {
        return Globs.HOME_DIR;
    }

    public Properties getProjectProperties() {
        return ConversionEntitiesService.getCurrentProjectDetails();
    }

    public void saveProjectProperties() {
        ConversionEntitiesService.saveCurrentProjectDetails();
    }

    public String getHostname() {
        return this.hostName;
    }

    public void enableDuplicatedJobNames() {
        this.duplicatedJobNames = true;
    }

    public void enableDuplicatedResourceNames() {
        this.duplicatedResourceNames = true;
    }

    public void disableDuplicatedJobNames() {
        this.duplicatedJobNames = false;
    }

    public void disableDuplicatedResourceNames() {
        this.duplicatedResourceNames = false;
    }

    public boolean isThereDuplicatedJobNames() {
        return this.duplicatedJobNames;
    }

    public boolean isThereDuplicatedResourceNames() {
        return this.duplicatedResourceNames;
    }

    public void setGUIVersion(String version) {
        if (version != null) {
            Properties details = ConversionEntitiesService.getCurrentConversionDetails();
            if (details != null) {
                details.setProperty("OUTPUT_VERSION", version);
            }
            this.setPropertyFromSettings(SettingsStringKeys.GUI_VERSION, version);
        }
    }

    public String getGUIVersion() {
        String version = null;
        Properties details = ConversionEntitiesService.getCurrentConversionDetails();
        if (details != null) {
            version = details.getProperty("OUTPUT_VERSION");
        }
        if (version == null || version.isEmpty()) {
            version = SettingsTable.instance().getProperty(SettingsStringKeys.GUI_VERSION);
        }
        return version;
    }

    public boolean isImportComplete() {
        return ConversionEntitiesService.getCurrentProjectDetails().getProperty("IMPORT_COMPLETE").equals("Y");
    }

    public void setIsImportComplete(boolean importComplete) {
        ConversionEntitiesService.getCurrentProjectDetails().setProperty("IMPORT_COMPLETE", importComplete ? "Y" : "N");
    }

    public boolean isNewConversion() {
        return this.isNewConversion;
    }

    public void setIsNewConversion(boolean isNewConversion) {
        this.isNewConversion = isNewConversion;
    }

    public String getVendorName() {
        return Optional.ofNullable(ConversionEntitiesService.getCurrentProjectDetails()).map(projectDetails -> projectDetails.getProperty("VENDOR")).orElse("unknownVendorName");
    }

    public boolean isValidationProject() {
        return VendorDataManager.instance().getVendorData(this.getVendorName()).getName().equals("VALIDATION_PROJECT");
    }

    public boolean isZOS() {
        return this.isZos;
    }

    public void setIsZOS(boolean b) {
        this.isZos = b;
    }

    public String getDatasourceName() {
        return ConversionEntitiesService.getCurrentProjectName();
    }

    public String getDatasourcePath() {
        return ConversionEntitiesService.getCurrentProjectDataDirectory();
    }

    public String getConversionName() {
        return ConversionEntitiesService.getCurrentConversionName();
    }

    public void setConversionName(String conversionName) {
        ConversionEntitiesService.setCurrentConversionName(conversionName);
    }

    public String getConversionDescription() {
        return this.conversionDescription;
    }

    public void setConversionDescription(String description) {
        this.conversionDescription = description;
    }

    public void setDatacenterName(String datacenterName) {
        if (datacenterName != null) {
            Properties details = ConversionEntitiesService.getCurrentConversionDetails();
            if (details != null) {
                details.setProperty("DS_CONTROL_M", datacenterName);
            }
            this.setPropertyFromSettings(SettingsStringKeys.DS_CONTROLM_SERVER_NAME, datacenterName);
        }
    }

    public String getDatacenterName() {
        Properties details = ConversionEntitiesService.getCurrentConversionDetails();
        String datacenter = details != null ? details.getProperty("DS_CONTROL_M") : this.getPropertyFromSettings(SettingsStringKeys.DS_CONTROLM_SERVER_NAME);
        return datacenter == null || datacenter.isEmpty() ? (SettingsBooleanKeys.isSaas() ? HELIX_SERVER_NAME : this.defaultDatacenterName) : datacenter;
    }

    public String getDataImportMethod() {
        String dataImportMethod = "";
        Properties details = ConversionEntitiesService.getCurrentProjectDetails();
        if (details != null) {
            dataImportMethod = details.getProperty("DATA_IMPORT_METHOD");
        }
        return dataImportMethod != null ? dataImportMethod : "";
    }

    public void setDataImportMethod(String dataImportMethod) {
        Properties details = ConversionEntitiesService.getCurrentProjectDetails();
        if (details != null) {
            details.setProperty("DATA_IMPORT_METHOD", dataImportMethod);
        }
    }

    public void setMFDatacenterName(String datacenterName) {
        if (datacenterName != null) {
            Properties details = ConversionEntitiesService.getCurrentConversionDetails();
            if (details != null) {
                details.setProperty("ZOS_CONTROL_M", datacenterName);
            }
            this.setPropertyFromSettings(SettingsStringKeys.ZOS_CONTROLM_SERVER_NAME, datacenterName);
        }
    }

    public String getMFDatacenterName() {
        Properties details = ConversionEntitiesService.getCurrentConversionDetails();
        String datacenter = details != null ? details.getProperty("ZOS_CONTROL_M") : this.getPropertyFromSettings(SettingsStringKeys.ZOS_CONTROLM_SERVER_NAME);
        return datacenter == null || datacenter.isEmpty() ? this.defaultMFDatacenterName : datacenter;
    }

    public void setJobTracFileNameData(String jobTracFileNameData) {
        this.jobTracFileNameData = jobTracFileNameData;
    }

    public String getJobTracFileNameData() {
        return this.jobTracFileNameData;
    }

    public void setJobTracOutputFile(File jobTracOutputFile) {
        this.jobTracOutputFile = jobTracOutputFile;
    }

    public File getJobTracOutputFile() {
        return this.jobTracOutputFile;
    }

    public void setZekeFileNameData(String zekeFileNameData) {
        this.zekeFileNameData = zekeFileNameData;
    }

    public String getZekeFileNameData() {
        return this.zekeFileNameData;
    }

    public void setZekeOutputFile(File zekeOutputFile) {
        this.zekeOutputFile = zekeOutputFile;
    }

    public File getZekeOutputFile() {
        return this.zekeOutputFile;
    }

    public void setMainFrameFileNameData(String mainFrameFileNameData) {
        this.mainFrameFileNameData = mainFrameFileNameData;
    }

    public String getMainFrameFileNameData() {
        return this.mainFrameFileNameData;
    }

    public void setMainFrameOutputFile(File mainFrameOutputFile) {
        this.mainFrameOutputFile = mainFrameOutputFile;
    }

    public File getMainFrameOutputFile() {
        return this.mainFrameOutputFile;
    }

    public void setFirstDayOfTheWeek(String firstDayOfTheWeek) {
        this.firstDayOfTheWeek = firstDayOfTheWeek;
    }

    public String getFirstDayOfTheWeek() {
        return this.firstDayOfTheWeek;
    }

    public boolean isCaptureCleanupNeeded() {
        return this.toCleanup != null && this.toCleanup.size() > 0;
    }

    public void addToCleanup(File file) {
        if (this.toCleanup == null) {
            this.toCleanup = new ArrayList();
        }
        this.toCleanup.add(file);
    }

    public ArrayList<File> getToCleanup() {
        return this.toCleanup;
    }

    private String getPropertyFromSettings(SettingsStringKeys key) {
        return SettingsTable.instance().getProperty(key);
    }

    private void setPropertyFromSettings(SettingsStringKeys key, String value) {
        SettingsTable.instance().setProperty(key, value);
    }

    public static void setParams(Params instance) {
        m_params = instance;
    }

    public void initFirstDayOfTheWeek() {
        this.setFirstDayOfTheWeek("Monday");
    }
}

