/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Forest<T>
implements Iterable<T> {
    private ArrayList<Node<T>> nodes = new ArrayList();

    private Node<T> addNode(T data) {
        Node<T> newNode = new Node<T>(data);
        this.nodes.add(newNode);
        return newNode;
    }

    public void addLink(T linkSource, T linkDestination) {
        if (!this.containsNode(linkSource)) {
            this.addNode(linkSource);
        }
        if (!this.containsNode(linkDestination)) {
            this.addNode(linkDestination);
        }
        Node<T> predecessor = this.getNode(linkSource);
        Node<T> successor = this.getNode(linkDestination);
        if (predecessor != null && successor != null) {
            predecessor.addSuccessor(successor);
        }
    }

    public boolean containsNode(T data) {
        Node<T> node = this.getNode(data);
        return node != null;
    }

    private Node<T> getNode(T data) {
        for (Node<T> node : this.nodes) {
            if (node.data == data) {
                return node;
            }
            if (node.data == null || !node.data.equals(data)) continue;
            return node;
        }
        return null;
    }

    public Set<T> getNodeSuccessors(T data) {
        HashSet<T> ret = new HashSet<T>();
        Node<T> node = this.getNode(data);
        if (node != null) {
            Set<Node<T>> successors = node.getSuccessors();
            for (Node<T> successor : successors) {
                ret.add(successor.getData());
            }
        }
        return ret;
    }

    public Set<T> getNodePredecessors(T data) {
        HashSet<T> ret = new HashSet<T>();
        Node<T> node = this.getNode(data);
        if (node != null) {
            Set<Node<T>> predecessors = node.getPredecessors();
            for (Node<T> predecessor : predecessors) {
                ret.add(predecessor.getData());
            }
        }
        return ret;
    }

    public int size() {
        return this.nodes.size();
    }

    @Override
    public Iterator<T> iterator() {
        List dataList = this.nodes.stream().map(node -> node.getData()).collect(Collectors.toList());
        return dataList.iterator();
    }

    public Object[] toArray() {
        List dataList = this.nodes.stream().map(node -> node.getData()).collect(Collectors.toList());
        return dataList.toArray();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Forest nodes=\n");
        for (Node<T> node : this.nodes) {
            b.append(node).append("\n");
        }
        return b.toString();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public static class Node<T> {
        private T data;
        private Set<Node<T>> predecessors;
        private Set<Node<T>> successors;

        public Node(T data) {
            this.data = data;
            this.predecessors = new HashSet<Node<T>>();
            this.successors = new HashSet<Node<T>>();
        }

        public void addSuccessor(Node<T> anotherNode) {
            this.successors.add(anotherNode);
            if (!anotherNode.hasPredecessor(this)) {
                anotherNode.addPredecessor(this);
            }
        }

        public void addPredecessor(Node<T> anotherNode) {
            this.predecessors.add(anotherNode);
            if (!anotherNode.hasSuccessor(this)) {
                anotherNode.addSuccessor(this);
            }
        }

        private boolean hasPredecessor(Node<T> node) {
            return this.predecessors.contains(node);
        }

        private boolean hasSuccessor(Node<T> node) {
            return this.successors.contains(node);
        }

        public Set<Node<T>> getSuccessors() {
            return this.successors;
        }

        public Set<Node<T>> getPredecessors() {
            return this.predecessors;
        }

        public T getData() {
            return this.data;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("Node=\n");
            b.append("data = " + String.valueOf(this.data)).append("\n");
            b.append("predecessors=");
            for (Node<T> node : this.predecessors) {
                b.append(node.getData()).append("\t");
            }
            b.append("\nsuccessors=");
            for (Node<T> node : this.successors) {
                b.append(node.getData()).append("\t");
            }
            return b.toString();
        }
    }
}

