/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileFunctions {
    public static boolean createZipFile(String dir_name, String file_name, String root_dir) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file_name));
            File f = new File(dir_name);
            String canonical_path = f.getCanonicalPath();
            String Path2 = canonical_path.substring(canonical_path.indexOf(root_dir), canonical_path.length());
            ZipEntry anEntry = new ZipEntry(Path2.replace('\\', '/') + "/");
            zos.putNextEntry(anEntry);
            if (!FileFunctions.zipDir(dir_name, zos, root_dir)) {
                return false;
            }
            zos.close();
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
            return false;
        }
    }

    public static boolean zipDir(String dir2zip, ZipOutputStream zos, String root_dir) {
        String filePath = "";
        String Path2 = "";
        try {
            File zipDir = new File(dir2zip);
            String[] dirList = zipDir.list();
            byte[] readBuffer = new byte[2156];
            int bytesIn = 0;
            if (dirList == null) {
                return false;
            }
            for (int i = 0; i < dirList.length; ++i) {
                ZipEntry anEntry;
                File f = new File(zipDir, dirList[i]);
                if (f.isDirectory()) {
                    filePath = f.getPath();
                    Path2 = f.getCanonicalPath().substring(f.getCanonicalPath().indexOf(root_dir), f.getCanonicalPath().length());
                    anEntry = new ZipEntry(Path2.replace('\\', '/') + "/");
                    zos.putNextEntry(anEntry);
                    if (FileFunctions.zipDir(filePath, zos, root_dir)) continue;
                    return false;
                }
                FileInputStream fis = new FileInputStream(f);
                Path2 = f.getCanonicalPath().substring(f.getCanonicalPath().indexOf(root_dir), f.getCanonicalPath().length());
                anEntry = new ZipEntry(Path2.replace('\\', '/'));
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                fis.close();
            }
            return true;
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
            return false;
        }
    }

    public static boolean deleteDirectory(File path) {
        boolean result = true;
        try {
            if (path.exists()) {
                File[] files = path.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (!(files[i].isDirectory() ? !(result = FileFunctions.deleteDirectory(files[i])) : !(result = files[i].delete()))) continue;
                }
                if (!result) {
                    return result;
                }
                result = path.delete();
            }
            return result;
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(sourceFile);
            source = fileInputStream.getChannel();
            fileOutputStream = new FileOutputStream(destFile);
            destination = fileOutputStream.getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (destination != null) {
                destination.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (source != null) {
                source.close();
            }
        }
    }
}

