/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class DescriptionManager {
    private static final String CONVERTING_TO_CONTROL_M = "Converting_to_Control-M.htm";
    private static final String NUMBER_SIGN = "#";
    private static final String SOURCE_DATA_EXTRACTION = "Source_Data_Extraction.htm";
    private static final String ADDITIONAL_SETTINGS = "Additional_Settings.htm";
    private static final String CONVERSION_SETTINGS = "ConversionSettings";
    private static final String TWSADDITIONAL_CONVERSION_SETTINGS = "TWSAdditionalConversionSettings";
    private static final String ONLINE_DOCUMENTATION_LINK = "https://documents.bmc.com/supportu/9.0.22/en-US/Documentation/Conversion/";
    private static final String ONLINE_SAAS_DOCUMENTATION_LINK = "https://documents.bmc.com/supportu/controlm-saas/en-US/Documentation/Conversion/";
    private static final String INTRODUCTION_TO_CONTROL_M_CONVERSION = "Introduction_to_Control-M_Conversion.htm";
    private static DescriptionManager instance = null;
    private final Map<String, String> titleToLinkFile = DescriptionManager.getTitleToLinkMapping();

    private DescriptionManager() {
    }

    public static DescriptionManager instance() {
        if (instance == null) {
            instance = new DescriptionManager();
        }
        return instance;
    }

    public void showDescriptionDialog(String key) {
        this.openInBrowser(this.getFullHelpLink(key));
    }

    String getFullHelpLink(String key) {
        String link = this.getLinkBy(key);
        String onlineDocumentationLink = SettingsBooleanKeys.isSaas() ? ONLINE_SAAS_DOCUMENTATION_LINK : ONLINE_DOCUMENTATION_LINK;
        return onlineDocumentationLink + link;
    }

    private String getLinkBy(String key) {
        String link = this.titleToLinkFile.getOrDefault(key, INTRODUCTION_TO_CONTROL_M_CONVERSION);
        return "".equals(link) ? INTRODUCTION_TO_CONTROL_M_CONVERSION : link;
    }

    private void openInBrowser(String path) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(path));
            }
            catch (IOException | URISyntaxException e) {
                ConversionLogger.getLogger().info("Unable to open help files: " + e.getMessage());
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
    }

    static Map<String, String> getTitleToLinkMapping() {
        return Map.ofEntries(Map.entry("PROJECTS_PANEL", INTRODUCTION_TO_CONTROL_M_CONVERSION), Map.entry("NEW_PROJECT_DIALOG", CONVERTING_TO_CONTROL_M), Map.entry("EVALUATE_DATA", "Data_Evaluation.htm"), Map.entry("LOAD_DATA_APPWORX", "Source_Data_Extraction.htm#BroadcomAppWorxDataExtraction"), Map.entry("LOAD_DATA_AUTOSYS", "Source_Data_Extraction.htm#Converti"), Map.entry("LOAD_DATA_CRON_MANUAL_OR_AUTOMATIC", "Source_Data_Extraction.htm#CronDataExtraction"), Map.entry("LOAD_DATA_CRON_AUTOMATIC", "Source_Data_Extraction.htm#CronDataExtraction"), Map.entry("LOAD_DATA_CRON_MANUAL", "Source_Data_Extraction.htm#CronDataExtraction"), Map.entry("LOAD_DATA_CRON_MANUAL_DIALOG", "Source_Data_Extraction.htm#CronDataExtraction"), Map.entry("LOAD_DATA_DOLLAR_UNIVERSE", "Source_Data_Extraction.htm#ExtractingBroadcomDollarUniverseData"), Map.entry("LOAD_DATA_OOZIE_MANUAL_OR_AUTOMATIC", "Source_Data_Extraction.htm#HadoopOozieDataExtraction"), Map.entry("LOAD_DATA_OOZIE_AUTOMATIC", "Source_Data_Extraction.htm#HadoopOozieDataExtraction"), Map.entry("LOAD_DATA_OOZIE_MANUAL", "Source_Data_Extraction.htm#Extracti9"), Map.entry("LOAD_DATA_JOBTRAC_NEW_OR_EXISTING", "Source_Data_Extraction.htm#Broadcom3"), Map.entry("LOAD_DATA_JOBTRAC_JCL", "Source_Data_Extraction.htm#Broadcom3"), Map.entry("LOAD_DATA_JOBTRAC_ENVIRONMENT", "Source_Data_Extraction.htm#Broadcom3"), Map.entry("LOAD_DATA_JOBTRAC_EXISTING", "Source_Data_Extraction.htm#Broadcom3"), Map.entry("LOAD_DATA_MS_MANUAL_OR_AUTOMATIC", "Source_Data_Extraction.htm#MSTaskSchedulerDataExtraction"), Map.entry("LOAD_DATA_MS_AUTOMATIC", "Source_Data_Extraction.htm#Configuring"), Map.entry("LOAD_DATA_MS_MANUAL", "Source_Data_Extraction.htm#MSTaskSchedulerDataExtraction"), Map.entry("LOAD_DATA_MS_MANUAL_DIALOG", "Source_Data_Extraction.htm#MSTaskSchedulerDataExtraction"), Map.entry("LOAD_DATA_REDWOOD", "Source_Data_Extraction.htm#RedwoodBPACPSDataExtraction"), Map.entry("LOAD_DATA_REDWOOD_AUTOMATIC", "Source_Data_Extraction.htm#RedwoodBPACPSDataExtraction"), Map.entry("LOAD_DATA_REDWOOD_MANUAL", "Source_Data_Extraction.htm#RedwoodBPACPSDataExtraction"), Map.entry("LOAD_DATA_SAP_MANUAL_OR_AUTOMATIC", "Source_Data_Extraction.htm#SAPDataExtraction"), Map.entry("LOAD_DATA_SAP_AUTOMATIC", "Source_Data_Extraction.htm#Download"), Map.entry("LOAD_DATA_SAP_MANUAL", "Source_Data_Extraction.htm#Manually"), Map.entry("LOAD_DATA_TIDAL", "Source_Data_Extraction.htm#TidalCPSDataExtraction"), Map.entry("LOAD_DATA_TIDAL_AUTOMATIC", "Source_Data_Extraction.htm#TidalCPSDataExtraction"), Map.entry("LOAD_DATA_TIDAL_MANUAL", "Source_Data_Extraction.htm#TidalCPSDataExtraction"), Map.entry("LOAD_DATA_TWS", "Source_Data_Extraction.htm#IBMTivoliWorkloadSchedulerTWSDataExtraction"), Map.entry("LOAD_DATA_UC4", "Source_Data_Extraction.htm#BroadcomAutomicUC4DataExtraction"), Map.entry("LOAD_DATA_TNG", "Source_Data_Extraction.htm#ExtractingBroadcomUnicenterWLMTNGData"), Map.entry("LOAD_DATA_ZENA", "Source_Data_Extraction.htm#ASGZenaDataExtraction"), Map.entry("LOAD_DATA_ZENA_AUTOMATIC", "Source_Data_Extraction.htm#ASGZenaDataExtraction"), Map.entry("LOAD_DATA_ZENA_MANUAL", "Source_Data_Extraction.htm#ASGZenaDataExtraction"), Map.entry("LOAD_DATA_DSERIES", "Source_Data_Extraction.htm#ExtractingBroadcomWorkloadAutomationDEDatainBatchMode"), Map.entry("LOAD_DATA_VALIDATION", ""), Map.entry("LOAD_DATA_JP1", "Source_Data_Extraction.htm#JP1AutomaticJobSchedulerDataExtraction"), Map.entry("LOAD_DATA_CD", "Source_Data_Extraction.htm#ExtractingIBMSterlingConnectDirectData"), Map.entry("LOAD_DATA_FLOWUPDATER", "Control-M_OS_to_Application_Jobs.htm"), Map.entry("CONVERSION_PANEL", CONVERTING_TO_CONTROL_M), Map.entry("CONVERSION_SETTINGS", "Converting_to_Control-M.htm#ConversionSettings"), Map.entry("RULES_GENERAL", "Converting_to_Control-M.htm#ConversionSettings"), Map.entry("RULES_FIELD_EDITOR", "Converting_to_Control-M.htm#ConversionSettings"), Map.entry("RULES_APPWORX", "Additional_Settings.htm#BroadcomAppworxAdditionalConversionSettings"), Map.entry("RULES_AUTOSYS", "Additional_Settings.htm#BroadcomAutoSysAdditionalConversionSettings"), Map.entry("RULES_CRON", "Additional_Settings.htm#CronAdditionalConversionSettings"), Map.entry("RULES_DOLLAR_UNIVERSE", "Additional_Settings.htm#BroadcomDollarUniverseAdditionalConversionSettings"), Map.entry("RULES_UC4", "Additional_Settings.htm#BroadcomAutomicUC4AdditionalConversionSettings"), Map.entry("RULES_MS", "Additional_Settings.htm#TaskSchedulerAdditionalConversionSettings"), Map.entry("RULES_JOBTRAC", "Additional_Settings.htm#BroadcomJOBTRACAdditionalConversionSettings"), Map.entry("RULES_TIDAL", "Additional_Settings.htm#TidalCPSAdditionalConversionSettings"), Map.entry("RULES_TWS", "Additional_Settings.htm#TWSAdditionalConversionSettings"), Map.entry("RULES_TWS_SAP", "Additional_Settings.htm#TWSAdditionalConversionSettings"), Map.entry("RULES_TWS_PS", "Additional_Settings.htm#TWSAdditionalConversionSettings"), Map.entry("RULES_TWS_OS400", "Additional_Settings.htm#TWSAdditionalConversionSettings"), Map.entry("RULES_TNG", "Additional_Settings.htm#BroadcomUnicenterWLMTNGAdditionalConversionSettings"), Map.entry("RULES_SAP", "Additional_Settings.htm#SAPAdditionalConversionSettings"), Map.entry("RULES_OOZIE", "Additional_Settings.htm#HadoopOozieAdditionalConversionSettings"), Map.entry("RULES_ZENA", "Additional_Settings.htm#ZenaAdditionalConversionSettings"), Map.entry("RULES_REDWOOD", "Additional_Settings.htm#RedwoodCPSAdditionalConversionSettings"), Map.entry("RULES_JP1", "Additional_Settings.htm#JP1AdditionalConversionSettings"), Map.entry("RULES_ADDITIONAL_DSERIES", "Additional_Settings.htm#BroadcomWorkloadAutomationDEdSeriesAdditionalConversionSettings"), Map.entry("RULES_Flow_Updater", "Control-M_OS_to_Application_Jobs.htm#SettingAdditionalControlMOStoApplicationJobsRules"), Map.entry("CONVERSION_RESULTS_PANEL", "Post_Processing.htm"), Map.entry("POST_CONVERSION_SCRIPTS", "Converting_to_Control-M.htm#GeneratingScriptsforControlMServer"), Map.entry("VALIDATION_PANEL", ""), Map.entry("VALIDATION_REPORT", ""), Map.entry("LOAD_TO_EM_PANEL", CONVERTING_TO_CONTROL_M), Map.entry("SUMMARY", CONVERTING_TO_CONTROL_M));
    }
}

