/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.io.csv.CsvReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class CsvFile {
    protected HashMap<String, Integer> m_header2Index = new HashMap();
    private int m_counter = 0;

    public int getRecordsReadCount() {
        return this.m_counter;
    }

    protected void handleRecord(IAttrHolder record, int record_number) throws Exception {
    }

    public void load(String fullPathCSVFile) {
        this.load(fullPathCSVFile, false);
    }

    public void load(InputStream input) {
        InputStreamReader reader = new InputStreamReader(input);
        this.load(reader, false);
    }

    public void load(InputStream input, boolean safetySwitch) {
        InputStreamReader reader = new InputStreamReader(input);
        this.load(reader, safetySwitch);
    }

    public void load(Reader reader, boolean safetySwitch) {
        try (CsvReader csvReader = new CsvReader(reader);){
            this.handleLoadedData(safetySwitch, csvReader);
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void load(String fullPathCSVFile, boolean safetySwitch) {
        try {
            this.load(this.createReader(Paths.get(fullPathCSVFile, new String[0])), safetySwitch);
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
        }
    }

    public Reader createReader(Path path) throws IOException {
        return FileUtils.createNewReader(path);
    }

    public void load(Path fullPathCSVFile, boolean safetySwitch) {
        try {
            this.load(this.createReader(fullPathCSVFile), safetySwitch);
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
        }
    }

    private void handleLoadedData(boolean safetySwitch, CsvReader reader) throws IOException {
        reader.setSafetySwitch(safetySwitch);
        this.m_header2Index = AttrHolder.buildHeadersMap(reader);
        while (reader.readRecord()) {
            String[] values = reader.getValues();
            boolean recordIsEmpty = true;
            for (String val : values) {
                if (val.isEmpty()) continue;
                recordIsEmpty = false;
                break;
            }
            if (recordIsEmpty) continue;
            ++this.m_counter;
            try {
                this.handleRecord(new AttrHolder(reader.getValues(), this.m_header2Index), this.m_counter);
            }
            catch (Exception e) {
                ConversionLogger.getLogger().info(e.getMessage());
                break;
            }
        }
    }
}

