/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.csvreader.CsvReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class AttrHolder
implements Serializable,
IAttrHolder {
    private static final long serialVersionUID = 8989713317426444898L;
    private String[] m_values;
    private final Map<String, Integer> m_attrName2Index;
    private String jobName = null;
    private final String jobNameAttr = "insert_job";

    public AttrHolder(String[] values, Map<String, Integer> attrName2Index) {
        Integer jobNameIndex;
        this.m_values = values;
        this.m_attrName2Index = attrName2Index;
        if (this.m_attrName2Index != null && this.m_values != null && (jobNameIndex = this.m_attrName2Index.get("insert_job")) != null && jobNameIndex >= 0 && jobNameIndex < this.m_values.length) {
            this.jobName = this.m_values[jobNameIndex];
        }
    }

    public AttrHolder clone() {
        String[] newValues = (String[])this.m_values.clone();
        Map<String, Integer> new_m_attrName2Index2 = this.m_attrName2Index.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new AttrHolder(newValues, new_m_attrName2Index2);
    }

    @Override
    public String getAttr(String attrName) {
        if ("insert_job".equals(attrName)) {
            return this.jobName;
        }
        Integer index = this.m_attrName2Index.get(attrName);
        if (index == null || index < 0 || index > this.m_values.length - 1) {
            return null;
        }
        return this.m_values[index];
    }

    @Override
    public Integer setAttr(String attrName, String attrValue) {
        Integer index = this.m_attrName2Index.get(attrName);
        if (index == null) {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            System.err.printf(stackTraceElements[2].getFileName() + "(" + stackTraceElements[2].getMethodName() + "): [setAttr] Unable to locate attr %s in record. Supported attrs are: %s\n", attrName, Arrays.toString(this.m_attrName2Index.keySet().toArray()));
            return null;
        }
        this.m_values[index.intValue()] = attrValue;
        if ("insert_job".equals(attrName)) {
            this.jobName = attrValue;
        }
        return index;
    }

    @Override
    public Integer appendAttr(String attrName, String attrValue) {
        String[] new_values = new String[this.m_values.length + 1];
        System.arraycopy(this.m_values, 0, new_values, 0, this.m_values.length);
        new_values[new_values.length - 1] = attrValue;
        this.m_values = (String[])new_values.clone();
        this.m_attrName2Index.put(attrName, this.m_values.length - 1);
        if ("insert_job".equals(attrName)) {
            this.jobName = attrValue;
        }
        return this.m_values.length - 1;
    }

    @Override
    public boolean isFieldExist(String field) {
        return this.m_attrName2Index.containsKey(field);
    }

    @Override
    public Integer getAttrAsInt(String attrName) {
        String value = this.getAttr(attrName);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static HashMap<String, Integer> buildHeadersMap(CsvReader reader) throws IOException {
        HashMap<String, Integer> header2Index = new HashMap<String, Integer>();
        reader.readHeaders();
        String[] headers = reader.getHeaders();
        int index = 0;
        for (String cur_header : headers) {
            header2Index.put(cur_header, index);
            ++index;
        }
        return header2Index;
    }

    public static HashMap<String, Integer> buildHeadersMap(String header) {
        HashMap<String, Integer> header2Index = new HashMap<String, Integer>();
        String[] headers = header.split(",");
        int index = 0;
        for (String cur_header : headers) {
            header2Index.put(cur_header, index);
            ++index;
        }
        return header2Index;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof AttrHolder)) {
            return false;
        }
        AttrHolder object = (AttrHolder)anObject;
        return this.m_attrName2Index.equals(object.m_attrName2Index) && Arrays.equals(this.m_values, object.m_values);
    }

    public String toString() {
        StringBuilder toRet = new StringBuilder();
        for (int i = 0; i < this.m_values.length; ++i) {
            boolean isQuoted = this.m_values[i].matches(".*[,\"\n\r].*");
            if (isQuoted) {
                toRet.append('\"');
            }
            toRet.append(this.m_values[i].replace("\"", "\"\""));
            if (isQuoted) {
                toRet.append('\"');
            }
            if (i >= this.m_values.length - 1) continue;
            toRet.append(',');
        }
        return toRet.toString();
    }

    @Override
    public String getCsvHeader() {
        StringBuilder header = new StringBuilder();
        HashMap<Integer, String> tmpHM = new HashMap<Integer, String>();
        for (String key : this.m_attrName2Index.keySet()) {
            Integer i = this.m_attrName2Index.get(key);
            tmpHM.put(i, key);
        }
        for (int i = 0; i < tmpHM.size(); ++i) {
            if (i + 1 == tmpHM.size()) {
                header.append((String)tmpHM.get(i));
                continue;
            }
            header.append((String)tmpHM.get(i)).append(",");
        }
        return header.toString();
    }
}

