/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.base.table.AbstractTableFilter;
import com.bmc.ctmconvert.base.table.DistinctColumnItem;
import com.bmc.ctmconvert.base.table.ITableFilter;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.DefaultRowSorter;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class JTableFilter
extends AbstractTableFilter<JTable> {
    private static final long serialVersionUID = 1L;
    private final TableRowFilter filter = new TableRowFilter();
    private TableRowSorter<TableModel> sorter;
    private boolean filterIsApplied;

    public JTableFilter(JTable table) {
        super(table);
    }

    @Override
    protected boolean execute(int col, Collection<DistinctColumnItem> items) {
        RowSorter<? extends TableModel> rs = ((JTable)this.getTable()).getRowSorter();
        if (!(rs instanceof DefaultRowSorter)) {
            return false;
        }
        DefaultRowSorter drs = (DefaultRowSorter)rs;
        RowFilter<Object, Object> prevFilter = drs.getRowFilter();
        if (!(prevFilter instanceof TableRowFilter)) {
            this.filter.setParentFilter(prevFilter);
        }
        drs.setRowFilter(this.filter);
        return true;
    }

    @Override
    public void modelChanged(TableModel model) {
        this.sorter = new TableRowSorter<TableModel>(model){

            @Override
            public boolean isSortable(int column) {
                return super.isSortable(column) && !JTableFilter.this.filterIsApplied;
            }
        };
        this.sorter.setSortsOnUpdates(false);
        ((JTable)this.getTable()).setRowSorter(this.sorter);
    }

    @Override
    public void filterIsApplied(boolean b) {
        this.filterIsApplied = b;
    }

    class TableRowFilter
    extends RowFilter<Object, Object>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private RowFilter<Object, Object> parentFilter;

        TableRowFilter() {
        }

        public RowFilter<Object, Object> getParentFilter() {
            return this.parentFilter;
        }

        public void setParentFilter(RowFilter<Object, Object> parentFilter) {
            this.parentFilter = parentFilter == null || parentFilter == this ? null : parentFilter;
        }

        @Override
        public boolean include(final RowFilter.Entry<? extends Object, ? extends Object> entry) {
            if (this.parentFilter != null && !this.parentFilter.include(entry)) {
                return false;
            }
            return JTableFilter.this.includeRow(new ITableFilter.Row(){

                @Override
                public Object getValue(int column) {
                    return entry.getValue(column);
                }

                @Override
                public int getValueCount() {
                    return entry.getValueCount();
                }
            });
        }
    }
}

