/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.table.BaseTableHeaderButton;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class BaseTable
extends BaseComponent {
    private JPanel jPanel;
    private static DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.US);
    private Dimension tableSize = new Dimension(580, 200);
    private int rowHeight = 18;
    private BaseTableModel tableModel;
    private JTable table;
    private int visibleColumn;
    private int sortCol;
    private boolean isAscent = true;
    private String[] headerStr;
    private boolean enabled;
    private JScrollPane pane;
    private int dateColumn = -1;

    public BaseTable(Object[][] tableData, String[] headerStr, int visibleColumn, Dimension size, Object[] selectedRow) {
        this.tableSize = size;
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BorderLayout());
        this.visibleColumn = visibleColumn;
        this.headerStr = headerStr;
        this.tableModel = new BaseTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int col) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.tableModel.setDataVector(tableData, headerStr);
        this.table = new JTable(this.tableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int Index_row, int Index_col) {
                Component component = super.prepareRenderer(renderer, Index_row, Index_col);
                if (BaseTable.this.table.isEnabled()) {
                    component.setForeground(FlowGlobals.ConversionBlack);
                } else {
                    component.setForeground(FlowGlobals.ConversionDisableColor);
                }
                if (this.isCellSelected(Index_row, Index_col) && BaseTable.this.table.isEnabled()) {
                    component.setBackground(new Color(8832748));
                    component.setForeground(FlowGlobals.ConversionWhite);
                } else if (Index_row % 2 == 0) {
                    component.setBackground(new Color(0xEBEBEB));
                } else {
                    component.setBackground(FlowGlobals.ConversionWhite);
                }
                return component;
            }
        };
        this.table.setShowGrid(true);
        this.table.setBorder(null);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setFillsViewportHeight(true);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(this.tableSize);
        this.table.setRowHeight(this.rowHeight);
        this.table.setIntercellSpacing(new Dimension(3, 0));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BaseTable.this.setValid(BaseTable.this.table.getSelectedRow() != -1);
            }
        });
        this.updateTableData(tableData, selectedRow);
        this.pane = new JScrollPane(this.table);
        this.pane.setBorder(null);
        this.pane.getInsets().set(0, 0, 0, 0);
        this.pane.setViewportBorder(null);
        this.pane.getViewport().setBorder(null);
        this.pane.getViewport().getInsets().set(0, 0, 0, 0);
        this.pane.getViewport().setOpaque(true);
        this.jPanel.setPreferredSize(this.tableSize);
        this.jPanel.setBorder(null);
        this.jPanel.add((Component)this.pane, "Center");
    }

    public void setDateColumn(int column) {
        this.dateColumn = column;
    }

    public void updateTableData(Object[][] tableData) {
        this.updateTableData(tableData, null);
    }

    public void updateTableData(Object[][] tableData, Object[] selected) {
        Object[] selectedRow = selected;
        if (selectedRow == null && tableData != null) {
            selectedRow = this.getSelectedRow();
        }
        this.tableModel.setDataVector(tableData, this.headerStr);
        this.tableModel.getIndexes();
        SortButtonRenderer renderer = new SortButtonRenderer();
        TableColumnModel columnModel = this.table.getColumnModel();
        JTableHeader header = this.table.getTableHeader();
        int n = this.headerStr.length;
        for (int i = 0; i < n; ++i) {
            if (i < this.visibleColumn) {
                columnModel.getColumn(i).setHeaderRenderer(renderer);
                columnModel.getColumn(i).setPreferredWidth(header.getWidth() / this.visibleColumn + 300);
                continue;
            }
            columnModel.getColumn(i).setMinWidth(0);
            columnModel.getColumn(i).setMaxWidth(0);
        }
        header.addMouseListener(new HeaderListener(header, renderer));
        header.setPreferredSize(new Dimension(header.getWidth(), 22));
        header.setReorderingAllowed(false);
        header.setBorder(null);
        if (selectedRow != null) {
            int selectedRowIndex = -1;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                boolean found = false;
                for (int j = 0; j < selectedRow.length && (found = this.table.getValueAt(i, j).toString().equals(selectedRow[j].toString())); ++j) {
                }
                if (!found) continue;
                selectedRowIndex = i;
                break;
            }
            if (selectedRowIndex > -1) {
                this.table.setRowSelectionInterval(selectedRowIndex, selectedRowIndex);
            }
        }
    }

    public void reSortTable() {
        ((BaseTableModel)this.table.getModel()).sortByColumn(this.sortCol, this.isAscent);
    }

    public int rowAtPoint(Point point) {
        return this.table.rowAtPoint(point);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > -1 && rowIndex < this.table.getRowCount() && columnIndex > -1 && columnIndex < this.table.getColumnCount()) {
            return this.table.getModel().getValueAt(rowIndex, columnIndex);
        }
        return null;
    }

    public void setToolTipText(String text) {
        this.table.setToolTipText(text);
    }

    public void removeColumn(int columnIndex) {
        this.table.removeColumn(this.table.getColumnModel().getColumn(columnIndex));
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getSelectedIndex() {
        return this.table.getSelectedRow();
    }

    public Object[] getSelectedRow() {
        int selectedIndex = this.table.getSelectedRow();
        Object[] selectedRow = null;
        if (selectedIndex != -1) {
            int columnCount = this.table.getColumnCount();
            selectedRow = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                selectedRow[i] = this.table.getValueAt(selectedIndex, i);
            }
        }
        return selectedRow;
    }

    @Override
    public JComponent getComponent() {
        return this.jPanel;
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void addMouseListener(MouseListener l) {
        this.table.addMouseListener(l);
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        this.table.addMouseMotionListener(l);
    }

    public void setEnabled(boolean enabled) {
        this.table.setFocusable(enabled);
        this.table.setEnabled(enabled);
        this.enabled = enabled;
        this.pane.getVerticalScrollBar().setEnabled(enabled);
        this.table.getTableHeader().setResizingAllowed(enabled);
        this.table.updateUI();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public static Date getDate(String dateString) {
        Date date = null;
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException ex) {
            date = new Date();
        }
        return date;
    }

    public class BaseTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        int[] indexes;
        TableSorter sorter;

        @Override
        public Object getValueAt(int row, int col) {
            int rowIndex = row;
            if (this.indexes != null) {
                rowIndex = this.indexes[row];
            }
            return super.getValueAt(rowIndex, col);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            int rowIndex = row;
            if (this.indexes != null) {
                rowIndex = this.indexes[row];
            }
            super.setValueAt(value, rowIndex, col);
        }

        public void sortByColumn(int column, boolean isAscent) {
            if (this.sorter == null) {
                this.sorter = new TableSorter(this);
            }
            this.sorter.sort(column, isAscent);
            this.fireTableDataChanged();
        }

        public int[] getIndexes() {
            int n = this.getRowCount();
            if (this.indexes != null && this.indexes.length == n) {
                return this.indexes;
            }
            this.indexes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.indexes[i] = i;
            }
            return this.indexes;
        }
    }

    private class SortButtonRenderer
    extends BaseTableHeaderButton
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        public static final int NONE = 0;
        public static final int DOWN = 1;
        public static final int UP = 2;
        int pushedColumn = -1;
        Hashtable<Integer, Integer> state = new Hashtable();
        BaseTableHeaderButton downButton;
        BaseTableHeaderButton upButton;

        public SortButtonRenderer() {
            this.setHorizontalTextPosition(2);
            this.setIcon(new BlankIcon(BaseTable.this));
            this.downButton = new BaseTableHeaderButton();
            this.downButton.setHorizontalTextPosition(2);
            this.downButton.setIcon(new BevelArrowIcon(BaseTable.this, 1, false, false));
            this.downButton.setPressedIcon(new BevelArrowIcon(BaseTable.this, 1, false, true));
            this.upButton = new BaseTableHeaderButton();
            this.upButton.setHorizontalTextPosition(2);
            this.upButton.setIcon(new BevelArrowIcon(BaseTable.this, 0, false, false));
            this.upButton.setPressedIcon(new BevelArrowIcon(BaseTable.this, 0, false, true));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column >= BaseTable.this.visibleColumn) {
                return null;
            }
            BaseTableHeaderButton button = this;
            Integer obj = this.state.get(new Integer(column));
            if (obj != null) {
                button = obj == 1 ? this.downButton : this.upButton;
            }
            button.setText(value == null ? "" : value.toString());
            boolean isPressed = column == this.pushedColumn;
            button.getModel().setPressed(isPressed);
            button.getModel().setArmed(isPressed);
            button.setEnabled(BaseTable.this.enabled);
            return button;
        }

        public void setPressedColumn(int col) {
            this.pushedColumn = col;
        }

        public void setSelectedColumn(int col) {
            if (col < 0) {
                return;
            }
            Integer value = null;
            Integer obj = this.state.get(new Integer(col));
            value = obj == null ? new Integer(1) : (obj == 1 ? new Integer(2) : new Integer(1));
            this.state.clear();
            this.state.put(new Integer(col), value);
        }

        public int getState(int col) {
            Integer obj = this.state.get(new Integer(col));
            int retValue = obj == null ? 0 : (obj == 1 ? 1 : 2);
            return retValue;
        }
    }

    private class HeaderListener
    extends MouseAdapter {
        JTableHeader header;
        SortButtonRenderer renderer;

        HeaderListener(JTableHeader header, SortButtonRenderer renderer) {
            this.header = header;
            this.renderer = renderer;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (BaseTable.this.enabled) {
                int col = this.header.columnAtPoint(e.getPoint());
                BaseTable.this.sortCol = this.header.getTable().convertColumnIndexToModel(col);
                this.renderer.setPressedColumn(col);
                this.renderer.setSelectedColumn(col);
                this.header.repaint();
                if (this.header.getTable().isEditing()) {
                    this.header.getTable().getCellEditor().stopCellEditing();
                }
                BaseTable.this.isAscent = 1 == this.renderer.getState(col);
                ((BaseTableModel)this.header.getTable().getModel()).sortByColumn(BaseTable.this.sortCol, BaseTable.this.isAscent);
                this.renderer.setPressedColumn(-1);
                this.header.repaint();
            }
        }
    }

    public class BlankIcon
    implements Icon {
        private Color fillColor;
        private int size;

        public BlankIcon(BaseTable this$0) {
            this(this$0, null, 9);
        }

        public BlankIcon(BaseTable this$0, Color color, int size) {
            this.fillColor = color;
            this.size = size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.fillColor != null) {
                g.setColor(this.fillColor);
                g.drawRect(x, y, this.size - 1, this.size - 1);
            }
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private class BevelArrowIcon
    implements Icon {
        public static final int UP = 0;
        public static final int DOWN = 1;
        private static final int DEFAULT_SIZE = 9;
        private Color edge1;
        private Color edge2;
        private Color fill;
        private int size;
        private int direction;

        public BevelArrowIcon(BaseTable baseTable, int direction, boolean isRaisedView, boolean isPressedView) {
            Color col = new Color(0xBCBCBC);
            if (isRaisedView) {
                if (isPressedView) {
                    this.init(col, col, FlowGlobals.fieldDefaultBackground, 9, direction);
                } else {
                    this.init(col, col, FlowGlobals.fieldDefaultBackground, 9, direction);
                }
            } else if (isPressedView) {
                this.init(col, col, FlowGlobals.fieldDefaultBackground, 9, direction);
            } else {
                this.init(col, col, FlowGlobals.fieldDefaultBackground, 9, direction);
            }
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            switch (this.direction) {
                case 1: {
                    this.drawDownArrow(g, x, y);
                    break;
                }
                case 0: {
                    this.drawUpArrow(g, x, y);
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        private void init(Color edge1, Color edge2, Color fill, int size, int direction) {
            this.edge1 = edge1;
            this.edge2 = edge2;
            this.fill = fill;
            this.size = size;
            this.direction = direction;
        }

        private void drawDownArrow(Graphics g, int xo, int yo) {
            g.setColor(this.edge1);
            g.drawLine(xo, yo, xo + this.size - 1, yo);
            g.drawLine(xo, yo + 1, xo + this.size - 3, yo + 1);
            g.setColor(this.edge2);
            g.drawLine(xo + this.size - 2, yo + 1, xo + this.size - 1, yo + 1);
            int x = xo + 1;
            int y = yo + 2;
            int dx = this.size - 6;
            while (y + 1 < yo + this.size) {
                g.setColor(this.edge1);
                g.drawLine(x, y, x + 1, y);
                g.drawLine(x, y + 1, x + 1, y + 1);
                if (0 < dx) {
                    g.setColor(this.fill);
                    g.drawLine(x + 2, y, x + 1 + dx, y);
                    g.drawLine(x + 2, y + 1, x + 1 + dx, y + 1);
                }
                g.setColor(this.edge2);
                g.drawLine(x + dx + 2, y, x + dx + 3, y);
                g.drawLine(x + dx + 2, y + 1, x + dx + 3, y + 1);
                ++x;
                y += 2;
                dx -= 2;
            }
            g.setColor(this.edge1);
            g.drawLine(xo + this.size / 2, yo + this.size - 1, xo + this.size / 2, yo + this.size - 1);
        }

        private void drawUpArrow(Graphics g, int xo, int yo) {
            g.setColor(this.edge1);
            int x = xo + this.size / 2;
            g.drawLine(x, yo, x, yo);
            --x;
            int y = yo + 1;
            int dx = 0;
            while (y + 3 < yo + this.size) {
                g.setColor(this.edge1);
                g.drawLine(x, y, x + 1, y);
                g.drawLine(x, y + 1, x + 1, y + 1);
                if (0 < dx) {
                    g.setColor(this.fill);
                    g.drawLine(x + 2, y, x + 1 + dx, y);
                    g.drawLine(x + 2, y + 1, x + 1 + dx, y + 1);
                }
                g.setColor(this.edge2);
                g.drawLine(x + dx + 2, y, x + dx + 3, y);
                g.drawLine(x + dx + 2, y + 1, x + dx + 3, y + 1);
                --x;
                y += 2;
                dx += 2;
            }
            g.setColor(this.edge1);
            g.drawLine(xo, yo + this.size - 3, xo + 1, yo + this.size - 3);
            g.setColor(this.edge2);
            g.drawLine(xo + 2, yo + this.size - 2, xo + this.size - 1, yo + this.size - 2);
            g.drawLine(xo, yo + this.size - 1, xo + this.size, yo + this.size - 1);
        }
    }

    public class TableSorter {
        BaseTableModel model;

        public TableSorter(BaseTableModel model) {
            this.model = model;
        }

        public void sort(int column, boolean isAscent) {
            int n = this.model.getRowCount();
            int[] indexes = this.model.getIndexes();
            for (int i = 0; i < n - 1; ++i) {
                int k = i;
                for (int j = i + 1; j < n; ++j) {
                    if (isAscent) {
                        if (this.compare(column, j, k) >= 0) continue;
                        k = j;
                        continue;
                    }
                    if (this.compare(column, j, k) <= 0) continue;
                    k = j;
                }
                int tmp = indexes[i];
                indexes[i] = indexes[k];
                indexes[k] = tmp;
            }
        }

        public int compare(int column, int row1, int row2) {
            Object o1 = this.model.getValueAt(row1, column);
            Object o2 = this.model.getValueAt(row2, column);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (column == BaseTable.this.dateColumn) {
                return this.compare(this.getDateByDateStringAndFormat((String)o1, "dd-MM-yyyy HH:mm"), this.getDateByDateStringAndFormat((String)o2, "dd-MM-yyyy HH:mm"));
            }
            Class<?> type = this.model.getColumnClass(column);
            if (type.getSuperclass() == Number.class) {
                return this.compare((Number)o1, (Number)o2);
            }
            if (type == String.class) {
                return ((String)o1).compareTo((String)o2);
            }
            if (type == Date.class) {
                return this.compare((Date)o1, (Date)o2);
            }
            if (type == Boolean.class) {
                return this.compare((Boolean)o1, (Boolean)o2);
            }
            return ((String)o1).compareTo((String)o2);
        }

        private Date getDateByDateStringAndFormat(String date, String format) {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            try {
                return formatter.parse(date);
            }
            catch (ParseException e) {
                ExceptionHandler.writeToExceptionFile(e);
                return null;
            }
        }

        public int compare(Number o1, Number o2) {
            double n2;
            double n1 = o1.doubleValue();
            if (n1 < (n2 = o2.doubleValue())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }

        public int compare(Date o1, Date o2) {
            long n2;
            long n1 = o1.getTime();
            if (n1 < (n2 = o2.getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }

        public int compare(Boolean o1, Boolean o2) {
            boolean b2;
            boolean b1 = o1;
            if (b1 == (b2 = o2.booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }

        public int compare(String s1, String s2) {
            int val2;
            int val1;
            int i;
            ArrayList<String> sa1 = this.split(s1);
            ArrayList<String> sa2 = this.split(s2);
            if (sa1.size() == 0 || sa1.size() != sa2.size()) {
                return s1.compareTo(s2);
            }
            String si1 = "";
            String si2 = "";
            for (i = 0; i < sa1.size() && (si1 = sa1.get(i)).equals(si2 = sa2.get(i)); ++i) {
            }
            if (i == sa1.size()) {
                return 0;
            }
            try {
                val1 = Integer.parseInt(si1);
                val2 = Integer.parseInt(si2);
            }
            catch (NumberFormatException e) {
                return s1.compareTo(s2);
            }
            ++i;
            while (i < sa1.size()) {
                si1 = sa1.get(i);
                if (!si1.equals(si2 = sa2.get(i))) {
                    return s1.compareTo(s2);
                }
                ++i;
            }
            return val1 < val2 ? -1 : 1;
        }

        ArrayList<String> split(String s) {
            ArrayList<String> r = new ArrayList<String>();
            Pattern splitter = Pattern.compile("(\\d+|\\D+)");
            Matcher matcher = splitter.matcher(s);
            while (matcher.find()) {
                String m = matcher.group(1);
                r.add(m);
            }
            return r;
        }
    }
}

