/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.base.table.CollectionUtils;
import com.bmc.ctmconvert.base.table.DistinctColumnItem;
import com.bmc.ctmconvert.base.table.IFilterChangeListener;
import com.bmc.ctmconvert.base.table.ITableFilter;
import com.bmc.ctmconvert.base.table.TableFilterState;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class AbstractTableFilter<T extends JTable>
implements ITableFilter<T> {
    private static final long serialVersionUID = 1L;
    private final Set<IFilterChangeListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Map<Integer, Collection<DistinctColumnItem>> distinctItemCache = Collections.synchronizedMap(new HashMap());
    private final T table;
    private final TableFilterState filterState = new TableFilterState();

    public AbstractTableFilter(T table) {
        this.table = table;
        this.setupDistinctItemCacheRefresh();
    }

    private void setupDistinctItemCacheRefresh() {
        this.clearDistinctItemCache();
        ((Container)this.table).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AbstractTableFilter.this.clearDistinctItemCache();
                TableModel model = (TableModel)e.getNewValue();
                if (model != null) {
                    model.addTableModelListener(new TableModelListener(){

                        @Override
                        public void tableChanged(TableModelEvent e) {
                            AbstractTableFilter.this.clearDistinctItemCache();
                        }
                    });
                }
            }
        });
    }

    private void clearDistinctItemCache() {
        this.distinctItemCache.clear();
    }

    @Override
    public T getTable() {
        return this.table;
    }

    protected abstract boolean execute(int var1, Collection<DistinctColumnItem> var2);

    @Override
    public boolean apply(int col, Collection<DistinctColumnItem> items) {
        this.setFilterState(col, items);
        boolean result = false;
        result = this.execute(col, items);
        if (result) {
            this.fireFilterChange();
        }
        return result;
    }

    @Override
    public final void addChangeListener(IFilterChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public final void removeChnageListener(IFilterChangeListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public final void fireFilterChange() {
        for (IFilterChangeListener l : this.listeners) {
            l.filterChanged(this);
        }
    }

    @Override
    public Collection<DistinctColumnItem> getDistinctColumnItems(int column) {
        Collection<DistinctColumnItem> result = this.distinctItemCache.get(column);
        if (result == null) {
            result = this.collectDistinctColumnItems(column);
            this.distinctItemCache.put(column, result);
        }
        return result;
    }

    private Collection<DistinctColumnItem> collectDistinctColumnItems(int column) {
        HashSet<DistinctColumnItem> set = new HashSet<DistinctColumnItem>();
        int nullIndex = -1;
        for (int row = 0; row < ((JTable)this.table).getModel().getRowCount(); ++row) {
            Object value = ((JTable)this.table).getModel().getValueAt(row, column);
            if (value == null) {
                nullIndex = row;
                continue;
            }
            set.add(new DistinctColumnItem(value, row));
        }
        ArrayList<DistinctColumnItem> result = new ArrayList<DistinctColumnItem>(set);
        if (nullIndex >= 0) {
            result.add(0, new DistinctColumnItem(null, nullIndex));
        }
        return CollectionUtils.trySort(result);
    }

    @Override
    public Collection<DistinctColumnItem> getFilterState(int column) {
        return this.filterState.getValues(column);
    }

    @Override
    public boolean isFiltered(int column) {
        Collection<DistinctColumnItem> checks = this.getFilterState(column);
        return !CollectionUtils.isEmpty(checks) && this.getDistinctColumnItems(column).size() != checks.size();
    }

    @Override
    public boolean includeRow(ITableFilter.Row row) {
        return this.filterState.include(row);
    }

    public void setFilterState(int column, Collection<DistinctColumnItem> values) {
        this.filterState.setValues(column, values);
    }

    @Override
    public void clear() {
        this.filterState.clear();
        List<DistinctColumnItem> items = Collections.emptyList();
        for (int column = 0; column < ((JTable)this.table).getModel().getColumnCount(); ++column) {
            this.execute(column, items);
        }
        this.fireFilterChange();
    }
}

