/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.list;

import com.bmc.ctmconvert.base.BaseGradientPanel;
import com.bmc.ctmconvert.base.list.BaseItem;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Properties;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BaseListItem
extends BaseItem {
    private String details;
    private boolean deleteEnabled;
    protected int lineHeight = 22;
    protected JPanel itemLabelPanel;
    protected JPanel itemDeletePanel;
    private Map<String, String> detailsTitles;
    private JLabel nameLabel;

    public BaseListItem(Properties data) {
        super(data);
        this.initialize();
    }

    public BaseListItem(Properties data, Map<String, String> detailsTitles) {
        super(data);
        this.detailsTitles = detailsTitles;
        this.initialize();
    }

    public BaseListItem(BaseItem baseItem) {
        super(baseItem.data);
        this.data = baseItem.data;
        this.itemPanel = baseItem.itemPanel;
        this.selected = baseItem.selected;
    }

    protected void initialize() {
        MouseAdapter itemListener = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (BaseListItem.this.enabled) {
                    if (BaseListItem.this.deleteEnabled) {
                        BaseListItem.this.itemDeletePanel.setVisible(false);
                    }
                    if (!BaseListItem.this.selected) {
                        BaseListItem.this.nameLabel.setForeground(FlowGlobals.ConversionBlack);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (BaseListItem.this.enabled) {
                    if (BaseListItem.this.deleteEnabled) {
                        BaseListItem.this.itemDeletePanel.setVisible(true);
                    }
                    Color conversionColor = ThemeConfiguration.get().getHoverTextColor();
                    BaseListItem.this.nameLabel.setForeground(conversionColor);
                }
            }
        };
        this.itemPanel = new BaseGradientPanel(new Color(-7309), new Color(-278423));
        this.itemPanel.setLayout(new BoxLayout(this.itemPanel, 0));
        this.itemPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.itemPanel.add(Box.createRigidArea(new Dimension(10, this.lineHeight)));
        this.itemLabelPanel = new JPanel();
        this.itemLabelPanel.setLayout(new BoxLayout(this.itemLabelPanel, 0));
        this.itemLabelPanel.setOpaque(false);
        this.nameLabel = new JLabel(this.data.getProperty("NAME"));
        this.itemLabelPanel.add(this.nameLabel);
        this.itemLabelPanel.add(Box.createHorizontalGlue());
        this.itemPanel.add(this.itemLabelPanel);
        this.itemDeletePanel = new JPanel();
        this.itemDeletePanel.setOpaque(false);
        this.itemDeletePanel.setLayout(new BoxLayout(this.itemDeletePanel, 0));
        this.itemDeletePanel.add(Box.createRigidArea(new Dimension(3, 0)));
        this.itemDeletePanel.addMouseListener(itemListener);
        JLabel delete = new JLabel();
        delete.setIcon(FlowGlobals.LIST_ITEM_DELETE_ICON);
        this.itemDeletePanel.add(delete);
        this.itemDeletePanel.add(Box.createRigidArea(new Dimension(3, 0)));
        this.itemPanel.add(this.itemDeletePanel);
        this.itemDeletePanel.setVisible(false);
        this.itemPanel.addMouseListener(itemListener);
        this.details = this.getDetailsStr();
    }

    private String getDetailsStr() {
        StringBuilder detailsBuilder = new StringBuilder();
        if (this.detailsTitles != null) {
            for (String key : this.detailsTitles.keySet()) {
                this.appendDetailsLine(detailsBuilder, this.detailsTitles.get(key), this.data.getProperty(key));
            }
        } else {
            for (String key : this.data.stringPropertyNames()) {
                this.appendDetailsLine(detailsBuilder, key, this.data.getProperty(key));
            }
        }
        return detailsBuilder.toString();
    }

    private void appendDetailsLine(StringBuilder detailsBuilder, String key, String value) {
        if (value != null && !value.isEmpty()) {
            detailsBuilder.append(String.format("%-1s\t: %s", key, value)).append("\n");
        }
    }

    @Override
    public void setSelected(boolean aFlag) {
        this.selected = aFlag;
        this.setItemSelectedHoverView(aFlag);
    }

    public void setHover(boolean aFlag) {
        this.setItemSelectedHoverView(aFlag);
        if (this.deleteEnabled) {
            this.itemDeletePanel.setVisible(aFlag);
        }
    }

    public void setItemSelectedHoverView(boolean aFlag) {
        Color conversionColor = ThemeConfiguration.get().getHoverTextColor();
        this.nameLabel.setForeground(aFlag ? conversionColor : FlowGlobals.ConversionBlack);
        if (!aFlag && this.deleteEnabled) {
            this.itemDeletePanel.setVisible(aFlag);
        }
    }

    public void setDeleteEnabled(boolean aFlag) {
        this.deleteEnabled = aFlag;
    }

    public void addDeleteAction(final Action l) {
        this.itemDeletePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (BaseListItem.this.enabled) {
                    l.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Delete"));
                }
            }
        });
        this.itemPanel.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                System.out.println("keyTyped");
            }

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println("keyReleased");
            }

            @Override
            public void keyPressed(KeyEvent e) {
                System.out.println("keyPressed");
                if (BaseListItem.this.enabled && e.getKeyCode() == 127) {
                    l.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Delete"));
                }
            }
        });
    }

    public String getDetails() {
        return this.details;
    }
}

