/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ConversionProcessSearcher;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.services.FilesManager;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class UpdaterProcessor {
    private FilesManager filesManager = new FilesManager();
    private final String targetClassInUpdater = "com.bmc.ctmconvert.conversion_updater.ConversionUpdater";
    private final String tempJarsDirName = "update_temp";
    private final String updaterJarName = "ConversionUpdater-ctmconvert.jar";
    private final String tempFolderName = "temp";
    private Path jarsFolderPath;
    private ConversionProcessSearcher processSearcher = new ConversionProcessSearcher();

    public UpdaterProcessor() {
        this.jarsFolderPath = Paths.get(Globs.HOME_DIR + Globs.DIRSEP + "temp" + Globs.DIRSEP + "update_temp", new String[0]);
    }

    public void executeUpdate() throws IOException {
        boolean isAnotherRunning = this.isAnotherConversionProcessRunning();
        if (isAnotherRunning) {
            return;
        }
        this.prepareJarsFolder();
        String conversionProcessName = ManagementFactory.getRuntimeMXBean().getName();
        String conversionProcessPID = conversionProcessName.split("@")[0];
        String updaterLocation = this.jarsFolderPath.toString() + Globs.DIRSEP + "ConversionUpdater-ctmconvert.jar";
        ProcessBuilder processBuilder = new ProcessBuilder("java", "-cp", updaterLocation, "com.bmc.ctmconvert.conversion_updater.ConversionUpdater", conversionProcessPID);
        processBuilder.start();
    }

    private void prepareJarsFolder() throws IOException {
        if (!Files.exists(this.jarsFolderPath, new LinkOption[0])) {
            this.filesManager.createFolder(this.jarsFolderPath);
        }
        this.filesManager.copyFileToDirectory(Globs.commonJarPath, this.jarsFolderPath);
        this.filesManager.copyFileToDirectory(Globs.updaterJarPath, this.jarsFolderPath);
        this.filesManager.copyFileToDirectory(Globs.commonNetJarPath, this.jarsFolderPath);
    }

    private boolean isAnotherConversionProcessRunning() throws IOException {
        ConversionProcessSearcher.ProcessStatus conversionStatus = this.processSearcher.searchProcess(ConversionProcessSearcher.ProcessTag.Conversion);
        ConversionProcessSearcher.ProcessStatus selfConversionStatus = this.processSearcher.searchProcess(ConversionProcessSearcher.ProcessTag.SelfConversion);
        if (conversionStatus.equals((Object)ConversionProcessSearcher.ProcessStatus.Running) || selfConversionStatus.equals((Object)ConversionProcessSearcher.ProcessStatus.Running)) {
            BaseMessageDialog.showMessageDialog(TextManager.instance().get("CLOSE_ALL_CONVERSIONS_BEFORE_UPDATE_TITLE"), TextManager.instance().get("CLOSE_ALL_CONVERSIONS_BEFORE_UPDATE_TEXT"), BaseMessageDialog.TYPE.ERROR_MESSAGE);
            return true;
        }
        return false;
    }
}

