/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class SpinnerCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    JSpinner spinner;
    JSpinner.DefaultEditor editor;
    JTextField textField;
    boolean valueSet;
    NumberSpinnerFilter filter;
    SpinnerNumberModel model;
    int maxValue;
    int minValue;

    public SpinnerCellEditor(int value, int minimum, int maximum, int stepSize) {
        super(new JTextField());
        this.maxValue = maximum;
        this.minValue = minimum;
        this.filter = new NumberSpinnerFilter(this);
        SpinnerNumberModel model = new SpinnerNumberModel(value, minimum, maximum, stepSize);
        this.spinner = new JSpinner(model);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerCellEditor.this.resetFilter();
            }
        });
        this.editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        this.textField = this.editor.getTextField();
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                SpinnerCellEditor.this.resetFilter();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SpinnerCellEditor.this.valueSet) {
                            SpinnerCellEditor.this.textField.setCaretPosition(1);
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent fe) {
            }
        });
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SpinnerCellEditor.this.stopCellEditing();
            }
        });
    }

    private void resetFilter() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)SpinnerCellEditor.this.spinner.getEditor();
                JFormattedTextField field = editor.getTextField();
                AbstractDocument doc = (AbstractDocument)field.getDocument();
                SpinnerCellEditor.this.filter.field = field;
                SpinnerCellEditor.this.filter.doc = doc;
                doc.setDocumentFilter(SpinnerCellEditor.this.filter);
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (!this.valueSet) {
            this.spinner.setValue(value);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpinnerCellEditor.this.textField.requestFocus();
            }
        });
        return this.spinner;
    }

    @Override
    public boolean isCellEditable(EventObject eo) {
        if (eo instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)eo;
            this.textField.setText(String.valueOf(ke.getKeyChar()));
            this.valueSet = true;
        } else {
            this.valueSet = false;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.spinner.getValue();
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.editor.commitEdit();
            this.spinner.commitEdit();
        }
        catch (ParseException e) {
            JOptionPane opt = new JOptionPane("Enter Numbers Only from " + Integer.toString(this.minValue) + " to " + Integer.toString(this.maxValue), 0, -1, null, new Object[0]);
            final JDialog dlg = opt.createDialog("Error");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                        dlg.dispose();
                    }
                    catch (Exception e) {
                        ConversionLogger.getLogger().info(e.getMessage());
                        ExceptionHandler.writeToExceptionFile(e);
                    }
                }
            }).start();
            dlg.setVisible(true);
        }
        return super.stopCellEditing();
    }

    class NumberSpinnerFilter
    extends DocumentFilter {
        JFormattedTextField field;
        Document doc;
        String oldValue;
        String newValue;

        NumberSpinnerFilter(SpinnerCellEditor this$0) {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            this.oldValue = this.doc.getText(0, this.doc.getLength());
            this.newValue = this.oldValue.substring(0, offset) + string + this.oldValue.substring(offset);
            super.insertString(fb, offset, string, attr);
            if (this.validateEntry()) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            this.oldValue = this.doc.getText(0, this.doc.getLength());
            this.newValue = this.oldValue.substring(0, offset) + text + this.oldValue.substring(offset + length);
            if (this.validateEntry()) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        private boolean validateEntry() throws BadLocationException {
            if (!GlobalFunctions.isNumber(this.newValue)) {
                Toolkit.getDefaultToolkit().beep();
                return false;
            }
            return true;
        }
    }
}

