/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;

public class HtmlMessageDialog
extends BaseMessageDialog {
    public HtmlMessageDialog(String title, String message, BaseMessageDialog.TYPE type, String chBMsg, boolean check) {
        super(false, null, null);
        okDefaultValue = true;
        BaseMessageDialog.checkBoxMsg = chBMsg;
        BaseMessageDialog.checkBoxCheked = check;
    }

    @Override
    void setDialogResizePolicy() {
        this.jDialog.setResizable(true);
    }

    @Override
    protected int getMinWidth() {
        return 0;
    }

    @Override
    protected int getMinHeight() {
        return 0;
    }

    @Override
    protected void otherTypesCase(JPanel messagePanel, String message, BaseMessageDialog.TYPE type) {
        messagePanel.setLayout(new FlowLayout(3));
        JLabel iconLabel = new JLabel(HtmlMessageDialog.getImageIconByType(type));
        messagePanel.add(iconLabel);
        messagePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JTextComponent messageArea = this.getHtmlTextComponent(message);
        messageArea.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        messageArea.setEditable(false);
        messageArea.setBackground(FlowGlobals.ConversionWhite);
        messagePanel.add(messageArea);
    }

    @Override
    void addPanelsToDialogContent(Container dialogContent, JPanel messagePanel, JPanel footerPanel) {
        JScrollPane jScrollPane = new JScrollPane(messagePanel);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        dialogContent.add((Component)jScrollPane, "Center");
        dialogContent.add((Component)footerPanel, "South");
    }

    protected JTextComponent getHtmlTextComponent(String message) {
        JTextPane htmlPane = new JTextPane();
        htmlPane.setOpaque(false);
        htmlPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        htmlPane.setText(message);
        htmlPane.addHyperlinkListener(new HyperlinkListener(this){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(new URI(String.valueOf(e.getURL())));
                    }
                    catch (IOException | URISyntaxException e1) {
                        ConversionLogger.getLogger().info(e1.toString());
                    }
                }
            }
        });
        return htmlPane;
    }
}

