/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import java.awt.Rectangle;
import javax.swing.JComponent;

public final class BaseScrollUtil {
    public static final int NONE = 0;
    public static final int TOP = 1;
    public static final int VCENTER = 2;
    public static final int BOTTOM = 4;
    public static final int LEFT = 8;
    public static final int HCENTER = 16;
    public static final int RIGHT = 32;
    public static final int LMONTH = 64;
    public static final int RMONTH = 128;
    public static final int LYEAR = 256;
    public static final int RYEAR = 512;
    public static final int CUSTOM = 1024;
    private static final int OFFSET = 100;
    private static final int CELL_WIDTH = 27;

    private BaseScrollUtil() {
    }

    public static void scroll(JComponent c, int part) {
        BaseScrollUtil.scroll(c, part & 0x7F8, part & 7, 0);
    }

    public static void scroll(JComponent c, int part, int amount) {
        BaseScrollUtil.scroll(c, part & 0x7F8, part & 7, amount);
    }

    private static void scroll(JComponent c, int horizontal, int vertical, int amount) {
        Rectangle visible = c.getVisibleRect();
        Rectangle bounds = c.getBounds();
        switch (vertical) {
            case 1: {
                visible.y = 0;
                break;
            }
            case 2: {
                visible.y = (bounds.height - visible.height) / 2;
                break;
            }
            case 4: {
                visible.y = bounds.height - visible.height + 100;
            }
        }
        switch (horizontal) {
            case 8: {
                visible.x = 0;
                break;
            }
            case 16: {
                visible.x = (bounds.width - visible.width) / 2;
                break;
            }
            case 32: {
                visible.x = bounds.width - visible.width + 100;
                break;
            }
            case 64: {
                visible.x -= 810;
                break;
            }
            case 128: {
                visible.x += 810;
                break;
            }
            case 256: {
                visible.x -= 9720;
                break;
            }
            case 512: {
                visible.x += 9720;
                break;
            }
            case 1024: {
                visible.x = amount * 27;
            }
        }
        c.scrollRectToVisible(visible);
    }
}

