/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseLabel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.DialogFactory;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import com.bmc.ctmconvert.configuration.themes.ProgressBarTheme;
import com.bmc.ctmconvert.progress.Progressable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class BaseProgressBar {
    private final ProgressBarTheme theme = ThemeConfiguration.get().getProgressBarTheme();
    private JDialog jDialog;
    private int width = 310;
    private int height = 165;
    private JProgressBar progressBar;
    private BaseLabel label;
    private BaseLabel labelDesc;
    private boolean displayDesc;
    private static final int MINIMUM = 0;
    private static final int MAXIMUM = 100;
    private SwingWorker<?, ?> task;
    private Progressable progressableTask;
    private String title;
    private boolean canceled;

    public BaseProgressBar(String title) {
        this.title = title;
        this.initialize();
    }

    public BaseProgressBar(String title, SwingWorker<?, ?> task) {
        this.task = task;
        this.title = title;
        this.initialize();
    }

    public BaseProgressBar(String title, Progressable progressableTask) {
        this.progressableTask = progressableTask;
        this.title = title;
        this.initialize();
    }

    private void initialize() {
        this.jDialog = DialogFactory.instance().getLinkedDialog();
        this.jDialog.setModal(true);
        this.jDialog.setSize(new Dimension(this.width, this.height));
        this.jDialog.setTitle(this.title);
        this.jDialog.setLayout(new BorderLayout());
        this.jDialog.setResizable(false);
        this.jDialog.setDefaultCloseOperation(0);
        this.jDialog.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(FlowGlobals.BMC_ICON_PATH)));
        this.jDialog.setLocationRelativeTo(SwingUtilities.getRoot(this.jDialog.getParent()));
        this.jDialog.setBackground(Color.WHITE);
        this.jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BaseProgressBar.this.progressCancelClick();
            }
        });
        this.jDialog.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                BaseProgressBar.this.jDialog.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseProgressBar.this.jDialog.setCursor(Cursor.getPredefinedCursor(3));
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setSize(new Dimension(this.width, this.height - 30));
        SpringLayout layout = new SpringLayout();
        mainPanel.setLayout(layout);
        mainPanel.setBackground(Color.WHITE);
        this.label = new BaseLabel("");
        this.label.getComponent().setPreferredSize(new Dimension(270, 16));
        this.labelDesc = new BaseLabel("");
        this.labelDesc.getComponent().setPreferredSize(new Dimension(270, 16));
        layout.putConstraint("West", (Component)this.label.getComponent(), 10, "West", (Component)mainPanel);
        layout.putConstraint("North", (Component)this.label.getComponent(), 15, "North", (Component)mainPanel);
        mainPanel.add(this.label.getComponent());
        layout.putConstraint("West", (Component)this.labelDesc.getComponent(), 20, "West", (Component)mainPanel);
        layout.putConstraint("North", (Component)this.labelDesc.getComponent(), 30, "North", (Component)mainPanel);
        mainPanel.add(this.labelDesc.getComponent());
        this.labelDesc.getComponent().setVisible(this.displayDesc);
        this.progressBar = new JProgressBar();
        this.progressBar.setPreferredSize(new Dimension(270, 16));
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setVisible(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBackground(this.theme.backgroundColor);
        this.progressBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.theme.outsideBorderColor), BorderFactory.createMatteBorder(1, 1, 1, 1, this.theme.insideBorderColor)));
        this.progressBar.setForeground(this.theme.foregroundColor);
        layout.putConstraint("West", (Component)this.progressBar, 20, "West", (Component)mainPanel);
        layout.putConstraint("North", (Component)this.progressBar, 60, "North", (Component)mainPanel);
        mainPanel.add(this.progressBar);
        this.jDialog.add((Component)mainPanel, "Center");
        JPanel footerPanel = new JPanel();
        footerPanel.setPreferredSize(new Dimension(300, 35));
        footerPanel.setBackground(FlowGlobals.ConversionGray);
        footerPanel.setLayout(new BoxLayout(footerPanel, 0));
        footerPanel.add(Box.createHorizontalGlue());
        footerPanel.add(ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.CANCEL, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseProgressBar.this.progressCancelClick();
            }
        }));
        footerPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.jDialog.add((Component)footerPanel, "South");
    }

    public void setSnakeLook(boolean b) {
        this.progressBar.setIndeterminate(b);
        this.progressBar.setStringPainted(!b);
    }

    protected void progressCancelClick() {
        this.setLabel("Aborting... (May take a while)");
        if (this.task != null) {
            this.task.cancel(false);
        } else if (this.progressableTask != null) {
            this.canceled = true;
            this.progressableTask.stop();
        } else {
            this.canceled = true;
            this.dispose();
        }
    }

    public boolean isCancelled() {
        if (this.task != null) {
            return this.task.isCancelled();
        }
        return this.canceled;
    }

    public void setDisplayDescription(boolean b) {
        this.displayDesc = b;
        this.labelDesc.getComponent().setVisible(this.displayDesc);
    }

    public void setDescription(String text) {
        this.labelDesc.setText(text);
    }

    public void setLabel(String text) {
        String msg = String.format(text, new Object[0]);
        this.label.setText(msg);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setProgressValue(int percent) {
        this.progressBar.setValue(percent);
    }

    public int getProgressValue() {
        return this.progressBar.getValue();
    }

    public void setProgressMin(int min) {
        this.progressBar.setMinimum(min);
    }

    public int getProgressMin() {
        return this.progressBar.getMinimum();
    }

    public void setProgressMax(int max) {
        this.progressBar.setMaximum(max);
    }

    public int getProgressMax() {
        return this.progressBar.getMaximum();
    }

    public void setProgressMinMax(int min, int max) {
        this.progressBar.setMinimum(min);
        this.progressBar.setMaximum(max);
    }

    public SwingWorker<?, ?> getTask() {
        return this.task;
    }

    public Progressable getProgressableTask() {
        return this.progressableTask;
    }

    public void setVisible(boolean b) {
        this.jDialog.setVisible(b);
    }

    public void dispose() {
        this.jDialog.dispose();
    }
}

