/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseListCellRenderer;
import com.bmc.ctmconvert.base.BaseSimpleWaterMarkTextField;
import com.bmc.ctmconvert.base.table.BaseTableHeaserGradientPanel;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BaseListBox
extends BaseComponent {
    private JPanel jPanel;
    private JScrollPane scrollPane;
    private Object[] listData;
    private JList jList;
    private int rowHeight = 20;
    private boolean search;

    public BaseListBox(Object[] listData) {
        this.listData = listData;
        this.initialize();
    }

    public BaseListBox(Object[] listData, boolean search) {
        this.listData = listData;
        this.search = search;
        this.initialize();
    }

    private void initialize() {
        this.jPanel = new JPanel();
        this.jPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, FlowGlobals.ConversionTableBorderColor));
        this.jPanel.setLayout(new BorderLayout());
        BaseSimpleWaterMarkTextField filterBox = null;
        if (this.search) {
            JPanel toolbarPanel = new JPanel();
            toolbarPanel.setBorder(BorderFactory.createEmptyBorder(3, 7, 3, 7));
            toolbarPanel.setBackground(FlowGlobals.ConversionGray);
            toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 0));
            JLabel fiterIcon = new JLabel(new ImageIcon(FlowGlobals.class.getResource("/img/icon_filter.png")));
            toolbarPanel.add(fiterIcon);
            toolbarPanel.add(Box.createRigidArea(new Dimension(5, 1)));
            filterBox = new BaseSimpleWaterMarkTextField(TextManager.instance().get("MAIN_NAVIGATION_FIND_STR"));
            toolbarPanel.add(filterBox.getComponent());
            toolbarPanel.add(Box.createRigidArea(new Dimension(230, 1)));
            this.jPanel.add((Component)toolbarPanel, "North");
            BaseTableHeaserGradientPanel headerPanel = new BaseTableHeaserGradientPanel();
            headerPanel.setLayout(new BoxLayout(headerPanel, 0));
            headerPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            headerPanel.setPreferredSize(new Dimension(1, 22));
            headerPanel.add(Box.createHorizontalGlue());
            this.jPanel.add((Component)headerPanel, "Center");
        }
        DefaultListModel<Object> source = new DefaultListModel<Object>();
        for (int index = 0; index < this.listData.length; ++index) {
            source.addElement(this.listData[index]);
        }
        FilteredListModel filteredListModel = new FilteredListModel(source, filterBox);
        this.jList = new JList(filteredListModel);
        this.jList.setCellRenderer(new BaseListCellRenderer());
        this.jList.setFixedCellHeight(this.rowHeight);
        this.jList.setSelectionMode(0);
        this.jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BaseListBox.this.setValid(BaseListBox.this.isValid());
                BaseListBox.this.setValidityLook(BaseListBox.this.isValid());
            }
        });
        this.scrollPane = new JScrollPane(this.jList, 20, 30);
        this.scrollPane.setPreferredSize(new Dimension(250, 160));
        this.jPanel.add((Component)this.scrollPane, "South");
    }

    public String getSelectedValue() {
        return (String)this.jList.getSelectedValue();
    }

    public void setHeight(int width, int height) {
        this.scrollPane.setPreferredSize(new Dimension(width, height));
    }

    public void addListSelectionListener(ListSelectionListener x) {
        this.jList.getSelectionModel().addListSelectionListener(x);
    }

    public void addMouseListener(MouseListener l) {
        this.jList.addMouseListener(l);
    }

    public void clearSelection() {
        this.jList.clearSelection();
    }

    @Override
    public Component getComponent() {
        return this.jPanel;
    }

    @Override
    public boolean isValid() {
        return this.jList.getSelectedIndex() > -1;
    }

    class FilteredListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private final ListModel _source;
        private final BaseSimpleWaterMarkTextField _filter;
        private final ArrayList<Integer> _indices = new ArrayList();

        public FilteredListModel(ListModel source, BaseSimpleWaterMarkTextField filter) {
            if (source == null) {
                throw new IllegalArgumentException("Source is null");
            }
            this._source = source;
            this._filter = filter;
            if (this._filter != null) {
                ((JTextField)this._filter.getComponent()).getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        FilteredListModel.this.doFilter();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        FilteredListModel.this.doFilter();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        FilteredListModel.this.doFilter();
                    }
                });
            }
            this.doFilter();
        }

        private void doFilter() {
            this._indices.clear();
            if (this._filter != null) {
                int count = this._source.getSize();
                for (int i = 0; i < count; ++i) {
                    Object element = this._source.getElementAt(i);
                    String text = this._filter.getText();
                    if (!text.isEmpty() && !((String)element).toUpperCase().contains(text.toUpperCase())) continue;
                    this._indices.add(i);
                }
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }

        @Override
        public int getSize() {
            return this._filter != null ? this._indices.size() : this._source.getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return this._filter != null ? this._source.getElementAt(this._indices.get(index)) : this._source.getElementAt(index);
        }
    }
}

