/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class BaseGradientPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color startColor;
    private Color endColor;
    private boolean isGradient;

    public BaseGradientPanel() {
        this(Color.GRAY, Color.WHITE);
    }

    public BaseGradientPanel(Color startColor, Color endColor) {
        this.startColor = startColor;
        this.endColor = endColor;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isGradient) {
            int gradientEnd = this.getHeight() / 4 * 3;
            int panelHeight = this.getHeight();
            int panelWidth = this.getWidth();
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, gradientEnd, this.endColor);
            if (g instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)g;
                graphics2D.setPaint(gradientPaint);
                graphics2D.fillRect(0, 0, panelWidth, panelHeight);
            }
        }
    }

    public void setIsGradient(boolean aFlag) {
        this.isGradient = aFlag;
    }
}

