/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseReportRenderer;
import com.bmc.ctmconvert.base.BaseSimpleWaterMarkTextField;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BaseFilteredTree
extends BaseComponent
implements TreeSelectionListener {
    private JPanel treePanel;
    private JScrollPane treeScrollPane;
    protected DefaultMutableTreeNode rootNode;
    private JTree mainTree;
    private DefaultTreeModel treeModel;
    private BaseSimpleWaterMarkTextField filterBox;
    private boolean filter = true;

    public BaseFilteredTree(DefaultMutableTreeNode rootNode) {
        this.rootNode = rootNode;
        this.initialize();
    }

    public BaseFilteredTree(DefaultMutableTreeNode rootNode, boolean filter) {
        this.rootNode = rootNode;
        this.filter = filter;
        this.initialize();
    }

    private void initialize() {
        this.treePanel = new JPanel();
        this.treePanel.setBackground(FlowGlobals.ConversionWhite);
        this.treePanel.setLayout(new BorderLayout());
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.mainTree = new JTree(this.treeModel);
        this.mainTree.getSelectionModel().setSelectionMode(1);
        this.mainTree.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        this.treeScrollPane = new JScrollPane(this.mainTree);
        this.treeScrollPane.setLayout(new ScrollPaneLayout());
        this.treeScrollPane.setBorder(null);
        this.treeScrollPane.setBackground(Color.WHITE);
        this.treeScrollPane.setPreferredSize(new Dimension(240 + FlowGlobals.fieldSize.width, 350));
        this.treeScrollPane.setViewportBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2));
        this.treePanel.add((Component)this.treeScrollPane, "Center");
        if (this.filter) {
            JPanel filterPanel = new JPanel();
            filterPanel.setLayout(new BorderLayout());
            filterPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(12305609)));
            JLabel fiterIcon = new JLabel(new ImageIcon(FlowGlobals.class.getResource("/img/search.png")));
            fiterIcon.setPreferredSize(new Dimension(19, 19));
            filterPanel.add((Component)fiterIcon, "East");
            this.filterBox = new BaseSimpleWaterMarkTextField(TextManager.instance().get("MAIN_NAVIGATION_FIND_STR"));
            this.filterBox.setBorder(null);
            ((JTextField)this.filterBox.getComponent()).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    BaseFilteredTree.this.filterTree();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    BaseFilteredTree.this.filterTree();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    BaseFilteredTree.this.filterTree();
                }
            });
            filterPanel.add(this.filterBox.getComponent(), "Center");
            this.treePanel.add((Component)filterPanel, "North");
            this.setCellRenderer(new BaseReportRenderer());
        }
    }

    public void reload() {
        ((DefaultTreeModel)this.mainTree.getModel()).reload();
    }

    public void requestFocus() {
        this.mainTree.requestFocus();
    }

    public void filterTree() {
        if (this.rootNode != null) {
            String filter = this.filterBox.getText().trim();
            if (filter.length() > 0) {
                this.mainTree.setModel(new DefaultTreeModel(BaseFilteredTree.createFilteredTree(this.rootNode, filter)));
            } else {
                this.mainTree.setModel(this.treeModel);
            }
            TreeNode rootNode = (TreeNode)this.mainTree.getModel().getRoot();
            if (filter.length() > 0) {
                if (rootNode != null) {
                    this.expandAll(this.mainTree, new TreePath(rootNode), true);
                }
            } else {
                this.mainTree.expandPath(new TreePath((TreeNode)this.mainTree.getModel().getRoot()));
            }
            this.mainTree.repaint();
        }
    }

    public static void restoreExpandedState(DefaultMutableTreeNode base, List<TreePath> exps, JTree tree) {
        if (base == null) {
            throw new NullPointerException();
        }
        if (BaseFilteredTree.wasExpanded(base, exps)) {
            tree.expandPath(new TreePath(base.getPath()));
        }
        int c = base.getChildCount();
        for (int i = 0; i < c; ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)base.getChildAt(i);
            BaseFilteredTree.restoreExpandedState(n, exps, tree);
        }
    }

    public static boolean wasExpanded(DefaultMutableTreeNode n, List<TreePath> en) {
        if (n == null) {
            throw new NullPointerException();
        }
        for (TreePath path : en) {
            for (Object o : path.getPath()) {
                if (((DefaultMutableTreeNode)o).getUserObject() != n.getUserObject()) continue;
                return true;
            }
        }
        return false;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.rootNode;
    }

    public static DefaultMutableTreeNode createFilteredTree(DefaultMutableTreeNode parent, String filter) {
        int c = parent.getChildCount();
        DefaultMutableTreeNode fparent = (DefaultMutableTreeNode)parent.clone();
        boolean matches = parent.getUserObject().toString().toLowerCase().contains(filter.toLowerCase());
        for (int i = 0; i < c; ++i) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)parent.getChildAt(i);
            DefaultMutableTreeNode f = BaseFilteredTree.createFilteredTree(n, filter);
            if (f == null) continue;
            fparent.add(f);
            matches = true;
        }
        return matches ? fparent : null;
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public void setCellRenderer(BaseReportRenderer renderer) {
        this.mainTree.setCellRenderer(renderer);
        renderer.setFilterInput((JTextField)this.filterBox.getComponent());
    }

    public void setCellRenderer(TreeCellRenderer x) {
        this.mainTree.setCellRenderer(x);
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.mainTree.addTreeSelectionListener(tsl);
    }

    public void expandRow(int row) {
        this.mainTree.expandRow(row);
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.mainTree.addTreeExpansionListener(tel);
    }

    public void addMouseListener(MouseListener l) {
        this.mainTree.addMouseListener(l);
    }

    public int getSelectionRow() {
        int[] selectedRows = this.mainTree.getSelectionRows();
        return selectedRows != null && selectedRows.length > 0 ? this.mainTree.getSelectionRows()[0] : 0;
    }

    public void setSelectionRow(int row) {
        this.mainTree.setSelectionRow(row);
    }

    public void setExpandsSelectedPaths(boolean newValue) {
        this.mainTree.setExpandsSelectedPaths(newValue);
    }

    public void setSelectionPath(TreePath path) {
        this.mainTree.setSelectionPath(path);
    }

    public void repaint() {
        this.mainTree.repaint();
    }

    public void validate() {
        this.mainTree.validate();
    }

    public Object getLastSelectedPathComponent() {
        return this.mainTree.getLastSelectedPathComponent();
    }

    public void updateUI() {
        this.mainTree.updateUI();
    }

    public int getRowForLocation(int x, int y) {
        return this.mainTree.getRowForLocation(x, y);
    }

    public TreePath getPathForRow(int row) {
        return this.mainTree.getPathForRow(row);
    }

    public void nodeChanged(TreeNode node) {
        this.treeModel.nodeChanged(node);
    }

    public void reload(TreeNode node) {
        this.treeModel.reload(node);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
    }

    @Override
    public Component getComponent() {
        return this.treePanel;
    }
}

