/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.File;

public class BaseFieldValidator {
    private VALIDATOR_TYPE type;
    private String validConstrain;
    private String errorMessage = "";

    public BaseFieldValidator(VALIDATOR_TYPE type) {
        this.type = type;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isValid(String text) {
        boolean isValid = false;
        this.errorMessage = "";
        if (this.validConstrain != null && text.equals(this.validConstrain)) {
            isValid = true;
        } else {
            text = text.trim();
            switch (this.type.ordinal()) {
                case 0: {
                    isValid = this.notEmpty(text);
                    break;
                }
                case 1: {
                    isValid = this.notEmpty(text);
                    if (isValid) break;
                    this.errorMessage = TextManager.instance().get("VALIDATOR_EMPTY_SAP");
                    break;
                }
                case 2: {
                    isValid = this.datasourceName(text);
                    break;
                }
                case 3: {
                    isValid = this.filePath(text, false, false);
                    break;
                }
                case 4: {
                    isValid = this.filePath(text, false, true);
                    break;
                }
                case 5: {
                    isValid = this.filePath(text, true, false);
                    break;
                }
                case 6: {
                    isValid = this.filePath(text, true, true);
                    break;
                }
                case 7: {
                    isValid = this.conversionName(text);
                    break;
                }
                case 8: {
                    isValid = this.isPort(text);
                    break;
                }
                case 9: {
                    isValid = this.environmentName(text);
                    break;
                }
                case 10: {
                    isValid = this.mailAddress(text);
                    break;
                }
                case 11: {
                    isValid = this.listValidity(text);
                    break;
                }
                default: {
                    isValid = true;
                }
            }
        }
        return isValid;
    }

    public void setValidConstrain(String constrain) {
        this.validConstrain = constrain;
    }

    private boolean notEmpty(String text) {
        if (text == null || text.isEmpty()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_EMPTY");
        }
        return this.errorMessage.isEmpty();
    }

    private boolean datasourceName(String text) {
        File datasourceDirectory = new File(ConversionEntitiesService.getProjectDirectory(text));
        if (text == null || text.isEmpty()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_DATASOURCE_NAME_EMPTY");
        } else if (!text.matches("^[0-9a-zA-Z-_]+$")) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_DATASOURCE_NAME_ILLEGAL_CHARACTERS");
        } else if (datasourceDirectory.exists()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_DATASOURCE_NAME_EXISTING");
        }
        return this.errorMessage.isEmpty();
    }

    private boolean filePath(String text, boolean directory, boolean canBeEmpty) {
        File file = new File(text);
        if (canBeEmpty && (text == null || text.isEmpty())) {
            this.errorMessage = "";
        } else if (text == null || text.isEmpty()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_EMPTY");
        } else if (!file.exists()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_PATH_NOT_EXIST");
        } else if (file.isFile() && directory) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_PATH_NOT_DIRECTORY");
        } else if (file.isDirectory() && !directory) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_PATH_NOT_FILE");
        }
        return this.errorMessage.isEmpty();
    }

    private boolean conversionName(String text) {
        File conversionsDirectory = new File(ConversionEntitiesService.getConversionDirectory(Params.instance().getDatasourceName(), text));
        if (text == null || text.isEmpty()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_CONVERSION_NAME_EMPTY");
        } else if (!text.matches("^[0-9a-zA-Z-_]+$")) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_CONVERSION_NAME_ILLEGAL_CHARACTERS");
        } else if (conversionsDirectory.exists()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_CONVERSION_NAME_EXISTING");
        }
        return this.errorMessage.isEmpty();
    }

    private boolean environmentName(String text) {
        if (text == null || text.isEmpty()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_ENVIRONMENT_NAME_EMPTY");
        } else if (!text.matches("^[0-9a-zA-Z-_]+$")) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_ENVIRONMENT_NAME_ILLEGAL_CHARACTERS");
        }
        return this.errorMessage.isEmpty();
    }

    private boolean isPort(String text) {
        if (text == null || text.isEmpty()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_EMPTY");
        } else {
            try {
                int port = Integer.valueOf(text.trim());
                if (port < 1 || port > 65535) {
                    this.errorMessage = TextManager.instance().get("VALIDATOR_NOT_NUMERIC");
                }
            }
            catch (NumberFormatException e) {
                this.errorMessage = TextManager.instance().get("VALIDATOR_NOT_NUMERIC");
            }
        }
        return this.errorMessage.isEmpty();
    }

    private boolean mailAddress(String text) {
        if (text == null || text.isEmpty()) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_EMPTY");
        } else if (!text.replaceAll("\\{.+?\\}", "TEST_FIELD").matches("\\S+@\\S+\\.\\S+")) {
            this.errorMessage = TextManager.instance().get("VALIDATOR_EMAIL_ADDRESS_NOT_VALID");
        }
        return this.errorMessage.isEmpty();
    }

    private boolean listValidity(String text) {
        if (text.equals("NO")) {
            this.errorMessage = "Please select vendor";
        }
        return this.errorMessage.isEmpty();
    }

    public static enum VALIDATOR_TYPE {
        NOT_EMPTY,
        NOT_EMPTY_SAP,
        DATASOURCE_NAME,
        FILE_PATH,
        FILE_PATH_OR_EMPTY,
        DIRECTORY_PATH,
        DIRECTORY_PATH_OR_EMPTY,
        CONVERSION_NAME,
        IS_PORT,
        ENVIRONMENT_NAME,
        MAIL_ADDRESS,
        VENDORS_LIST;

    }
}

