/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.Base;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.FlowGlobalsStrings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class BaseField
extends Base {
    protected String ID;
    protected BaseComponent field;
    protected String fieldTitle;
    protected BaseComponent fieldTitleComponent;
    protected String titleFieldText;
    protected Font titleFontStyle = FlowGlobals.FONT_STYLE_REGULAR;
    protected JLabel mandatoryLabel;
    protected JLabel titleLabel;
    protected JLabel validityMessageImage;
    protected boolean mandatory;
    protected int padding;
    protected boolean fillAllArea;
    protected boolean fillFieldSize;
    protected String tooltip;
    protected String description = null;

    public BaseField(String title, int padding) {
        this.titleFieldText = title;
        this.padding = padding;
    }

    public BaseField(BaseComponent field) {
        this.setField(field);
    }

    public BaseField(BaseComponent field, String fieldTitle, String descrip) {
        this.fieldTitle = fieldTitle;
        this.description = descrip;
        this.setField(field);
    }

    public BaseField(BaseComponent field, String fieldTitle) {
        this.fieldTitle = fieldTitle;
        this.setField(field);
    }

    public BaseField(BaseComponent field, String fieldTitle, int padding) {
        this.fieldTitle = fieldTitle;
        this.padding = padding;
        this.setField(field);
    }

    public BaseField(BaseComponent field, int padding) {
        this.padding = padding;
        this.setField(field);
    }

    public BaseField(BaseComponent field, int padding, String descrip) {
        this.description = descrip;
        this.padding = padding;
        this.setField(field);
    }

    public BaseField(BaseComponent field, String fieldTitle, boolean mandatory) {
        this.fieldTitle = fieldTitle;
        this.mandatory = mandatory;
        this.setField(field);
    }

    public BaseField(BaseComponent field, String fieldTitle, boolean mandatory, String descrip) {
        this.description = descrip;
        this.fieldTitle = fieldTitle;
        this.mandatory = mandatory;
        this.setField(field);
    }

    public BaseField(BaseComponent field, String fieldTitle, boolean mandatory, int padding) {
        this.fieldTitle = fieldTitle;
        this.mandatory = mandatory;
        this.padding = padding;
        this.setField(field);
    }

    public BaseField(BaseComponent field, String fieldTitle, boolean mandatory, int padding, String descrip) {
        this.description = descrip;
        this.fieldTitle = fieldTitle;
        this.mandatory = mandatory;
        this.padding = padding;
        this.setField(field);
    }

    public BaseField(BaseComponent field, BaseComponent fieldTitleComponent) {
        this.setField(field);
        this.fieldTitleComponent = fieldTitleComponent;
    }

    public void setField(final BaseComponent field) {
        if (field != null) {
            this.componentGroup = field.componentGroup;
            this.componentName = field.componentName;
            if (this.fieldTitle != null && !this.fieldTitle.isEmpty()) {
                field.getComponent().setName(this.fieldTitle);
            }
            field.addValidityListener(this);
            if (this.description != null) {
                field.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                        field.fireDescriptionEvent(BaseField.this.description, true);
                    }
                });
            }
            this.setValid(field.isValid());
            this.field = field;
            this.setTooltip();
        }
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    private void setTooltip() {
        this.tooltip = FlowGlobalsStrings.Tooltips.get(this.field.getComponent().getName());
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            ((JComponent)this.field.getComponent()).setToolTipText(this.tooltip);
        }
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        if (this.field != null && tooltip != null) {
            ((JComponent)this.field.getComponent()).setToolTipText(this.tooltip);
        }
    }

    public void setDescription(String description) {
        if (description != null) {
            this.description = description;
        }
    }

    public boolean hasTitle() {
        return (this.fieldTitle != null && !this.fieldTitle.isEmpty() || this.fieldTitleComponent != null) && !this.fieldTitle.equals("NO_TOOLTIP") && !this.fieldTitle.startsWith("TOOLTIP_TITLE_PREFIX");
    }

    public void setFillAllArea(boolean b) {
        this.fillAllArea = b;
    }

    public boolean fillAllArea() {
        return this.fillAllArea;
    }

    public void fillFieldSize(boolean b) {
        this.fillFieldSize = b;
    }

    public boolean fillFieldSize() {
        return this.fillFieldSize;
    }

    public String getTitle() {
        return this.fieldTitle;
    }

    public BaseComponent getTitleComponent() {
        return this.fieldTitleComponent;
    }

    public void setTitle(String title) {
        if (this.field != null) {
            this.field.getComponent().setName(this.fieldTitle);
        }
        this.fieldTitle = title;
        if (this.titleLabel != null) {
            String tooltip;
            this.titleLabel.setText(this.fieldTitle);
            this.field.getComponent().setName(this.fieldTitle);
            if (this.field != null) {
                this.setTooltip();
            }
            if ((tooltip = FlowGlobalsStrings.Tooltips.get(this.fieldTitle)) != null && !tooltip.isEmpty()) {
                this.titleLabel.setToolTipText(tooltip);
            } else {
                this.titleLabel.setToolTipText(this.fieldTitle);
            }
        }
    }

    public Font getTitleFontStyle() {
        return this.titleFontStyle;
    }

    public void setTitleFontStyle(Font font) {
        this.titleFontStyle = font;
    }

    public int getPadding() {
        return this.padding;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public JLabel getMandatoryLabel() {
        if (this.isMandatory() && this.mandatoryLabel == null) {
            this.mandatoryLabel = new JLabel("*");
            this.mandatoryLabel.setForeground(Color.RED);
        }
        return this.mandatoryLabel;
    }

    public JLabel getTitleLabel() {
        if (this.hasTitle() && this.titleLabel == null) {
            this.titleLabel = new JLabel(this.fieldTitle + (this.fieldTitle.isEmpty() ? "" : ":"));
            this.titleLabel.setFont(this.titleFontStyle);
            if (this.tooltip != null && !this.tooltip.isEmpty()) {
                this.titleLabel.setToolTipText(this.tooltip);
            } else {
                this.titleLabel.setToolTipText(this.fieldTitle);
            }
        }
        return this.titleLabel;
    }

    public JLabel getTitleFieldLabelForSubSectionTitle() {
        if (this.titleFieldText != null && !this.titleFieldText.isEmpty() && this.titleLabel == null) {
            this.titleLabel = new JLabel(this.titleFieldText);
            this.titleLabel.setFont(this.titleFontStyle);
            this.titleLabel.setForeground(FlowGlobals.ConversionBlue);
        }
        return this.titleLabel;
    }

    public JPanel getTitlePanel() {
        JPanel jPanel = null;
        if (this.fieldTitle != null) {
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBackground(FlowGlobals.ConversionWhite);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            JLabel titleLabel = new JLabel(this.fieldTitle);
            jPanel.add(titleLabel);
        }
        return jPanel;
    }

    public void setEnabled(boolean b) {
        if (this.mandatoryLabel != null) {
            this.mandatoryLabel.setEnabled(b);
        }
        if (this.titleLabel != null) {
            this.titleLabel.setEnabled(b);
        }
        if (this.field != null) {
            JTextField currField;
            if (!b) {
                this.field.setValidityLook(!b);
            }
            if (this.field.getComponent() != null) {
                if (this.field.getComponent().getClass().equals(JTextField.class) || this.field.getComponent().getClass().equals(JPasswordField.class)) {
                    currField = (JTextField)this.field.getComponent();
                    currField.setEditable(b);
                    currField.setBackground(b ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
                }
                this.field.getComponent().setEnabled(b);
                this.field.setActive(b);
            }
            if (this.field.getExtraComponent() != null) {
                if (this.field.getExtraComponent().getClass().equals(JTextField.class) || this.field.getExtraComponent().getClass().equals(JPasswordField.class)) {
                    currField = (JTextField)this.field.getExtraComponent();
                    currField.setEditable(b);
                    currField.setBackground(b ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
                }
                this.field.getExtraComponent().setEnabled(b);
            }
        }
    }

    @Override
    public void setError(Boolean b, String Message2) {
        this.field.setError(b, Message2);
    }

    public void setVisible(boolean aFlag) {
        if (this.mandatoryLabel != null) {
            this.mandatoryLabel.setVisible(aFlag);
        }
        if (this.titleLabel != null) {
            this.titleLabel.setVisible(aFlag);
        }
        if (this.field != null) {
            if (!aFlag) {
                this.field.setValidityLook(!aFlag);
            }
            if (this.field.getComponent() != null) {
                this.field.getComponent().setVisible(aFlag);
            }
            if (this.field.getExtraComponent() != null) {
                this.field.getExtraComponent().setVisible(aFlag);
            }
        }
    }

    public void setValidConstrain() {
        this.field.setValidConstrain();
    }

    public BaseComponent getBaseComponent() {
        return this.field;
    }

    @Override
    public Object getData() {
        return this.field.getData();
    }

    @Override
    public void setData(Object obj) {
        this.field.setData(obj);
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return this.field.getDataType();
    }

    @Override
    public String getGroupName() {
        return this.field.getGroupName();
    }

    @Override
    public void setActive(Boolean b) {
        super.setActive(b);
        this.setEnabled(b);
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        this.field.addValueChangedAction(action);
    }

    public void setMandatory(boolean isMandatory) {
        this.mandatory = isMandatory;
        this.setField(this.field);
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }
}

