/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class BaseExpander
extends BaseComponent {
    private String expandName;
    private String collapseName;
    private JPanel namePanel;
    private JLabel nameLabel;
    private JPanel expander;
    private JPanel container;

    public BaseExpander(String name) {
        this.expandName = name;
        this.collapseName = name;
        this.initialize();
    }

    public BaseExpander(String expandName, String collapseName) {
        this.expandName = expandName;
        this.collapseName = collapseName;
        this.initialize();
    }

    private void initialize() {
        this.setCommand(this.collapseName);
        this.expander = new JPanel();
        this.expander.setLayout(new BoxLayout(this.expander, 1));
        this.namePanel = new JPanel();
        this.namePanel.setLayout(new BoxLayout(this.namePanel, 0));
        this.nameLabel = new JLabel(this.collapseName);
        this.nameLabel.setIcon(FlowGlobals.LEFT_ARROW_ICON);
        this.nameLabel.setIconTextGap(15);
        this.nameLabel.setFont(FlowGlobals.FONT_STYLE_BOLD);
        this.nameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                BaseExpander.this.toggle();
            }
        });
        this.nameLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.namePanel.add(this.nameLabel);
        this.namePanel.add(Box.createHorizontalGlue());
        this.expander.add(this.namePanel);
        this.expander.add(Box.createRigidArea(new Dimension(0, 5)));
        JSeparator separator = new JSeparator();
        separator.setBackground(FlowGlobals.expanderSeparator);
        this.expander.add(separator);
        this.container = new JPanel();
        this.container.setLayout(new BoxLayout(this.container, 1));
        this.container.add(Box.createRigidArea(new Dimension(0, 13)));
        this.expander.add(this.container);
    }

    public void setBackground(Color bg) {
        this.namePanel.setBackground(bg);
        this.container.setBackground(bg);
        this.expander.setBackground(bg);
    }

    public void add(BaseComponent component) {
        this.container.add(component.getComponent());
        this.container.add(Box.createRigidArea(new Dimension(0, 13)));
        component.addValidityListener(this);
        this.setValid(component.isValid());
    }

    @Override
    public String getName() {
        return this.expandName;
    }

    public boolean isExpande() {
        return this.container.isVisible();
    }

    public void toggle() {
        this.toggle(!this.container.isVisible());
    }

    public void toggle(boolean aFlag) {
        this.nameLabel.setIcon(aFlag ? FlowGlobals.DOWN_ARROW_ICON : FlowGlobals.LEFT_ARROW_ICON);
        this.nameLabel.setText(aFlag ? this.expandName : this.collapseName);
        this.container.setVisible(aFlag);
    }

    @Override
    public Component getComponent() {
        return this.expander;
    }
}

