/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.DialogFactory;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BaseDialog
extends BaseComponent {
    private JDialog jDialog = DialogFactory.instance().getLinkedDialog();
    private JPanel jPanel;
    private Dimension size;
    private Component relativeTo;

    public BaseDialog() {
        this.initialize();
    }

    public BaseDialog(String title) {
        this.jDialog.setTitle(title);
        this.initialize();
    }

    public BaseDialog(Component relativeTo, String title) {
        this.relativeTo = relativeTo;
        this.jDialog.setTitle(title);
        this.initialize();
    }

    public BaseDialog(Component relativeTo, String title, Dimension size) {
        this.relativeTo = relativeTo;
        this.jDialog.setTitle(title);
        this.size = size;
        this.initialize();
    }

    private void initialize() {
        if (this.size != null) {
            this.jDialog.setSize(this.size);
        }
        this.jDialog.setModal(true);
        this.jDialog.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(FlowGlobals.BMC_ICON_PATH)));
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BorderLayout());
        this.jPanel.setBackground(Color.WHITE);
        this.jDialog.setContentPane(this.jPanel);
        this.jDialog.setBackground(Color.WHITE);
        this.jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BaseDialog.this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"));
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                if (BaseDialog.this.jDialog.isActive() && e.getID() == 401) {
                    if (e.getKeyCode() == 112) {
                        BaseDialog.this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"));
                    } else if (e.getKeyCode() == 27) {
                        BaseDialog.this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"));
                    } else {
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public void setDefaultCloseOperation(int type) {
        this.jDialog.setDefaultCloseOperation(type);
    }

    public void setContent(BaseComponent pane) {
        this.jPanel.removeAll();
        this.jPanel.add(pane.getComponent(), "Center");
        if (this.size == null) {
            this.size = pane.getComponent().getPreferredSize();
            this.size = new Dimension(this.size.width + 64, this.size.height + 64);
        }
        this.jDialog.validate();
        this.jDialog.repaint();
        this.setLocation();
    }

    private void setLocation() {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        int screen80PrecentWidth = screenDimension.width / 5 * 4;
        int screen80PrecentHeight = screenDimension.height / 5 * 4;
        if (this.size.width > screen80PrecentWidth) {
            this.size.width = screen80PrecentWidth;
        }
        if (this.size.height > screen80PrecentHeight) {
            this.size.height = screen80PrecentHeight;
        }
        this.jDialog.setSize(this.size);
        Component topLevelWindow = SwingUtilities.getRoot(this.relativeTo);
        if (topLevelWindow != null) {
            int baseX = topLevelWindow.getX();
            int baseY = topLevelWindow.getY();
            int baseWidth = topLevelWindow.getWidth();
            int baseHight = topLevelWindow.getHeight();
            int newX = baseX + baseWidth / 2 - this.size.width / 2;
            int newY = baseY + baseHight / 2 - this.size.height / 2;
            this.jDialog.setLocation(newX, newY);
        } else {
            this.jDialog.setLocationRelativeTo(this.relativeTo);
        }
    }

    public void setVisible(boolean b) {
        this.jDialog.setVisible(b);
    }

    public void addWindowListener(WindowListener l) {
        this.jDialog.addWindowListener(l);
    }

    public void setSize(Dimension d) {
        if (d != null) {
            this.size = d;
            this.setLocation();
        }
    }

    public void dispose() {
        this.jDialog.dispose();
    }

    @Override
    public Component getComponent() {
        return this.jDialog;
    }
}

