/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComboBoxUI;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;

public class BaseComboBox
extends BaseComponent
implements ActionListener {
    private JComboBox<Object> jComboBox;
    private Border border;
    private String defautString;
    private boolean disableValidityLook;
    private ActionListener actionListener;

    public BaseComboBox(Object[] items) {
        this.jComboBox = new JComboBox<Object>(items);
        this.initialize();
    }

    public BaseComboBox(ComboBoxModel<Object> model, String componentName, String componentGroup) {
        this.jComboBox = new JComboBox<Object>(model);
        this.componentName = componentName;
        this.componentGroup = componentGroup;
        this.initialize();
    }

    public BaseComboBox(ComboBoxModel<Object> model) {
        this.jComboBox = new JComboBox<Object>(model);
        this.initialize();
    }

    public BaseComboBox(Object[] items, String defautString) {
        this.defautString = defautString;
        this.jComboBox = new JComboBox<Object>(items);
        this.initialize();
    }

    public BaseComboBox(Object[] items, String componentName, String componentGroup) {
        this(items);
        this.componentName = componentName;
        this.componentGroup = componentGroup;
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        final Actionable tmpAction = action;
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tmpAction.act();
            }
        };
        this.jComboBox.addActionListener(this.actionListener);
    }

    private void initialize() {
        if (this.defautString != null && !this.defautString.isEmpty()) {
            this.jComboBox.insertItemAt(this.defautString, 0);
            this.jComboBox.setSelectedIndex(0);
        }
        this.jComboBox.setPreferredSize(FlowGlobals.fieldComboboxSize);
        this.jComboBox.setBorder(FlowGlobals.fieldDefaultBorder);
        this.jComboBox.setBackground(Color.WHITE);
        this.jComboBox.setUI(BaseComboBoxUI.createUI(this.jComboBox));
        this.jComboBox.setMaximumRowCount(20);
        this.jComboBox.setRenderer(new ListCellRenderer<Object>(this){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
                Dimension preferredSize = new Dimension(0, 20);
                JLabel renderer = (JLabel)defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Color) {
                    renderer.setBackground((Color)value);
                }
                if (isSelected && index == 0) {
                    renderer.setBackground(FlowGlobals.ConversionWhite);
                }
                renderer.setPreferredSize(preferredSize);
                return renderer;
            }
        });
        this.jComboBox.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                String str = (String)BaseComboBox.this.jComboBox.getEditor().getItem();
                if (str.isEmpty() && BaseComboBox.this.jComboBox.isEditable()) {
                    BaseComboBox.this.jComboBox.getEditor().setItem(BaseComboBox.this.defautString);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                String str = (String)BaseComboBox.this.jComboBox.getEditor().getItem();
                if (str.equals(BaseComboBox.this.defautString) && BaseComboBox.this.jComboBox.isEditable()) {
                    BaseComboBox.this.jComboBox.getEditor().setItem("");
                }
            }
        });
        this.jComboBox.addActionListener(this);
        this.validityMessageImage = new JLabel(FlowGlobals.FIELD_VALIDATION_ERROR_ICON);
        this.validityMessageImage.setVisible(false);
    }

    public void updateData(Object[] items) {
        this.jComboBox.removeAllItems();
        for (Object item : items) {
            this.jComboBox.addItem(item);
        }
        if (this.defautString != null && !this.defautString.isEmpty()) {
            this.jComboBox.insertItemAt(this.defautString, 0);
            this.jComboBox.setSelectedIndex(0);
        }
    }

    @Override
    public void setValidityLook(boolean valid) {
        if (!this.disableValidityLook) {
            if (this.border == null) {
                this.jComboBox.setBorder(valid ? FlowGlobals.fieldDefaultBorder : FlowGlobals.fieldInvalidBorder);
            }
            if (this.validityMessageImage != null) {
                this.validityMessageImage.setVisible(!valid);
                this.validityMessageImage.setToolTipText(TextManager.instance().get("VALIDATOR_EMPTY"));
            }
        }
    }

    public void setSelectedItem(Object anObject) {
        this.jComboBox.setSelectedItem(anObject);
    }

    @Override
    public JComponent getComponent() {
        return this.jComboBox;
    }

    public void addActionListener(ActionListener l) {
        this.jComboBox.addActionListener(l);
    }

    public void setActionCommand(String actionCommand) {
        this.jComboBox.setActionCommand(actionCommand);
    }

    public void setEnabled(boolean enabled) {
        this.jComboBox.setEnabled(enabled);
        this.jComboBox.setBackground(enabled ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
    }

    public void setEditable(boolean aFlag) {
        this.jComboBox.setEditable(aFlag);
    }

    public Object getSelectedItem() {
        if (this.jComboBox.isEditable() && ((String)this.jComboBox.getSelectedItem()).equalsIgnoreCase(this.defautString)) {
            return "";
        }
        return this.jComboBox.getSelectedItem();
    }

    public int getSelectedIndex() {
        return this.jComboBox.getSelectedIndex();
    }

    @Override
    public void disableValidityLook(boolean b) {
        this.disableValidityLook = b;
        this.validityMessageImage = null;
    }

    @Override
    public boolean isValid() {
        return this.jComboBox.getSelectedIndex() > (this.defautString != null && !this.defautString.isEmpty() ? 0 : -1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jComboBox) {
            this.setValid(this.isValid());
        }
        this.setValidityLook(this.isValid());
    }

    @Override
    public Object getData() {
        return this.getSelectedItem();
    }

    @Override
    public void setData(Object obj) {
        this.setSelectedItem(obj);
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return DataRetrievable.DataType.STRING;
    }

    @Override
    public void setActive(Boolean b) {
        this.setEnabled(b);
        super.setActive(b);
    }

    @Override
    public void setError(Boolean b, String Message2) {
        super.setError(b, Message2);
        this.setValid(b);
        this.setValidityLook(b == false);
    }

    public void removeValueChangedAction() {
        this.jComboBox.removeActionListener(this.actionListener);
    }

    public void addValueChangedAction() {
        this.jComboBox.addActionListener(this.actionListener);
    }
}

