/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.ButtonColors;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;

public class BaseButton
extends JButton
implements MouseListener,
ValidityListener {
    private static final long serialVersionUID = 1L;
    private Border defaultBorder;
    private Border hoverBorder;
    private boolean isHover = false;
    private ButtonColors buttonColors;
    private boolean transparent;

    public BaseButton() {
        this.initialize();
    }

    public BaseButton(String text) {
        super(text);
        this.initialize();
    }

    public BaseButton(Action a) {
        super(a);
        this.initialize();
    }

    private void initialize() {
        this.initColors();
        this.initBorders();
        this.addMouseListener(this);
        this.setContentAreaFilled(false);
    }

    private void initColors() {
        this.buttonColors = ThemeConfiguration.get().getButtonColors();
    }

    private void initBorders() {
        Border innerSpacing = BorderFactory.createEmptyBorder(5, 17, 5, 17);
        if (this.getText() == null || this.getText().isEmpty()) {
            innerSpacing = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        }
        this.defaultBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0x999999)), innerSpacing);
        this.hoverBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), innerSpacing);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.initialize();
        this.paint(false);
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.initialize();
        this.paint(false);
    }

    @Override
    public void paint(Graphics g) {
        if (this.transparent) {
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setForeground(ButtonColors.hoverTextColor);
            this.setBorder(this.hoverBorder);
        } else {
            if (this.isHover) {
                g.setColor(this.buttonColors.hoverBackgroundColor);
                this.setForeground(ButtonColors.hoverTextColor);
                this.setBorder(this.hoverBorder);
            } else if (this.getModel().isPressed()) {
                g.setColor(this.buttonColors.buttonPressedBackgroundColor);
                this.setForeground(this.buttonColors.buttonPressedTextColor);
                this.setBorder(this.defaultBorder);
            } else {
                g.setColor(ButtonColors.defaultBackgroundColor);
                this.setForeground(ButtonColors.defaultTextColor);
                this.setBorder(this.defaultBorder);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g);
    }

    private void paint(boolean paint) {
        if (this.isEnabled()) {
            this.isHover = paint;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.paint(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.paint(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.paint(false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.paint(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.paint(false);
    }

    @Override
    public void validityActionPerformed(ConversionEvent e) {
        this.setEnabled(e.getValue());
    }
}

