/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.common.GlobalFunctions;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;

public class BaseBrowseTextField
extends BaseComponent
implements ActionListener {
    private BaseTextField baseTextField;
    private String[] extentions;
    private BaseFieldValidator validator;

    public BaseBrowseTextField(String[] extentions) {
        this.extentions = extentions;
        this.initialize();
    }

    public BaseBrowseTextField(BaseFieldValidator validator) {
        this.validator = validator;
        this.initialize();
    }

    public BaseBrowseTextField(String[] extentions, BaseFieldValidator validator) {
        this.extentions = extentions;
        this.validator = validator;
        this.initialize();
    }

    private void initialize() {
        if (this.validator == null) {
            this.validator = new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH);
        }
        this.baseTextField = new BaseTextField(this.validator);
        this.baseTextField.addValidityListener(this);
        this.extraComponent = ButtonFactory.createButton(ButtonFactory.ButtonType.BROWSE, this);
    }

    @Override
    public Component getComponent() {
        return this.baseTextField.getComponent();
    }

    @Override
    public Component getValidityComponent() {
        return this.baseTextField.getValidityComponent();
    }

    @Override
    public boolean isValid() {
        return this.baseTextField.isValid();
    }

    @Override
    public void setValidityLook(boolean valid) {
        this.baseTextField.setValidityLook(valid);
    }

    public String getText() {
        return this.baseTextField.getText();
    }

    public void setText(String text) {
        this.baseTextField.setText(text);
    }

    public void setEnabled(boolean enabled) {
        this.baseTextField.setEnabled(enabled);
        if (this.extraComponent != null) {
            this.extraComponent.setEnabled(enabled);
            this.extraComponent.setVisible(enabled);
        }
    }

    @Override
    public void setValidConstrain() {
        this.baseTextField.setValidConstrain();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.baseTextField.addDocumentListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GlobalFunctions.browseClick((JTextField)this.baseTextField.getComponent(), this.extentions);
    }
}

