/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.workspace.entities.Variable;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Os2200ParametersAPI {
    CtmBaseEntity entity;

    public Os2200ParametersAPI(CtmBaseEntity entity) {
        this.entity = entity;
    }

    public void setShowOutput(ShowOutputType showOutputType) {
        if (showOutputType == null || showOutputType == ShowOutputType.Default) {
            this.entity.removeVariable("%%OS2200-MULTIPLE_SYM");
        } else {
            this.entity.addVariable(new Variable("%%OS2200-MULTIPLE_SYM", showOutputType.value));
        }
    }

    public void setQualifier(String qualifier) {
        this.entity.addVariable(new Variable("%%OS2200-QUALIFIER", qualifier));
        this.entity.addAttribute("MEMLIB", qualifier);
    }

    public void setFile(String file) {
        MemNameExtractor extractor = new MemNameExtractor(this.entity);
        extractor.replaceFileValue(file);
    }

    public void setCycle(int cycle) {
        MemNameExtractor extractor = new MemNameExtractor(this.entity);
        extractor.replaceCycleValue(cycle);
    }

    public void setElement(String element) {
        MemNameExtractor extractor = new MemNameExtractor(this.entity);
        extractor.replaceElementValue(element);
    }

    public void setVersion(String version) {
        MemNameExtractor extractor = new MemNameExtractor(this.entity);
        extractor.replaceVersionValue(version);
    }

    private void clearAllNonCommonAttributes() {
        this.entity.addAttribute("USE_INSTREAM_JCL", "N");
        this.entity.removeAttribute("INSTREAM_JCL");
        this.entity.removeAttribute("OVERLIB");
        this.entity.removeVariable("%%OS2200-UIS_COMMAND");
    }

    public void setScript(String script) {
        this.clearAllNonCommonAttributes();
        this.entity.addAttribute("USE_INSTREAM_JCL", "Y");
        this.entity.addAttribute("INSTREAM_JCL", script);
    }

    public void setCommand(String command) {
        this.clearAllNonCommonAttributes();
        this.entity.addVariable(new Variable("%%OS2200-UIS_COMMAND", command));
    }

    public void setOverrideQualifier(String overrideQualifier) {
        this.clearAllNonCommonAttributes();
        this.entity.addAttribute("OVERLIB", overrideQualifier);
    }

    public void setAccountId(String accountId) {
        JobOwnerProps props = this.getJobOwner();
        props.accountId = accountId;
        this.setJobOwner(props);
    }

    public void setRunAs(String runAs) {
        JobOwnerProps props = this.getJobOwner();
        props.runAs = runAs;
        this.setJobOwner(props);
    }

    public void setPreCommand(String preCommand) {
        this.entity.addVariable(new Variable("%%OS2200-UIS_PRECMD", preCommand));
    }

    public void setPostCommand(String postCommand) {
        this.entity.addVariable(new Variable("%%OS2200-UIS_POSTCMD", postCommand));
    }

    public void setPriority(String priority) {
        this.entity.addVariable(new Variable("%%OS2200-PRIORITY", priority));
    }

    public void setOptions(String options) {
        this.entity.addVariable(new Variable("%%OS2200-OPTIONS", options));
    }

    private void setJobOwner(JobOwnerProps props) {
        this.entity.addVariable(new Variable("%%OS2200-JOB_OWNER", props.getFormattedJobOwner()));
    }

    private JobOwnerProps getJobOwner() {
        String jobOwnerValue = this.entity.getVariableByName("%%OS2200-JOB_OWNER");
        if (Os2200ParametersAPI.isNullOrEmpty(jobOwnerValue)) {
            return new JobOwnerProps(this, "", "");
        }
        return this.getJobOwner(jobOwnerValue);
    }

    private JobOwnerProps getJobOwner(String jobOwnerValue) {
        String[] parts = jobOwnerValue.split("/");
        if (Os2200ParametersAPI.hasOnlyRunAs(parts)) {
            return new JobOwnerProps(this, "", parts[0]);
        }
        return new JobOwnerProps(this, parts[0], parts[1]);
    }

    private static boolean hasOnlyRunAs(String[] parts) {
        return parts.length == 1;
    }

    public void setRunID(String runId) {
        this.entity.addVariable(new Variable("%%OS2200-RUNID", runId));
    }

    public void setProjectID(String projectId) {
        this.entity.addVariable(new Variable("%%OS2200-PROJECT", projectId));
    }

    public void setDoNotUseSymAndBrkptInJobWrapper(boolean doNotUse) {
        this.setBooleanVariable("%%OS2200-INJOBPR", doNotUse);
    }

    public void setUseOriginalRuncardFromUserJobRunstream(boolean use) {
        this.setBooleanVariable("%%OS2200-USE_RUNCARD", use);
    }

    public void setUseRunIdFromAutoEditVariableOrJobRunstream(boolean use) {
        this.setBooleanVariable("%%OS2200-USER_RUNIDS", use);
    }

    public void setAllowJobSubmissionUnderDifferentOwner(boolean allow) {
        this.setBooleanVariable("%%OS2200-USER_SECURITY", allow);
    }

    public void setAnalyzeAndTranslateVariablesInJobRunstream(boolean analyze) {
        this.setBooleanVariable("%%OS2200-RUNSARG", analyze);
    }

    private void setBooleanVariable(String varName, boolean value) {
        this.entity.addVariable(new Variable(varName, Os2200ParametersAPI.convertBooleanToYesOrNo(value)));
    }

    @NotNull
    private static String convertBooleanToYesOrNo(boolean flag) {
        return flag ? "Y" : "N";
    }

    public void setDoNotSetJobOwnerToJobWrapperSubmission(boolean doNotSet) {
        this.setBooleanVariable("%%OS2200-SKIPCHGOWN", doNotSet);
    }

    public void setPerformAccountValidationBeforeSubmission(boolean performValidation) {
        this.setBooleanVariable("%%OS2200-USER_VALIDATION", performValidation);
    }

    public void setBypassCheckingOfTheStatusFileIndicator(boolean bypassChecking) {
        this.setBooleanVariable("%%OS2200-FFLAG_BYPASS", bypassChecking);
    }

    public void setDoNotRunUserJobViaAddInJobWrapper(boolean doNotRun) {
        this.setBooleanVariable("%%OS2200-DISABLE_ADDRUN", doNotRun);
    }

    public void setSetCondition(int i) {
        this.entity.addVariable(new Variable("%%OS2200-SETC", Integer.toString(i)));
    }

    public void setDeadline(String deadline) {
        this.entity.addVariable(new Variable("%%OS2200-DEADLINE", deadline));
    }

    public void setPages(int pages) {
        this.entity.addVariable(new Variable("%%OS2200-PAGES", Integer.toString(pages)));
    }

    public void setCards(int cards) {
        this.entity.addVariable(new Variable("%%OS2200-CARDS", Integer.toString(cards)));
    }

    public void setRuntime(String runTime) {
        this.entity.addVariable(new Variable("%%OS2200-RUNTIME", runTime));
    }

    public void setStartTime(String startTime) {
        this.entity.addVariable(new Variable("%%OS2200-STARTTIME", startTime));
    }

    private static boolean isNullOrEmpty(String value) {
        return Objects.equals(value, "") || value == null;
    }

    private static boolean isNotNullOrEmpty(String value) {
        return !Os2200ParametersAPI.isNullOrEmpty(value);
    }

    public static enum ShowOutputType {
        Default(""),
        YesAndDeleteAllOutput("Y"),
        NoAndRetainJobOutput("N"),
        YesAndRetainAllOutput("Y-ALL"),
        NoAndRetainAllOutput("N-ALL");

        private String value;

        private ShowOutputType(String value) {
            this.value = value;
        }
    }

    private static class MemNameExtractor {
        private static final String OS2200MEM_NAME_format = "^(?<file>[a-zA-Z0-9_\\-$]+)(\\((?<cycle>[0-9]+)\\))?(\\.(?<element>[a-zA-Z0-9_\\-$]+))?(/(?<version>[a-zA-Z0-9_\\-$]+))?$";
        private static final Pattern pattern = Pattern.compile("^(?<file>[a-zA-Z0-9_\\-$]+)(\\((?<cycle>[0-9]+)\\))?(\\.(?<element>[a-zA-Z0-9_\\-$]+))?(/(?<version>[a-zA-Z0-9_\\-$]+))?$");
        private final CtmBaseEntity entity;

        MemNameExtractor(CtmBaseEntity entity) {
            this.entity = entity;
        }

        public void replaceFileValue(String file) {
            MemNameProperties currentProps = this.extractProperties();
            currentProps.file = file;
            this.writeMemNameVariable(currentProps);
        }

        public void replaceElementValue(String element) {
            MemNameProperties currentProps = this.extractProperties();
            currentProps.element = element;
            this.writeMemNameVariable(currentProps);
        }

        public void replaceCycleValue(int cycle) {
            MemNameProperties currentProps = this.extractProperties();
            currentProps.cycle = Integer.toString(cycle);
            this.writeMemNameVariable(currentProps);
        }

        private void writeMemNameVariable(MemNameProperties currentProps) {
            String varValue = this.buildMemName(currentProps);
            this.entity.addVariable(new Variable("%%OS2200-MEM_NAME", varValue));
            this.entity.addAttribute("MEMNAME", varValue);
        }

        public void replaceVersionValue(String version) {
            MemNameProperties currentProps = this.extractProperties();
            currentProps.version = version;
            this.writeMemNameVariable(currentProps);
        }

        private MemNameProperties extractProperties() {
            return Optional.ofNullable(this.entity.getVariableByName("%%OS2200-MEM_NAME")).map(pattern::matcher).filter(Matcher::find).map(m -> new MemNameProperties(this, this.getCleanFileValue((Matcher)m), this.getCleanCycleNumber((Matcher)m), this.getCleanElementValue((Matcher)m), this.getCleanVersionNumber((Matcher)m))).orElse(new MemNameProperties(this, "", "", "", ""));
        }

        private String getCleanFileValue(Matcher m) {
            return m.group("file");
        }

        private String getCleanVersionNumber(Matcher m) {
            return m.group("version");
        }

        private String getCleanElementValue(Matcher m) {
            return m.group("element");
        }

        private String getCleanCycleNumber(Matcher m) {
            return m.group("cycle");
        }

        private String buildMemName(MemNameProperties props) {
            return props.file.trim() + props.getFormattedCycle() + props.getFormattedElement() + props.getFormattedVersion();
        }

        public class MemNameProperties {
            public String file;
            private String cycle;
            private String element;
            private String version;

            public MemNameProperties(MemNameExtractor this$0, String file, String cycle, String element, String version) {
                this.version = version;
                this.file = file;
                this.cycle = cycle;
                this.element = element;
            }

            public String getFormattedCycle() {
                return Os2200ParametersAPI.isNullOrEmpty(this.cycle) ? "" : "(" + this.cycle.trim() + ")";
            }

            public String getFormattedVersion() {
                return Os2200ParametersAPI.isNullOrEmpty(this.version) ? "" : "/" + this.version.trim();
            }

            public String getFormattedElement() {
                return Os2200ParametersAPI.isNullOrEmpty(this.element) ? "" : "." + this.element.trim();
            }
        }
    }

    private class JobOwnerProps {
        private String accountId;
        private String runAs;

        public JobOwnerProps(Os2200ParametersAPI os2200ParametersAPI, String accountId, String runAs) {
            this.accountId = accountId;
            this.runAs = runAs;
        }

        public String getFormattedJobOwner() {
            return Stream.of(this.accountId, this.runAs).filter(Os2200ParametersAPI::isNotNullOrEmpty).collect(Collectors.joining("/"));
        }
    }
}

