/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.ConditionPrefixesHandler;
import com.bmc.caespToCtmBridgeBuilder.Constants;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ESPBridgeTypeMapper {
    static final String MF_IDENTIFIER = "ESP6640I";
    static final String DS_IDENTIFIER = "ESP6604I";
    private Map<Constants.BridgeType, String> bridgeType2MessageIdentifierMap;
    private Map<Constants.BridgeType, String> bridgeType2DesiredConditionPrefixMap;
    private Map<Constants.BridgeType, String> bridgeType2ExistingConditionPrefixMap;
    private Map<Constants.BridgeType, String> bridgeType2PrefixesMap;

    public ESPBridgeTypeMapper(ConditionPrefixesHandler conditionPrefixesHandler) throws IOException {
        this.bridgeType2PrefixesMap = conditionPrefixesHandler.getBridgeType2PrefixMap();
        this.bridgeType2MessageIdentifierMap = new HashMap<Constants.BridgeType, String>();
        this.bridgeType2MessageIdentifierMap.put(Constants.BridgeType.ESPDS_CTMDS, DS_IDENTIFIER);
        this.bridgeType2MessageIdentifierMap.put(Constants.BridgeType.ESPDS_CTMMF, DS_IDENTIFIER);
        this.bridgeType2MessageIdentifierMap.put(Constants.BridgeType.ESPMF_CTMDS, MF_IDENTIFIER);
        this.bridgeType2MessageIdentifierMap.put(Constants.BridgeType.ESPMF_CTMMF, MF_IDENTIFIER);
        this.bridgeType2DesiredConditionPrefixMap = new HashMap<Constants.BridgeType, String>();
        String globalConditionPrefix = conditionPrefixesHandler.getGlobalConditionPrefix();
        this.bridgeType2DesiredConditionPrefixMap.put(Constants.BridgeType.ESPDS_CTMDS, globalConditionPrefix + this.bridgeType2PrefixesMap.get((Object)Constants.BridgeType.ESPDS_CTMDS));
        this.bridgeType2DesiredConditionPrefixMap.put(Constants.BridgeType.ESPDS_CTMMF, this.bridgeType2PrefixesMap.get((Object)Constants.BridgeType.ESPDS_CTMMF));
        this.bridgeType2DesiredConditionPrefixMap.put(Constants.BridgeType.ESPMF_CTMDS, this.bridgeType2PrefixesMap.get((Object)Constants.BridgeType.ESPMF_CTMDS));
        this.bridgeType2DesiredConditionPrefixMap.put(Constants.BridgeType.ESPMF_CTMMF, this.bridgeType2PrefixesMap.get((Object)Constants.BridgeType.ESPMF_CTMMF));
        this.bridgeType2ExistingConditionPrefixMap = new HashMap<Constants.BridgeType, String>();
        this.bridgeType2ExistingConditionPrefixMap.put(Constants.BridgeType.ESPDS_CTMDS, "");
        this.bridgeType2ExistingConditionPrefixMap.put(Constants.BridgeType.ESPDS_CTMMF, globalConditionPrefix);
        this.bridgeType2ExistingConditionPrefixMap.put(Constants.BridgeType.ESPMF_CTMDS, globalConditionPrefix);
        this.bridgeType2ExistingConditionPrefixMap.put(Constants.BridgeType.ESPMF_CTMMF, "");
    }

    public String getIdentifier(Constants.BridgeType bridgeType) {
        return this.bridgeType2MessageIdentifierMap.get((Object)bridgeType);
    }

    public String getDesiredConditonPrefix(Constants.BridgeType bridgeType) {
        return this.bridgeType2DesiredConditionPrefixMap.get((Object)bridgeType);
    }

    public String getExistConditonPrefix(Constants.BridgeType bridgeType) {
        return this.bridgeType2ExistingConditionPrefixMap.get((Object)bridgeType);
    }
}

