/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.BridgeJobInjector;
import com.bmc.caespToCtmBridgeBuilder.BridgeJobParameters;
import com.bmc.caespToCtmBridgeBuilder.XmlSkeletonParser;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.workspace.IWorkspaceData;
import com.bmc.ctmconvert.workspace.XmlDomAggregator;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.w3c.dom.Element;

public class BridgesXmlWriter {
    private static final String XML_TITLE_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    private XmlElement jobElementTemplate;
    private XmlElement folderElement;
    private XmlDomAggregator xmlAggregator;
    private XmlSkeletonParser xmlSkeletonParser;

    public BridgesXmlWriter(XmlSkeletonParser xmlSkeletonParser) {
        this.xmlSkeletonParser = xmlSkeletonParser;
        this.jobElementTemplate = xmlSkeletonParser.getJobSkeleton();
        this.folderElement = xmlSkeletonParser.getFolderSkeleton();
    }

    public void addBridgeJobs(List<BridgeJobParameters> jobParameters, BridgeJobInjector injector) {
        jobParameters.stream().forEach(parameters -> {
            XmlElement job = injector.createJobFromTemplate((BridgeJobParameters)parameters, this.jobElementTemplate);
            this.folderElement.getElement().appendChild(job.getElement());
        });
    }

    public void writeResults(OutputStream xmlOutputStream) {
        this.xmlAggregator = new XmlDomAggregator((IWorkspaceData)this.xmlSkeletonParser);
        Element rootElement = this.xmlAggregator.getDraft();
        Element folderNode = (Element)rootElement.getOwnerDocument().importNode(this.folderElement.getElement(), true);
        rootElement.appendChild(folderNode);
        PrintWriter xmlPrinter = new PrintWriter(xmlOutputStream);
        xmlPrinter.write(XML_TITLE_HEADER);
        this.xmlAggregator.writeXml((Writer)xmlPrinter);
    }

    public XmlElement getFolderElement() {
        return this.folderElement;
    }
}

