/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.ArgumentsParser;
import com.bmc.caespToCtmBridgeBuilder.BridgeException;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class BridgeStreamRepository {
    private InputStream bridgeDataStream = null;
    private InputStream ctoRuleTemplateStream = null;
    private InputStream xmlSkeletonStream = null;
    private InputStream conditionPrefixesStream = null;
    private FileSystem fileSystem;
    private ArgumentsParser argumetParser;
    private String actionsOutput;
    private String ctoOutput;
    private String xmlOutput;
    public static final String ACTIONS_FILE_NAME = "AdjustCtmConditions.xlsx";
    public static final String CTORULES_FILE_NAME = "CTORULS";
    public static final String XML_FILE_NAME = "Bridge_Trigger_Jobs.xml";
    public static final String DEFAULT_OUTPUT_DIR = "Output";
    private OutputStream loggerStream;
    private String outputFolder;

    public BridgeStreamRepository(ArgumentsParser argumetParser, FileSystem fileSystem) throws IOException, BridgeException {
        this.argumetParser = argumetParser;
        this.fileSystem = fileSystem;
        this.buildStreams();
    }

    private InputStream toInputStream(String pathAsString) throws IOException {
        Path path = this.fileSystem.getPath(pathAsString, new String[0]);
        return Files.newInputStream(path, new OpenOption[0]);
    }

    private OutputStream toOutputStream(String pathAsString) throws IOException {
        Path path = this.fileSystem.getPath(pathAsString, new String[0]);
        return Files.newOutputStream(path, new OpenOption[0]);
    }

    public void buildStreams() throws BridgeException, IOException {
        String inputFile = this.argumetParser.getInputPath();
        this.outputFolder = this.argumetParser.getOutputPath();
        this.outputFolder = this.createOutputFolder(this.outputFolder);
        this.setLoggerOutput(this.outputFolder);
        String xmlSkeletonFile = this.argumetParser.getXmlSkeletonPath();
        Path outputPath = this.fileSystem.getPath(this.outputFolder, new String[0]);
        if (!Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new BridgeException("Invalid Output destination path (should represent directory)");
        }
        this.bridgeDataStream = this.toInputStream(inputFile);
        this.xmlSkeletonStream = xmlSkeletonFile != null ? this.toInputStream(xmlSkeletonFile) : new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<!--Exported at 11-04-2019 15:14:34-->\r\n<DEFTABLE xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Folder.xsd\">\r\n    <SMART_FOLDER JOBISN=\"0\" MEMNAME=\"SMART1\" CREATED_BY=\"emuser\" RUN_AS=\"CTM\" CRITICAL=\"0\" TASKTYPE=\"SMART Table\" CYCLIC=\"0\" INTERVAL=\"00001M\" CONFIRM=\"0\" RETRO=\"0\" MAXWAIT=\"0\" MAXRERUN=\"0\" AUTOARCH=\"1\" MAXDAYS=\"0\" MAXRUNS=\"0\" DAYS=\"ALL\" JAN=\"1\" FEB=\"1\" MAR=\"1\" APR=\"1\" MAY=\"1\" JUN=\"1\" JUL=\"1\" AUG=\"1\" SEP=\"1\" OCT=\"1\" NOV=\"1\" DEC=\"1\" DAYS_AND_OR=\"O\" SHIFT=\"Ignore Job\" SYSDB=\"1\" ADJUST_COND=\"N\" IND_CYCLIC=\"S\" APPL_TYPE=\"OS\" USE_INSTREAM_JCL=\"N\" CYCLIC_TOLERANCE=\"0\" CYCLIC_TYPE=\"C\" PARENT_FOLDER=\"SMART1\" REMOVEATONCE=\"N\" DAYSKEEPINNOTOK=\"0\" DATACENTER=\"DummyMF\" VERSION=\"918\" PLATFORM=\"MVS\" FOLDER_NAME=\"SMART1\" FOLDER_DSN=\"TEST.DSN\" FOLDER_ORDER_METHOD=\"SYSTEM\" REAL_FOLDER_ID=\"0\" TYPE=\"2\" ENFORCE_VALIDATION=\"N\">\r\n        <JOB JOBISN=\"0\" MEMNAME=\"JOB1\" CREATED_BY=\"emuser\" RUN_AS=\"CTM\" CRITICAL=\"0\" TASKTYPE=\"Job\" CYCLIC=\"0\" INTERVAL=\"00001M\" MEMLIB=\"GENERAL\" CONFIRM=\"0\" RETRO=\"0\" MAXWAIT=\"0\" MAXRERUN=\"0\" AUTOARCH=\"1\" MAXDAYS=\"0\" MAXRUNS=\"0\" DAYS=\"ALL\" JAN=\"1\" FEB=\"1\" MAR=\"1\" APR=\"1\" MAY=\"1\" JUN=\"1\" JUL=\"1\" AUG=\"1\" SEP=\"1\" OCT=\"1\" NOV=\"1\" DEC=\"1\" DAYS_AND_OR=\"O\" SHIFT=\"Ignore Job\" SHIFTNUM=\"+00\" SYSDB=\"1\" IND_CYCLIC=\"S\" RULE_BASED_CALENDAR_RELATIONSHIP=\"O\" APPL_TYPE=\"OS\" INSTREAM_JCL=\"0072//%%$MEMNAME JOB (4000),'CTM MAINT',MSGCLASS=N,                         0068//  CLASS=C                                                         0064//*                                                             0060//* %%INCLIB OPSPUB.CTMO.PARM %%INCMEM OPMERQ               0056//*                                                     0052//         JCLLIB  ORDER=SYS0.IOA.PROCLIB           0048//         INCLUDE MEMBER=IOASET                0044//*                                         0044//IOAOPR   EXEC IOAOPR                      0040//DA34F    DD   *                       0041F ESP,AJ @CTMJOB@ COMPLETE APPL(@FOLDER@)\" USE_INSTREAM_JCL=\"Y\" CYCLIC_TOLERANCE=\"0\" CYCLIC_TYPE=\"C\" PARENT_FOLDER=\"SMART1\" END_FOLDER=\"N\">\r\n        </JOB>\r\n        <RULE_BASED_CALENDAR NAME=\"EVERYDAY\" MAXWAIT=\"00\" DAYS_AND_OR=\"O\" JAN=\"1\" FEB=\"1\" MAR=\"1\" APR=\"1\" MAY=\"1\" JUN=\"1\" JUL=\"1\" AUG=\"1\" SEP=\"1\" OCT=\"1\" NOV=\"1\" DEC=\"1\" SHIFT=\"Ignore Job\" RETRO=\"0\" DAYS=\"ALL\" LEVEL=\"N\" />\r\n    </SMART_FOLDER>\r\n</DEFTABLE>\r\n".getBytes());
        try {
            this.conditionPrefixesStream = this.toInputStream("bridgeConditionsPrefixes.cfg");
        }
        catch (IOException e) {
            Logger.getLogger().writeToLog((Exception)e);
        }
        String templateCto = this.argumetParser.getTemplateCtoPath();
        this.ctoRuleTemplateStream = templateCto != null ? this.toInputStream(templateCto) : new ByteArrayInputStream("DN50        M        YYYYYYYYYYYY{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{\r\nW           W        YYYYYYYYYYYY{{{{{{{                        \r\nG                                YP305D                         \r\nOMA@MSG_ID@\r\nOS       @ESP_JOBNAME@\r\nTSN%%CND=@CONDITION_FORMAT@   \r\nTC%%CND               STAT+                                     \r\n0N50     2019031717.01.25N50     2019031717.05.499.0.19    01.01\r\n".getBytes());
        this.actionsOutput = this.outputFolder + Globs.DIRSEP + ACTIONS_FILE_NAME;
        this.ctoOutput = this.outputFolder + Globs.DIRSEP + CTORULES_FILE_NAME;
        this.xmlOutput = this.outputFolder + Globs.DIRSEP + XML_FILE_NAME;
    }

    private String createOutputFolder(String outputFolder) throws IOException, BridgeException {
        if (outputFolder.isEmpty()) {
            outputFolder = ".\\Output";
            Path outputPath = this.fileSystem.getPath(outputFolder, new String[0]);
            if (!Files.isDirectory(outputPath, new LinkOption[0])) {
                Files.createDirectory(outputPath, new FileAttribute[0]);
            }
        } else {
            Path outputPath = this.fileSystem.getPath(outputFolder, new String[0]);
            if (!Files.isDirectory(outputPath, new LinkOption[0])) {
                throw new BridgeException("Invalid Output destination path (should represent directory)");
            }
        }
        return outputFolder;
    }

    private void setLoggerOutput(String outputFolder) throws IOException {
        Path loggerPath = this.fileSystem.getPath(outputFolder, "logs.txt");
        this.loggerStream = Files.newOutputStream(loggerPath, new OpenOption[0]);
        Logger.getLogger().setOutputStream(this.loggerStream);
    }

    public OutputStream getLoggerStream() {
        return this.loggerStream;
    }

    public OutputStream getActionsOutputStream() throws IOException {
        return this.toOutputStream(this.actionsOutput);
    }

    public OutputStream getCtoOutputStream() throws IOException {
        return this.toOutputStream(this.ctoOutput);
    }

    public OutputStream getXmlOutputStream() throws IOException {
        return this.toOutputStream(this.xmlOutput);
    }

    public void setXmlSkeletonStream(InputStream xmlSkeletonStream) {
        this.xmlSkeletonStream = xmlSkeletonStream;
    }

    public InputStream getXmlSkeletonStream() {
        return this.xmlSkeletonStream;
    }

    public InputStream getBridgeData() {
        return this.bridgeDataStream;
    }

    public void setBridgeData(InputStream bridgeData) {
        this.bridgeDataStream = bridgeData;
    }

    public InputStream getCtoRuleTemplateStream() {
        return this.ctoRuleTemplateStream;
    }

    public void setCtoRuleTemplateStream(InputStream ctoRuleTemplateStream) {
        this.ctoRuleTemplateStream = ctoRuleTemplateStream;
    }

    public InputStream getConditionPrefixesStream() {
        return this.conditionPrefixesStream;
    }

    public void close() throws IOException {
        this.bridgeDataStream.close();
        this.ctoRuleTemplateStream.close();
        if (this.conditionPrefixesStream != null) {
            this.conditionPrefixesStream.close();
        }
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }
}

