/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.caespToCtmBridgeBuilder;

import com.bmc.caespToCtmBridgeBuilder.BridgeException;
import com.bmc.caespToCtmBridgeBuilder.BridgeJobParameters;
import com.bmc.caespToCtmBridgeBuilder.BridgeStreamRepository;
import com.bmc.caespToCtmBridgeBuilder.BridgesBuilder;
import com.bmc.caespToCtmBridgeBuilder.BridgesXmlWriter;
import com.bmc.caespToCtmBridgeBuilder.Constants;
import com.bmc.caespToCtmBridgeBuilder.EspBridgeJobInjector;
import com.bmc.caespToCtmBridgeBuilder.XmlSkeletonParser;
import com.bmc.ctmconvert.excel.ActionItem;
import com.bmc.ctmconvert.excel.ExcelWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class BridgeResultsWriter {
    private BridgesBuilder bridgesBuilder;
    private BridgeStreamRepository bridgeStreamRepository;

    public BridgeResultsWriter(BridgesBuilder bridgesBuilder, BridgeStreamRepository bridgeStreamRepository) {
        this.bridgesBuilder = bridgesBuilder;
        this.bridgeStreamRepository = bridgeStreamRepository;
    }

    public void writeReports() throws IOException, BridgeException {
        List<String> ctoRules = this.bridgesBuilder.getCtoRules();
        List<ActionItem> actionItems = this.bridgesBuilder.getActionItems();
        List<BridgeJobParameters> jobParameters = this.bridgesBuilder.getJobsParametersList();
        this.writeBridgesJobsXml(jobParameters);
        this.writeCtoRules(ctoRules);
        this.writeActions(actionItems);
    }

    private void writeActions(List<ActionItem> actionItems) throws IOException {
        if (actionItems.size() != 0) {
            ExcelWriter actionItemsWriter = new ExcelWriter();
            actionItemsWriter.addSheet("Action Items", Constants.ACTION_ITEMS_SHEET_HEADERS);
            actionItemsWriter.addRowsToSheet(actionItems, 0);
            actionItemsWriter.writeReport(this.bridgeStreamRepository.getActionsOutputStream());
        }
    }

    private void writeBridgesJobsXml(List<BridgeJobParameters> jobParameters) throws BridgeException, IOException {
        if (jobParameters.size() != 0) {
            XmlSkeletonParser xmlSkeletonParser = new XmlSkeletonParser();
            xmlSkeletonParser.parse(this.bridgeStreamRepository.getXmlSkeletonStream());
            BridgesXmlWriter bridgesXmlWriter = new BridgesXmlWriter(xmlSkeletonParser);
            EspBridgeJobInjector jobHandler = new EspBridgeJobInjector();
            bridgesXmlWriter.addBridgeJobs(jobParameters, jobHandler);
            bridgesXmlWriter.writeResults(this.bridgeStreamRepository.getXmlOutputStream());
        }
    }

    private void writeCtoRules(List<String> ctoRules) throws IOException {
        if (ctoRules.size() != 0) {
            PrintWriter ctoRulesWriter = new PrintWriter(this.bridgeStreamRepository.getCtoOutputStream());
            for (String ctoRule : ctoRules) {
                ((Writer)ctoRulesWriter).write(ctoRule);
                ((Writer)ctoRulesWriter).flush();
            }
            ((Writer)ctoRulesWriter).close();
        }
    }
}

