/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms.bmcdiscovery;

import com.bmc.ctmconvert.bmcdiscovery.DiscoveryIntegrationException;
import com.bmc.ctmconvert.bmcdiscovery.OSDiscoveryDefinitionsParser;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class MsDiscoveryDefinitionsParser
implements OSDiscoveryDefinitionsParser {
    private Map<String, String> msDefinitionsMap = new LinkedHashMap<String, String>();

    public void parse(JSONArray resultsArray) {
        JSONObject resultsContainerJson = resultsArray.getJSONObject(0);
        JSONArray results = resultsContainerJson.getJSONArray("results");
        results.forEach(result -> {
            JSONObject resultJson = (JSONObject)result;
            String hostName = resultJson.getString("#DiscoveryResult:DiscoveryAccessResult:DiscoveryAccess:DiscoveryAccess.#Associate:Inference:InferredElement:Host.name");
            String resultContent = resultJson.getString("result");
            this.msDefinitionsMap.put(hostName, resultContent);
        });
    }

    public Map getParsedDefinitions() throws DiscoveryIntegrationException {
        if (this.msDefinitionsMap.size() == 0) {
            throw new DiscoveryIntegrationException("No MS Task Scheduler job definitions were found by BMC Discovery.");
        }
        return new HashMap<String, String>(this.msDefinitionsMap);
    }
}

