/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.ms.MSGlobals;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;

public class XMLSplitter {
    private static final String TaskStart = "<!--";
    private static final String TaskEnd = "-->";
    private static final String TasksEnd = "</Tasks>";
    private List<String> filesNamesList = null;
    private List<String> tasksNamesList = null;

    public List<String> getFilesNames() {
        return this.filesNamesList;
    }

    public List<String> getTasksList() {
        return this.tasksNamesList;
    }

    public void splitXMLFile(String inFileName, String outDirectoryName) {
        if (null != this.filesNamesList) {
            this.filesNamesList.clear();
        }
        this.filesNamesList = new ArrayList<String>();
        if (null != this.tasksNamesList) {
            this.tasksNamesList.clear();
        }
        this.tasksNamesList = new ArrayList<String>();
        try {
            BufferedReader mainFileReader = new BufferedReader(new FileReader(inFileName));
            String sCurrentLine = null;
            String sCurrentOutName = "";
            StringBuilder sFileContent = new StringBuilder(8192);
            BufferedWriter bufOutStream = null;
            File outFile = null;
            new File(outDirectoryName).mkdirs();
            while ((sCurrentLine = mainFileReader.readLine()) != null && !sCurrentLine.equals(TasksEnd)) {
                if ((sCurrentLine = sCurrentLine.replaceAll("\t", "")).trim().length() <= 0) continue;
                if (sCurrentLine.startsWith(TaskStart) && sCurrentLine.endsWith(TaskEnd)) {
                    sCurrentOutName = sCurrentLine.replaceAll(TaskStart, "").replaceAll(TaskEnd, "").trim();
                    this.tasksNamesList.add(sCurrentOutName);
                    if (null != outFile && null != (bufOutStream = new BufferedWriter(new FileWriter(outFile))) && null != sFileContent && sFileContent.length() > 0) {
                        bufOutStream.write(sFileContent.toString());
                        bufOutStream.close();
                    }
                    sFileContent.setLength(0);
                    String[] parts = sCurrentOutName.split("[\\\\]");
                    String fileName = parts[parts.length - 1];
                    Object path = "";
                    if (parts.length > 2) {
                        for (int i = 1; i < parts.length - 1; ++i) {
                            path = (String)path + parts[i] + MSGlobals.FILESEPARATOR;
                        }
                        new File(outDirectoryName + (String)path).mkdirs();
                    }
                    outFile = new File(outDirectoryName + (String)path + fileName + ".xml");
                    this.filesNamesList.add(outFile.toString());
                    continue;
                }
                sFileContent.append(sCurrentLine);
                sFileContent.append(System.getProperty("line.separator"));
            }
            bufOutStream = new BufferedWriter(new FileWriter(outFile));
            if (null != bufOutStream && null != sFileContent && sFileContent.length() > 0) {
                bufOutStream.write(sFileContent.toString());
                bufOutStream.close();
            }
            mainFileReader.close();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((String)("Exception while reading file: " + inFileName + " , Exception: " + e.getMessage()));
        }
    }
}

