/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.ms.MSCsvTable;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MSCsv2XmlTransformer {
    private String m_xmlFileName;
    private int m_numberOfRecordsTransformed;
    private int m_tabIndex = 0;
    private String m_dateFormat = null;

    public MSCsv2XmlTransformer(String fileName, String path, String dateFormat) throws MSCsv2XmlTransformerException {
        if (fileName == null || path == null) {
            throw new MSCsv2XmlTransformerException("CSV file and path must be specified");
        }
        String csvFileName = path + Globs.DIRSEP + fileName;
        this.m_dateFormat = dateFormat;
        if (this.m_dateFormat == null) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3);
            this.m_dateFormat = df.toPattern();
        }
        this.m_dateFormat = this.m_dateFormat.replaceAll("-", "/");
        this.m_dateFormat = this.m_dateFormat.replaceAll(" ", "/");
        this.m_xmlFileName = path + Globs.DIRSEP + fileName.substring(0, fileName.length() - ".csv".length()) + ".xml";
        this.m_numberOfRecordsTransformed = this.transformCsv2Xml(csvFileName, this.m_xmlFileName);
    }

    public String XmlFileName() {
        return this.m_xmlFileName;
    }

    public int NumberOfRecordTransformed() {
        return this.m_numberOfRecordsTransformed;
    }

    public void setLineIndentionBefore(String line) {
        if (line.length() < 2) {
            return;
        }
        if (line.startsWith("</")) {
            this.decreaseTab();
        }
    }

    public void setLineIndentionAfter(String line) {
        if (line.length() < 2) {
            return;
        }
        if (line.startsWith("<!")) {
            return;
        }
        if (line.startsWith("<?")) {
            return;
        }
        if (line.startsWith("<") && line.endsWith("/>")) {
            return;
        }
        if (!line.startsWith("</") && line.startsWith("<") && line.endsWith(">") && line.indexOf("</", 1) <= 0) {
            this.increaseTab();
        }
    }

    public void increaseTab() {
        ++this.m_tabIndex;
    }

    public void decreaseTab() {
        if (this.m_tabIndex > 0) {
            --this.m_tabIndex;
        }
    }

    public String getTab() {
        Object retTab = "";
        for (int i = 0; i < this.m_tabIndex; ++i) {
            retTab = (String)retTab + "\t";
        }
        return retTab;
    }

    private boolean writeXmlLine(BufferedWriter outXml, String line) {
        boolean writeOk = true;
        this.setLineIndentionBefore(line);
        try {
            outXml.write(this.getTab() + line);
            outXml.newLine();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            writeOk = false;
        }
        this.setLineIndentionAfter(line);
        return writeOk;
    }

    private boolean buildAndWriteXmlAttr(BufferedWriter outXml, String tag, String attr) {
        Object line = "";
        boolean writeOk = true;
        line = "<" + tag + ">" + attr + "</" + tag + ">";
        writeOk = this.writeXmlLine(outXml, (String)line);
        return writeOk;
    }

    private String formatTimeValue(String value, String type) {
        Object retVal = "";
        if (!GlobalFunctions.isNumber((String)value)) {
            return retVal;
        }
        Integer valNum = Integer.parseInt(value);
        if (valNum == 0) {
            return retVal;
        }
        retVal = valNum.toString() + type.toUpperCase();
        return retVal;
    }

    private String calcPnYnMnDTnHnMnS(String value, String format) {
        Object retVal = "";
        String[] yymmddhhmmss = new String[6];
        if (format.equalsIgnoreCase("HH:MM:SS")) {
            String[] hhmmss = value.split(":");
            if (hhmmss.length > 0) {
                yymmddhhmmss[3] = this.formatTimeValue(hhmmss[0], "h");
            }
            if (hhmmss.length > 1) {
                yymmddhhmmss[4] = this.formatTimeValue(hhmmss[1], "m");
            }
            if (hhmmss.length > 2) {
                yymmddhhmmss[5] = this.formatTimeValue(hhmmss[2], "s");
            }
        } else if (format.equalsIgnoreCase("h hours m minutes s seconds")) {
            String[] word = value.split("[ ,]+");
            for (int i = 0; i < word.length; ++i) {
                String word_i = word[i].trim();
                if ((word_i.equalsIgnoreCase("years") || word_i.equalsIgnoreCase("year") || word_i.equalsIgnoreCase("year(s)")) && i > 0) {
                    yymmddhhmmss[0] = this.formatTimeValue(word[i - 1], "Y");
                }
                if ((word_i.equalsIgnoreCase("months") || word_i.equalsIgnoreCase("month") || word_i.equalsIgnoreCase("month(s)")) && i > 0) {
                    yymmddhhmmss[1] = this.formatTimeValue(word[i - 1], "M");
                }
                if ((word_i.equalsIgnoreCase("days") || word_i.equalsIgnoreCase("day") || word_i.equalsIgnoreCase("day(s)")) && i > 0) {
                    yymmddhhmmss[2] = this.formatTimeValue(word[i - 1], "D");
                }
                if ((word_i.equalsIgnoreCase("hours") || word_i.equalsIgnoreCase("hour") || word_i.equalsIgnoreCase("hour(s)")) && i > 0) {
                    yymmddhhmmss[3] = this.formatTimeValue(word[i - 1], "h");
                }
                if ((word_i.equalsIgnoreCase("minutes") || word_i.equalsIgnoreCase("minute") || word_i.equalsIgnoreCase("minute(s)")) && i > 0) {
                    yymmddhhmmss[4] = this.formatTimeValue(word[i - 1], "m");
                }
                if (!word_i.equalsIgnoreCase("seconds") && !word_i.equalsIgnoreCase("second") && !word_i.equalsIgnoreCase("second(s)") || i <= 0) continue;
                yymmddhhmmss[5] = this.formatTimeValue(word[i - 1], "s");
            }
        }
        for (int i = 0; i < yymmddhhmmss.length; ++i) {
            if (i == 0) {
                retVal = (String)retVal + "P";
            }
            if (i == 3) {
                retVal = (String)retVal + "T";
            }
            if (yymmddhhmmss[i] == null || yymmddhhmmss[i].length() <= 0) continue;
            retVal = (String)retVal + yymmddhhmmss[i];
        }
        return retVal;
    }

    private String extractDateTimeValue(String value, String dateTimeElement) {
        String retVal = "";
        String[] word = value.split("[ ,]+");
        for (int i = 0; i < word.length; ++i) {
            if (!word[i].equalsIgnoreCase(dateTimeElement) && !word[i].equalsIgnoreCase(dateTimeElement + "(s)") && !word[i].equalsIgnoreCase(dateTimeElement + "s")) continue;
            if (i > 0) {
                retVal = this.formatTimeValue(word[i - 1], "");
            }
            if (!retVal.equals("") || !word[i].equalsIgnoreCase(dateTimeElement)) break;
            retVal = "1";
            break;
        }
        return retVal;
    }

    private String convertTime2HHMMSS(String time) {
        Object ret = "00:00:00";
        String[] hhmmss = time.split("[: ]+");
        if (hhmmss.length < 4) {
            return ret;
        }
        if (GlobalFunctions.isNumber((String)hhmmss[0].trim())) {
            Integer hh = Integer.parseInt(hhmmss[0].trim());
            if (hhmmss[3].equalsIgnoreCase("PM")) {
                hh = hh + 12;
            }
            hhmmss[0] = String.format("%02d", hh);
        } else {
            hhmmss[0] = "00";
        }
        if (GlobalFunctions.isNumber((String)hhmmss[1].trim())) {
            Integer mm = Integer.parseInt(hhmmss[1].trim());
            hhmmss[1] = String.format("%02d", mm);
        } else {
            hhmmss[1] = "00";
        }
        if (GlobalFunctions.isNumber((String)hhmmss[2].trim())) {
            Integer ss = Integer.parseInt(hhmmss[2].trim());
            hhmmss[2] = String.format("%02d", ss);
        } else {
            hhmmss[2] = "00";
        }
        ret = hhmmss[0] + ":" + hhmmss[1] + ":" + hhmmss[2];
        return ret;
    }

    private String convertDate2YYYYMMDD(String date) {
        String ret = "2000-01-01";
        try {
            Date formatedDate = new SimpleDateFormat(this.m_dateFormat).parse(date);
            ret = new SimpleDateFormat("yyyy-MM-dd").format(formatedDate);
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        return ret;
    }

    private String[] extractWeeks(String schedule) {
        boolean[] allWeeks = new boolean[]{false, false, false, false, false, false, false};
        int count = 0;
        int start = schedule.indexOf("on the");
        if (start > 0) {
            if (schedule.indexOf("last", start += 7) > 0) {
                allWeeks[0] = true;
                ++count;
            }
            if (schedule.indexOf("first", start) > 0) {
                allWeeks[1] = true;
                ++count;
            }
            if (schedule.indexOf("second", start) > 0) {
                allWeeks[2] = true;
                ++count;
            }
            if (schedule.indexOf("third", start) > 0) {
                allWeeks[3] = true;
                ++count;
            }
            if (schedule.indexOf("forth", start) > 0) {
                allWeeks[4] = true;
                ++count;
            }
            if (schedule.indexOf("fifth", start) > 0) {
                allWeeks[5] = true;
                ++count;
            }
            if (schedule.indexOf("sixth", start) > 0) {
                allWeeks[6] = true;
                ++count;
            }
        }
        String[] weeks = new String[count];
        for (int i = 0; i < allWeeks.length; ++i) {
            if (!allWeeks[i]) continue;
            weeks[--count] = i == 0 ? "last" : String.valueOf(i);
        }
        return weeks;
    }

    private int transformCsv2Xml(String csvFileName, String xmlFileName) throws MSCsv2XmlTransformerException {
        MSCsvTable csvTable = MSCsvTable.instance(csvFileName);
        int numberOfRecordsTransformed = 0;
        try {
            IAttrHolder csvAttributes;
            BufferedWriter outXml = new BufferedWriter(new FileWriter(xmlFileName));
            this.writeXmlLine(outXml, "<Tasks>");
            for (int rec_number = 1; rec_number <= csvTable.getRecordsReadCount() && ((csvAttributes = csvTable.getMSCsvTableAttributes(rec_number)).isFieldExist("HostName") || csvAttributes.isFieldExist("TaskName")); ++rec_number) {
                boolean transformedOK;
                if (csvAttributes.getAttr("HostName").equalsIgnoreCase("HostName") && csvAttributes.getAttr("TaskName").equalsIgnoreCase("TaskName") || !(transformedOK = this.writeAttr2Xml(outXml, csvAttributes))) continue;
                ++numberOfRecordsTransformed;
            }
            this.writeXmlLine(outXml, "</Tasks>");
            outXml.flush();
            outXml.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        MSCsvTable.destroy();
        return numberOfRecordsTransformed;
    }

    private boolean writeAttr2Xml(BufferedWriter outXml, IAttrHolder attr) {
        boolean transformedOK = true;
        Object line = "";
        if (attr.isFieldExist("TaskName")) {
            line = "<!-- " + attr.getAttr("TaskName") + " -->";
            transformedOK = this.writeXmlLine(outXml, (String)line);
        }
        line = "<?xml version=\"1.0\" encoding=\"UTF-16\"?>";
        transformedOK = this.writeXmlLine(outXml, (String)line);
        line = "<Task version=\"1.1\" xmlns=\"http://schemas.microsoft.com/windows/2004/02/mit/task\">";
        transformedOK = this.writeXmlLine(outXml, (String)line);
        this.writeRegistrationInfo(outXml, attr);
        this.writeTriggers(outXml, attr);
        this.writeSettings(outXml, attr);
        this.writePrincipals(outXml, attr);
        this.writeActions(outXml, attr);
        line = "</Task>";
        transformedOK = this.writeXmlLine(outXml, (String)line);
        return transformedOK;
    }

    private boolean writeRegistrationInfo(BufferedWriter outXml, IAttrHolder attr) {
        boolean transformedOK = true;
        String line = "";
        line = "<RegistrationInfo>";
        transformedOK = this.writeXmlLine(outXml, line);
        String author = "";
        if (attr.isFieldExist("Author")) {
            author = attr.getAttr("Author");
        } else if (attr.isFieldExist("Creator")) {
            author = attr.getAttr("Creator");
        }
        if (author.length() > 0) {
            transformedOK = this.buildAndWriteXmlAttr(outXml, "Author", author);
        }
        if (attr.isFieldExist("Comment")) {
            transformedOK = this.buildAndWriteXmlAttr(outXml, "Description", attr.getAttr("Comment"));
        }
        line = "</RegistrationInfo>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writeTriggers(BufferedWriter outXml, IAttrHolder attr) {
        boolean transformedOK = true;
        String line = "";
        line = "<Triggers>";
        transformedOK = this.writeXmlLine(outXml, line);
        String ScheduleType = "One Time Only";
        if (attr.isFieldExist("Scheduled Type")) {
            ScheduleType = attr.getAttr("Scheduled Type");
        } else if (attr.isFieldExist("Schedule Type")) {
            ScheduleType = attr.getAttr("Schedule Type");
        }
        if (ScheduleType.equalsIgnoreCase("One Time Only") || ScheduleType.equalsIgnoreCase("One Time Only, Hourly")) {
            this.writeTriggerOneTime(outXml, attr, ScheduleType);
        } else if (ScheduleType.equalsIgnoreCase("At logon time")) {
            this.writeTriggerLogon(outXml, attr, ScheduleType);
        } else if (ScheduleType.equalsIgnoreCase("When an event occurs")) {
            this.writeTriggerEvent(outXml, attr, ScheduleType);
        } else if (ScheduleType.equalsIgnoreCase("At system start up")) {
            this.writeTriggerSystemStartup(outXml, attr, ScheduleType);
        } else if (ScheduleType.equalsIgnoreCase("On demand only")) {
            this.writeTriggerOnDemand(outXml, attr, ScheduleType);
        } else if (ScheduleType.equalsIgnoreCase("At idle time")) {
            this.writeTriggerIdle(outXml, attr, ScheduleType);
        } else {
            this.writeTriggerCalendar(outXml, attr, ScheduleType);
        }
        line = "</Triggers>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writeTriggerOneTime(BufferedWriter outXml, IAttrHolder attr, String ScheduleType) {
        boolean transformedOK = true;
        String line = "";
        line = "<TimeTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        transformedOK = this.buildAndWriteXmlAttr(outXml, "Enabled", "true");
        transformedOK = this.writeTriggerBoundary(outXml, attr);
        if (attr.isFieldExist("Schedule Type")) {
            ScheduleType = attr.getAttr("Schedule Type");
        }
        if (ScheduleType.contains("Hourly")) {
            transformedOK = this.writeTriggerRepetition(outXml, attr);
        }
        line = "</TimeTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writeTriggerLogon(BufferedWriter outXml, IAttrHolder attr, String ScheduleType) {
        boolean transformedOK = true;
        String line = "";
        line = "<LogonTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        transformedOK = this.buildAndWriteXmlAttr(outXml, "Enabled", "true");
        transformedOK = this.writeTriggerRepetition(outXml, attr);
        transformedOK = this.writeTriggerRepetition(outXml, attr);
        transformedOK = this.writeTriggerBoundary(outXml, attr);
        line = "</LogonTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writeTriggerEvent(BufferedWriter outXml, IAttrHolder attr, String ScheduleType) {
        boolean transformedOK = true;
        String line = "";
        line = "<EventTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        transformedOK = this.buildAndWriteXmlAttr(outXml, "Enabled", "true");
        transformedOK = this.writeTriggerRepetition(outXml, attr);
        line = "</EventTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writeTriggerSystemStartup(BufferedWriter outXml, IAttrHolder attr, String ScheduleType) {
        boolean transformedOK = true;
        String line = "";
        line = "<BootTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        transformedOK = this.buildAndWriteXmlAttr(outXml, "Enabled", "true");
        transformedOK = this.writeTriggerRepetition(outXml, attr);
        transformedOK = this.writeTriggerRepetition(outXml, attr);
        transformedOK = this.writeTriggerBoundary(outXml, attr);
        line = "</BootTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writeTriggerOnDemand(BufferedWriter outXml, IAttrHolder attr, String ScheduleType) {
        boolean transformedOK = true;
        return transformedOK;
    }

    private boolean writeTriggerIdle(BufferedWriter outXml, IAttrHolder attr, String ScheduleType) {
        boolean transformedOK = true;
        String line = "";
        line = "<IdleTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        transformedOK = this.buildAndWriteXmlAttr(outXml, "Enabled", "true");
        line = "</IdleTrigger>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writeTriggerCalendar(BufferedWriter outXml, IAttrHolder attr, String ScheduleType) {
        boolean transformedOK = true;
        Object line = "";
        line = "<CalendarTrigger>";
        transformedOK = this.writeXmlLine(outXml, (String)line);
        transformedOK = this.buildAndWriteXmlAttr(outXml, "Enabled", "true");
        transformedOK = this.writeTriggerRepetition(outXml, attr);
        transformedOK = this.writeTriggerBoundary(outXml, attr);
        if (ScheduleType.equalsIgnoreCase("Daily")) {
            line = "<ScheduleByDay>";
            transformedOK = this.writeXmlLine(outXml, (String)line);
            if (attr.isFieldExist("Days")) {
                transformedOK = this.buildAndWriteXmlAttr(outXml, "DaysInterval", this.extractDateTimeValue(attr.getAttr("Days"), "day"));
            }
            line = "</ScheduleByDay>";
            transformedOK = this.writeXmlLine(outXml, (String)line);
        } else if (ScheduleType.equalsIgnoreCase("Weekly")) {
            line = "<ScheduleByWeek>";
            transformedOK = this.writeXmlLine(outXml, (String)line);
            if (attr.isFieldExist("Days") && !attr.getAttr("Days").equals("") && !attr.getAttr("Days").equalsIgnoreCase("N/A")) {
                line = "<DaysOfWeek>";
                transformedOK = this.writeXmlLine(outXml, (String)line);
                String[] days = attr.getAttr("Days").split("[, ]+");
                for (int i = 0; i < days.length; ++i) {
                    String day = GlobalFunctions.convertCalendarDayOfWeekToWeekday((int)GlobalFunctions.convertWeekdayToCalendarDayOfWeek((String)days[i]), (boolean)false);
                    line = "<" + day + "/>";
                    transformedOK = this.writeXmlLine(outXml, (String)line);
                }
                line = "</DaysOfWeek>";
                transformedOK = this.writeXmlLine(outXml, (String)line);
            }
            if (attr.isFieldExist("Months")) {
                String schedDesc = attr.getAttr("Months");
                if (schedDesc.equalsIgnoreCase("N/A") && attr.isFieldExist("Schedule") && !attr.getAttr("Schedule").equalsIgnoreCase("Scheduling data is not available in this format.")) {
                    schedDesc = attr.getAttr("Schedule");
                }
                if (!schedDesc.equalsIgnoreCase("N/A")) {
                    transformedOK = this.buildAndWriteXmlAttr(outXml, "WeeksInterval", this.extractDateTimeValue(schedDesc, "week"));
                }
            }
            line = "</ScheduleByWeek>";
            transformedOK = this.writeXmlLine(outXml, (String)line);
        } else if (ScheduleType.equalsIgnoreCase("Monthly")) {
            int i;
            String[] days;
            boolean isDayOfWeek = false;
            if (attr.isFieldExist("Days") && !attr.getAttr("Days").equals("") && !attr.getAttr("Days").equalsIgnoreCase("N/A") && !GlobalFunctions.isNumber((String)(days = attr.getAttr("Days").split("[, ]+"))[0])) {
                isDayOfWeek = true;
            }
            line = isDayOfWeek ? "<ScheduleByMonthDayOfWeek>" : "<ScheduleByMonth>";
            transformedOK = this.writeXmlLine(outXml, (String)line);
            if (attr.isFieldExist("Days") && !attr.getAttr("Days").equals("") && !attr.getAttr("Days").equalsIgnoreCase("N/A")) {
                line = isDayOfWeek ? "<DaysOfWeek>" : "<DaysOfMonth>";
                transformedOK = this.writeXmlLine(outXml, (String)line);
                days = attr.getAttr("Days").split("[, ]+");
                for (i = 0; i < days.length; ++i) {
                    if (isDayOfWeek) {
                        String day = GlobalFunctions.convertCalendarDayOfWeekToWeekday((int)GlobalFunctions.convertWeekdayToCalendarDayOfWeek((String)days[i]), (boolean)false);
                        line = "<" + day + "/>";
                    } else {
                        line = "<Day>" + days[i] + "</Day>";
                    }
                    transformedOK = this.writeXmlLine(outXml, (String)line);
                }
                line = isDayOfWeek ? "</DaysOfWeek>" : "</DaysOfMonth>";
                transformedOK = this.writeXmlLine(outXml, (String)line);
            }
            if (attr.isFieldExist("Months") && !attr.getAttr("Months").equals("") && !attr.getAttr("Months").equalsIgnoreCase("N/A")) {
                line = "<Months>";
                transformedOK = this.writeXmlLine(outXml, (String)line);
                String[] months = attr.getAttr("Months").split("[, ]+");
                for (i = 0; i < months.length; ++i) {
                    int monthIdx = GlobalFunctions.getMonthIndex((String[])GlobalFunctions.getMonthsArray((Boolean)false), (String)months[i]);
                    if (monthIdx < 0) {
                        monthIdx = GlobalFunctions.getMonthIndex((String[])GlobalFunctions.getMonthsArray((Boolean)true), (String)months[i]);
                    }
                    if (monthIdx > 0) {
                        line = "<" + GlobalFunctions.getMonthsArray((Boolean)true)[monthIdx - 1] + "/>";
                    }
                    transformedOK = this.writeXmlLine(outXml, (String)line);
                }
                line = "</Months>";
                transformedOK = this.writeXmlLine(outXml, (String)line);
            }
            if (isDayOfWeek) {
                line = "<Weeks>";
                transformedOK = this.writeXmlLine(outXml, (String)line);
                if (attr.isFieldExist("Schedule") && !attr.getAttr("Schedule").equals("") && !attr.getAttr("Schedule").equalsIgnoreCase("N/A")) {
                    String[] weeks = this.extractWeeks(attr.getAttr("Schedule"));
                    for (i = 0; i < weeks.length; ++i) {
                        line = "<Week>" + weeks[i] + "</Week>";
                        transformedOK = this.writeXmlLine(outXml, (String)line);
                    }
                }
                line = "</Weeks>";
                transformedOK = this.writeXmlLine(outXml, (String)line);
            }
            line = isDayOfWeek ? "</ScheduleByMonthDayOfWeek>" : "</ScheduleByMonth>";
            transformedOK = this.writeXmlLine(outXml, (String)line);
        }
        line = "</CalendarTrigger>";
        transformedOK = this.writeXmlLine(outXml, (String)line);
        return transformedOK;
    }

    private boolean writeTriggerRepetition(BufferedWriter outXml, IAttrHolder attr) {
        boolean transformedOK = true;
        String line = "";
        if (attr.isFieldExist("Repeat: Every") && !attr.getAttr("Repeat: Every").equalsIgnoreCase("N/A") && !attr.getAttr("Repeat: Every").equalsIgnoreCase("Disabled")) {
            line = "<Repetition>";
            transformedOK = this.writeXmlLine(outXml, line);
            transformedOK = this.buildAndWriteXmlAttr(outXml, "Interval", this.calcPnYnMnDTnHnMnS(attr.getAttr("Repeat: Every"), "h hours m minutes s seconds"));
            if (attr.isFieldExist("Repeat: Until: Duration") && !attr.getAttr("Repeat: Until: Duration").equalsIgnoreCase("N/A") && !attr.getAttr("Repeat: Until: Duration").equalsIgnoreCase("Disabled")) {
                transformedOK = this.buildAndWriteXmlAttr(outXml, "Duration", this.calcPnYnMnDTnHnMnS(attr.getAttr("Repeat: Until: Duration"), "h hours m minutes s seconds"));
            }
            if (attr.isFieldExist("Repeat: Stop If Still Running") && attr.getAttr("Repeat: Stop If Still Running").equalsIgnoreCase("Enabled")) {
                transformedOK = this.buildAndWriteXmlAttr(outXml, "StopAtDurationEnd", "true");
            }
            line = "</Repetition>";
            transformedOK = this.writeXmlLine(outXml, line);
        }
        return transformedOK;
    }

    private boolean writeTriggerBoundary(BufferedWriter outXml, IAttrHolder attr) {
        boolean transformedOK = true;
        Object line = "";
        if (attr.isFieldExist("Start Date") && !attr.getAttr("Start Date").equalsIgnoreCase("N/A") && !attr.getAttr("Start Date").equalsIgnoreCase("Start Date")) {
            String st;
            String startTime = "00:00:00";
            if (attr.isFieldExist("Start Time") && !(st = attr.getAttr("Start Time")).equalsIgnoreCase("N/A") && !st.equalsIgnoreCase("Start Time") && (st.endsWith("AM") || st.endsWith("PM"))) {
                startTime = this.convertTime2HHMMSS(st);
            }
            line = "<StartBoundary>" + this.convertDate2YYYYMMDD(attr.getAttr("Start Date")) + "T" + startTime + "</StartBoundary>";
            transformedOK = this.writeXmlLine(outXml, (String)line);
        }
        if (attr.isFieldExist("End Date") && !attr.getAttr("End Date").equalsIgnoreCase("N/A") && !attr.getAttr("End Date").equalsIgnoreCase("End Date")) {
            String endTime = "00:00:00";
            line = "<EndBoundary>" + this.convertDate2YYYYMMDD(attr.getAttr("End Date")) + "T" + endTime + "</EndBoundary>";
            transformedOK = this.writeXmlLine(outXml, (String)line);
        }
        return transformedOK;
    }

    private boolean writeSettings(BufferedWriter outXml, IAttrHolder attr) {
        boolean transformedOK = true;
        String line = "";
        line = "<Settings>";
        transformedOK = this.writeXmlLine(outXml, line);
        if (attr.isFieldExist("Scheduled Task State")) {
            String enabled = "true";
            if (attr.getAttr("Scheduled Task State").equalsIgnoreCase("Disabled")) {
                enabled = "false";
            }
            transformedOK = this.buildAndWriteXmlAttr(outXml, "Enabled", enabled);
        }
        if (attr.isFieldExist("Stop Task If Runs X Hours and X Mins") && !attr.getAttr("Stop Task If Runs X Hours and X Mins").equalsIgnoreCase("Disabled")) {
            transformedOK = this.buildAndWriteXmlAttr(outXml, "ExecutionTimeLimit", this.calcPnYnMnDTnHnMnS(attr.getAttr("Stop Task If Runs X Hours and X Mins"), "HH:MM:SS"));
        }
        String DisallowStartIfOnBatteries = "false";
        String StopIfGoingOnBatteries = "false";
        if (attr.isFieldExist("Power Management")) {
            if (attr.getAttr("Power Management").contains("Stop On Battery Mode")) {
                StopIfGoingOnBatteries = "true";
            }
            if (attr.getAttr("Power Management").contains("No Start On Batteries")) {
                DisallowStartIfOnBatteries = "true";
            }
            transformedOK = this.buildAndWriteXmlAttr(outXml, "DisallowStartIfOnBatteries", DisallowStartIfOnBatteries);
            transformedOK = this.buildAndWriteXmlAttr(outXml, "StopIfGoingOnBatteries", StopIfGoingOnBatteries);
        }
        if (attr.isFieldExist("Idle Time") && !attr.getAttr("Idle Time").equalsIgnoreCase("Disabled")) {
            transformedOK = this.buildAndWriteXmlAttr(outXml, "RunOnlyIfIdle", "true");
            transformedOK = this.writeXmlLine(outXml, "<IdleSettings>");
            String[] idleSetting = attr.getAttr("Idle Time").split(",");
            for (int i = 0; i < idleSetting.length; ++i) {
                if (idleSetting[i].contains("Only Start If Idle for")) {
                    transformedOK = this.buildAndWriteXmlAttr(outXml, "ExecutionTimeLimit", this.calcPnYnMnDTnHnMnS(idleSetting[i].trim().substring(22), "h hours m minutes s seconds"));
                } else if (idleSetting[i].contains("If Not Idle Retry For")) {
                    transformedOK = this.buildAndWriteXmlAttr(outXml, "WaitTimeout", this.calcPnYnMnDTnHnMnS(idleSetting[i].trim().substring(21), "h hours m minutes s seconds"));
                }
                if (!idleSetting[i].contains("Stop the task if Idle State end")) continue;
                transformedOK = this.buildAndWriteXmlAttr(outXml, "StopOnIdleEnd", "true");
                transformedOK = this.buildAndWriteXmlAttr(outXml, "RestartOnIdle", "true");
            }
            transformedOK = this.writeXmlLine(outXml, "</IdleSettings>");
        }
        line = "<Priority>7</Priority>";
        transformedOK = this.writeXmlLine(outXml, line);
        line = "</Settings>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writePrincipals(BufferedWriter outXml, IAttrHolder attr) {
        boolean transformedOK = true;
        String line = "";
        line = "<Principals>";
        transformedOK = this.writeXmlLine(outXml, line);
        line = "<Principal id=\"Author\">";
        transformedOK = this.writeXmlLine(outXml, line);
        if (attr.isFieldExist("Run As User")) {
            transformedOK = this.buildAndWriteXmlAttr(outXml, "UserId", attr.getAttr("Run As User"));
        }
        if (attr.isFieldExist("Logon Mode")) {
            String LogonType = "Password";
            if (attr.getAttr("Logon Mode").equalsIgnoreCase("Interactive only")) {
                LogonType = "InteractiveToken";
            } else if (attr.getAttr("Logon Mode").equalsIgnoreCase("Interactive/Background")) {
                LogonType = "InteractiveTokenOrPassword";
            }
            transformedOK = this.buildAndWriteXmlAttr(outXml, "LogonType", LogonType);
        }
        line = "</Principal>";
        transformedOK = this.writeXmlLine(outXml, line);
        line = "</Principals>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    private boolean writeActions(BufferedWriter outXml, IAttrHolder attr) {
        boolean transformedOK = true;
        String line = "";
        line = "<Actions Context=\"Author\">";
        transformedOK = this.writeXmlLine(outXml, line);
        if (attr.isFieldExist("Task To Run")) {
            String exec = attr.getAttr("Task To Run");
            if (exec.equalsIgnoreCase("COM handler")) {
                line = "<ComHandler>";
                transformedOK = this.writeXmlLine(outXml, line);
                line = "</ComHandler>";
                transformedOK = this.writeXmlLine(outXml, line);
            } else {
                line = "<Exec>";
                transformedOK = this.writeXmlLine(outXml, line);
                transformedOK = this.buildAndWriteXmlAttr(outXml, "Command", exec);
                if (attr.isFieldExist("Start In") && !attr.getAttr("Start In").equalsIgnoreCase("N/A") && !attr.getAttr("Start In").equalsIgnoreCase("Multiple actions") && !attr.getAttr("Start In").equalsIgnoreCase("Start In")) {
                    transformedOK = this.buildAndWriteXmlAttr(outXml, "WorkingDirectory", attr.getAttr("Start In"));
                }
                line = "</Exec>";
                transformedOK = this.writeXmlLine(outXml, line);
            }
        }
        line = "</Actions>";
        transformedOK = this.writeXmlLine(outXml, line);
        return transformedOK;
    }

    public static void main(String[] args) {
        try {
            String dateFormat = "MM-dd-yyyy";
            MSCsv2XmlTransformer Csv2XmlTransformer = new MSCsv2XmlTransformer("Machine.CSV", "G:\\TEMP", dateFormat);
            System.out.println("DONE!. XML file name is " + Csv2XmlTransformer.XmlFileName());
            System.out.println("Number of records transformed: " + String.valueOf(Csv2XmlTransformer.NumberOfRecordTransformed()));
        }
        catch (MSCsv2XmlTransformerException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public class MSCsv2XmlTransformerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MSCsv2XmlTransformerException(String msg) {
            super(msg);
        }
    }
}

