/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.bmcdiscovery.DiscoveryIntegrationException;
import com.bmc.ctmconvert.bmcdiscovery.OSDiscoveryDefinitionsParser;
import com.bmc.ctmconvert.bmcdiscovery.OSDiscoveryFilesWriter;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.ms.MSCsv2XmlTransformer;
import com.bmc.ctmconvert.ms.MSGlobals;
import com.bmc.ctmconvert.ms.TasksDirectories;
import com.bmc.ctmconvert.ms.XMLSplitter;
import com.bmc.ctmconvert.ms.bmcdiscovery.MsDiscoveryDefinitionsParser;
import com.bmc.ctmconvert.ms.bmcdiscovery.MsDiscoveryFilesWriter;
import com.bmc.ctmconvert.os.DISCOVERY_OS_TYPE;
import com.bmc.ctmconvert.os.DataImportOS;
import com.bmc.ctmconvert.os.DiscoveryCollectionHandler;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DataImportMS
extends DataImportOS {
    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        FlowGlobals.COMPLETION_MODE ended = super.performDataImport(destinationFolderPath, progressBar);
        DataImportMS.preformImport(destinationFolderPath, progressBar);
        return ended;
    }

    public static void preformImport(String destinationFolderPath, BaseProgressBar progressBar) {
        String[] machinesCSVFiles = TasksDirectories.getMachinesListInDirectory(destinationFolderPath, ".csv");
        if (null != machinesCSVFiles && machinesCSVFiles.length > 0) {
            Properties dateFormatMap = new Properties();
            try (FileReader reader2 = new FileReader(Params.instance().getDatasourcePath() + "dateMap.txt");){
                dateFormatMap.load(reader2);
            }
            catch (FileNotFoundException reader2) {
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
            for (String csvMachineFile : machinesCSVFiles) {
                try {
                    String dateFormat = dateFormatMap.getProperty((String)csvMachineFile.subSequence(0, csvMachineFile.lastIndexOf(".")));
                    new MSCsv2XmlTransformer(csvMachineFile, destinationFolderPath, dateFormat);
                }
                catch (Exception e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                }
            }
        }
        String[] machinesFiles = TasksDirectories.getMachinesListInDirectory(destinationFolderPath, ".xml");
        int progress = 25;
        if (progressBar != null) {
            progressBar.setProgressValue(progress);
            progressBar.setLabel(TextManager.instance().get("DATA_IMPORT_OS_PROGRESS_BAR_PROCESSING"));
        }
        XMLSplitter sp = new XMLSplitter();
        for (String machineFile : machinesFiles) {
            String machine = machineFile.substring(0, machineFile.length() - MSGlobals.iXMLPrefixLen - 1);
            sp.splitXMLFile(destinationFolderPath + MSGlobals.FILESEPARATOR + machineFile, destinationFolderPath + MSGlobals.FILESEPARATOR + "Data" + MSGlobals.FILESEPARATOR + machine + MSGlobals.FILESEPARATOR);
            if (progressBar == null) continue;
            progressBar.setProgressValue(progress += 75 / machinesFiles.length);
        }
    }

    public String getHelpTitle() {
        return switch (this.importPanels) {
            case DataImportOS.ImportPanels.DATA_IMPORT -> "LOAD_DATA_MS_MANUAL_OR_AUTOMATIC";
            case DataImportOS.ImportPanels.DISCOVERY_AGENTS_LIST, DataImportOS.ImportPanels.DISCOVERY_RESULT_LIST -> "LOAD_DATA_MS_AUTOMATIC";
            case DataImportOS.ImportPanels.MANUAL_DATA_IMPORT -> "LOAD_DATA_MS_MANUAL";
            default -> "";
        };
    }

    protected Map<BaseRadioButton, BaseField> getCustomComponents() {
        return new HashMap<BaseRadioButton, BaseField>();
    }

    public FlowGlobals.COMPLETION_MODE getHandleDiscoveryCollection(String destinationFolderPath, String hostname, String username, String password) throws DiscoveryIntegrationException {
        MsDiscoveryDefinitionsParser cronDefParser = new MsDiscoveryDefinitionsParser();
        MsDiscoveryFilesWriter cronFilesWriter = new MsDiscoveryFilesWriter(destinationFolderPath);
        DiscoveryCollectionHandler discoveryCollectionHandler = new DiscoveryCollectionHandler(destinationFolderPath);
        return discoveryCollectionHandler.handleDiscoveryCollection(hostname, username, password, DISCOVERY_OS_TYPE.DISCOVERY_TOOL_WINDOWS, (OSDiscoveryDefinitionsParser)cronDefParser, (OSDiscoveryFilesWriter)cronFilesWriter);
    }

    protected String getManualDataImportInstructions() {
        return String.format(TextManager.instance().get("MS_DATA_IMPORT_MANUAL_DESCRIPTION"), "\n", "\n", "\n");
    }
}

