/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.ms;

import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class CalendarUtil {
    public static String[] confCalsList = new String[55];
    public static String sWeeksConfCalName = "Every%dWeeks";
    private static boolean bConfCalsListInitialized = false;
    private static int nWeekDays = 7;

    public static String getCalendarName(int i) {
        return FieldValidation.instance().validateAndReturnFixedValue("CONFCAL", String.format(sWeeksConfCalName, i));
    }

    public static void CreateCalendarsFile(String sDataCenter, int iStartYear, int iEndYear) throws IOException {
        if (bConfCalsListInitialized) {
            return;
        }
        if (iEndYear < iStartYear) {
            return;
        }
        for (int index = 0; index < 55; ++index) {
            CalendarUtil.confCalsList[index] = String.format(sWeeksConfCalName, index);
        }
        try (DefCalFile defcal = DefCalFile.createDefCalFile();){
            Calendar calendarStart = Calendar.getInstance();
            calendarStart.set(1, iStartYear);
            calendarStart.set(2, 0);
            calendarStart.set(5, 1);
            Date startDate = calendarStart.getTime();
            Calendar calendarEnd = Calendar.getInstance();
            calendarEnd.set(1, iEndYear);
            calendarEnd.set(2, 11);
            calendarEnd.set(5, 31);
            Calendar calendarIter = Calendar.getInstance();
            for (int index = 2; index <= 54; ++index) {
                CtmCalendar ctmCal = new CtmCalendar(confCalsList[index], sDataCenter);
                ctmCal.setDescription(confCalsList[index]);
                calendarIter.setTime(startDate);
                while (calendarIter.compareTo(calendarEnd) < 0) {
                    for (int iDay = 1; iDay <= nWeekDays; ++iDay) {
                        int year = calendarIter.get(1);
                        int month = calendarIter.get(2) + 1;
                        int day = calendarIter.get(5);
                        if (year <= iEndYear) {
                            ctmCal.addDay(year, month, day);
                        }
                        calendarIter.add(5, 1);
                    }
                    calendarIter.add(5, nWeekDays * (index - 1));
                }
                defcal.write(ctmCal, false);
            }
        }
    }
}

