/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxHierarchyTree;
import com.bmc.ctmconvert.appworx.AppWorxSchedConvertor;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.appworx.Exp2Csv;
import com.bmc.ctmconvert.appworx.NodesTable;
import com.bmc.ctmconvert.appworx.NotificationsTable;
import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FileFunctions;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DataImportAppWorx
extends DataImportVendor {
    private BaseBrowseTextField expDefinitions;
    private BaseBrowseTextField nodesMapping;

    public DataImportAppWorx() {
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_TITLE_APPWORX")), new BaseFooterPanel(""));
        BaseSection section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA"));
        this.expDefinitions = new BaseBrowseTextField(new String[]{"EXP"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
        section.addField(new BaseField((BaseComponent)this.expDefinitions, TextManager.instance().get("DATA_IMPORT_FIELD_APPWORX_EXP_DEFINITIONS"), true, TextManager.instance().get("APPWORX_EXP_FILE_DESCRIPTION")));
        String strMapping = String.format(TextManager.instance().get("APPWORX_NODE_MAPPING_DESCRIPTION"), "\n", "\n", "\n", "\n", "\n");
        this.nodesMapping = new BaseBrowseTextField(new String[]{"TXT", "CFG"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY));
        section.addField(new BaseField((BaseComponent)this.nodesMapping, TextManager.instance().get("DATA_IMPORT_FIELD_APPWORX_NODES_MAPPING"), strMapping));
        this.importPanel.addSection(section);
        this.importPanel.buildContentPanel();
    }

    public BaseContentPanel getNextPanel() {
        return this.importPanel;
    }

    public Component getDefaultFocusedComponent() {
        return this.expDefinitions.getComponent();
    }

    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        return DataImportAppWorx.performDataImport(destinationFolderPath, this.expDefinitions.getText(), this.nodesMapping.getText(), progressBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, String expDefinitionsPath, String nodesMappingPath, BaseProgressBar progressBar) {
        boolean rc;
        File nodesFile;
        File expFile;
        DataImportAppWorx.cleanVendorData();
        if (progressBar != null) {
            progressBar.setLabel(TextManager.instance().get("DATA_IMPORT_PROGRESS_LABEL_EXP_COPYING"));
            progressBar.setProgressValue(3);
        }
        if (!(expFile = new File(expDefinitionsPath)).getName().isEmpty()) {
            File destExpFile = new File(destinationFolderPath + "AppWorxExpDefinitions.exp");
            try {
                FileFunctions.copyFile((File)expFile, (File)destExpFile);
            }
            catch (IOException e) {
                ProcessAlertsManager.instance().addMessage(String.format(TextManager.instance().get("DATA_IMPORT_COPY_FILE_ERROR_FORMAT"), expFile.toString(), destExpFile.toString()));
                FlowGlobals.COMPLETION_MODE cOMPLETION_MODE = FlowGlobals.COMPLETION_MODE.FAILURE;
                return cOMPLETION_MODE;
            }
            finally {
                destExpFile = null;
            }
        }
        if (progressBar != null) {
            progressBar.setLabel(TextManager.instance().get("DATA_IMPORT_PROGRESS_LABEL_NODES_MAPPING_COPYING"));
            progressBar.setProgressValue(6);
        }
        if (!(nodesFile = new File(nodesMappingPath)).getName().isEmpty()) {
            File destNodesFile = new File(destinationFolderPath + "AppWorxNodesMapping.txt");
            try {
                FileFunctions.copyFile((File)nodesFile, (File)destNodesFile);
            }
            catch (IOException e) {
                ProcessAlertsManager.instance().addMessage(String.format(TextManager.instance().get("DATA_IMPORT_COPY_FILE_ERROR_FORMAT"), nodesFile.toString(), destNodesFile.toString()));
                FlowGlobals.COMPLETION_MODE cOMPLETION_MODE = FlowGlobals.COMPLETION_MODE.FAILURE;
                return cOMPLETION_MODE;
            }
            finally {
                destNodesFile = null;
            }
        }
        try {
            Exp2Csv exp2Csv = new Exp2Csv(destinationFolderPath, progressBar);
            try {
                if (progressBar != null) {
                    progressBar.setLabel(TextManager.instance().get("DATA_IMPORT_PROGRESS_LABEL_EXP_PROCESSING"));
                    progressBar.setProgressValue(30);
                }
                rc = exp2Csv.convert2CSV();
            }
            catch (ConvertorCancelClickException e) {
                ExceptionHandler.writeToExceptionFile((Exception)((Object)e));
                return FlowGlobals.COMPLETION_MODE.ABORTED;
            }
        }
        catch (FileNotFoundException e1) {
            ExceptionHandler.writeToExceptionFile((Exception)e1);
            rc = false;
        }
        return rc ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
    }

    private static void cleanVendorData() {
        EntityTableManager.clear();
        AppWorxHierarchyTree.destroy();
        AppWorxSchedConvertor.destroy();
        NodesTable.destroy();
        NotificationsTable.destroy();
    }

    public String getHelpTitle() {
        return "LOAD_DATA_APPWORX";
    }

    public String getFieldsData() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.expDefinitions.getComponent().getName() + "=" + this.expDefinitions.getText() + "\n");
        return stringBuilder.toString();
    }
}

