/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxDefs;
import com.bmc.ctmconvert.appworx.AppWorxEntity;
import com.bmc.ctmconvert.appworx.AppWorxHierarchyTree;
import com.bmc.ctmconvert.appworx.AppWorxVariables;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.ctmutilities.event.ConditionCommandBuilder;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;

public class ConditionsGenerator {
    private static int uniqueNumber;
    private static AppWorxEntity successorEntity;
    private static final Pattern predecessorPattern;
    private static boolean jobAOK;
    private static boolean deleteCondition;
    private static final String STARTED = "Started";
    private static final String SUCCESS_SINCE_LAST_RUN = "S \"SLR\"";
    private static final String SUCCESS = "S";
    private static final String SUCCESS_ONLY_WHEN_FINISHED = "Success_only";
    private static final String SUCCESS_SKIP_ON_FAILURE = "S \"Skip on Failure\"";
    private static final String FAILURE = "Failure";
    private static final String FAILURE_SKIP_ON_SUCCESS = "Failure \"Skip on Success\"";
    private static final String COMPLETE = "Complete";
    private static final String STAT = "STAT";
    private static final String FINISHED = "FINISHED";

    public static void generateConditions() {
        uniqueNumber = 0;
        AppWorxHierarchyTree.destroy();
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        jobAOK = rules.getStringRule("AppWorx rules", new String[]{"CONDITION_NAME"}).equals("JOBA_OK");
        deleteCondition = false;
        if (!jobAOK) {
            deleteCondition = rules.getBooleanRule("AppWorx rules", new String[]{"CLEAN_UP_CONDITIONS"});
        }
        Enumeration<TreeNode> enumeration = AppWorxHierarchyTree.instance().getHierarchyTree().breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            IAttrHolder jobDetails;
            successorEntity = (AppWorxEntity)enumeration.nextElement();
            IAttrHolder chainDetails = successorEntity.getChainDetails();
            if (chainDetails != null) {
                ConditionsGenerator.generateConditions(chainDetails.getAttr("so_predecessors"));
            }
            if ((jobDetails = successorEntity.getJobDetails()) != null) {
                ConditionsGenerator.generateConditions(jobDetails.getAttr("so_predecessors"));
            }
            if (!successorEntity.hasAppworxToControlMConditions()) continue;
            ConditionsGenerator.generateConditions(successorEntity.getConditions());
        }
    }

    private static void generateConditions(AttrHolderList appworxCondition) {
        String so_performed;
        String so_performed2;
        IAttrHolder firstRow = (IAttrHolder)appworxCondition.get(0);
        if (null != firstRow && null != (so_performed2 = firstRow.getAttr("so_qualifier")) && so_performed2.equals("!=")) {
            Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11027", (String)successorEntity.getEntityID(), (String[])new String[]{firstRow.toString()});
            return;
        }
        RulesDataSet rules = RuleManager.instance().getCurrentRules();
        if (rules.getBooleanRule("AppWorx rules", new String[]{"IGNORE_PERFORMED_CONDITIONS"}).booleanValue() && null != firstRow && null != (so_performed = firstRow.getAttr("so_performed")) && so_performed.equalsIgnoreCase("Y")) {
            return;
        }
        for (IAttrHolder currentRow : appworxCondition) {
            ArrayList<AppWorxEntity> predecessorsList;
            String sTableName;
            String sCondition1 = currentRow.getAttr("so_condition_1").toUpperCase();
            String sCondition2 = currentRow.getAttr("so_condition_2");
            if (null != sCondition2) {
                sCondition2 = sCondition2.toUpperCase();
            }
            if (null == (sTableName = currentRow.getAttr("so_module"))) {
                sTableName = "EMPTY";
            }
            if (sCondition1.equals("CHECK HISTORY")) {
                if (null != sCondition2) {
                    String[] sCond2Values = sCondition2.split("\\s+");
                    if (sCond2Values.length == 3) {
                        AppWorxVariables appWorxVariables = new AppWorxVariables(sCond2Values[1]);
                        ConditionsGenerator.addVariableMessages(appWorxVariables, successorEntity);
                        String predecessorName = appWorxVariables.getAnnotatedText();
                        Properties addOK = new Properties();
                        Properties deleteNotOK = new Properties();
                        Properties addNotOK = new Properties();
                        Properties deleteOK = new Properties();
                        addOK.put("CODE", "OK");
                        addOK.put("STMT", "*");
                        addOK.put("ACTION", "DOCOND");
                        addOK.put("ODATE", STAT);
                        addOK.put("SIGN", "ADD");
                        deleteNotOK.put("CODE", "OK");
                        deleteNotOK.put("STMT", "*");
                        deleteNotOK.put("ACTION", "DOCOND");
                        deleteNotOK.put("ODATE", STAT);
                        deleteNotOK.put("SIGN", "DEL");
                        addNotOK.put("CODE", "NOTOK");
                        addNotOK.put("STMT", "*");
                        addNotOK.put("ACTION", "DOCOND");
                        addNotOK.put("ODATE", STAT);
                        addNotOK.put("SIGN", "ADD");
                        deleteOK.put("CODE", "NOTOK");
                        deleteOK.put("STMT", "*");
                        deleteOK.put("ACTION", "DOCOND");
                        deleteOK.put("ODATE", STAT);
                        deleteOK.put("SIGN", "DEL");
                        predecessorsList = ConditionsGenerator.getPredecessorsList((AppWorxEntity)successorEntity.getParent(), sCond2Values[1], false);
                        if (!predecessorsList.isEmpty()) {
                            String sCondNotOKName;
                            String sCondOKName;
                            for (AppWorxEntity predecessor : predecessorsList) {
                                appWorxVariables = new AppWorxVariables(predecessor.getEntityDisplayName());
                                ConditionsGenerator.addVariableMessages(appWorxVariables, predecessor);
                                String sName = appWorxVariables.getAnnotatedText();
                                sCondOKName = sTableName + "@" + sName + "@OK";
                                sCondNotOKName = sTableName + "@" + sName + "@NOTOK";
                                addOK.put("NAME", sCondOKName);
                                deleteNotOK.put("NAME", sCondNotOKName);
                                addNotOK.put("NAME", sCondNotOKName);
                                deleteOK.put("NAME", sCondOKName);
                                predecessor.addOnStatement(addOK);
                                predecessor.addOnStatement(deleteNotOK);
                                predecessor.addOnStatement(addNotOK);
                                predecessor.addOnStatement(deleteOK);
                            }
                            sCondOKName = sTableName + "@" + predecessorName + "@OK";
                            sCondNotOKName = sTableName + "@" + predecessorName + "@NOTOK";
                            Properties inCond = new Properties();
                            if (sCond2Values[0].equalsIgnoreCase(FINISHED)) {
                                inCond.put("NAME", sCondOKName);
                            } else {
                                inCond.put("NAME", sCondNotOKName);
                            }
                            inCond.put("AND_OR", "AND");
                            inCond.put("ODATE", STAT);
                            successorEntity.addInCondition(inCond);
                            Reporter.addMessage(successorEntity.getMessages(), (String)"INF11001", (String)successorEntity.getEntityID(), (String[])new String[]{inCond.get("NAME").toString(), appworxCondition.toString()});
                            continue;
                        }
                        Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11013", (String)successorEntity.getEntityID(), (String[])new String[]{predecessorName, currentRow.toString()});
                        continue;
                    }
                    Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11009", (String)successorEntity.getEntityID(), (String[])new String[]{currentRow.toString()});
                    continue;
                }
                Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11009", (String)successorEntity.getEntityID(), (String[])new String[]{currentRow.toString()});
                continue;
            }
            if (sCondition1.equals("JOB REQUESTED")) {
                String sCurrentJobName = currentRow.getAttr("so_task_name");
                if (null != sCurrentJobName && null != sCondition2) {
                    String module = currentRow.getAttr("so_module");
                    String sPredecessorNameRegex = sCondition2.replaceAll("\\{#\\S+?\\}", "\\\\{#\\\\S+?\\\\}");
                    if (sCurrentJobName.matches(sPredecessorNameRegex)) {
                        String conditionNameFormat = "%s@%s";
                        AppWorxVariables appWorxVariables = new AppWorxVariables(sCondition2);
                        ConditionsGenerator.addVariableMessages(appWorxVariables, successorEntity);
                        String inCondName = String.format(conditionNameFormat, module, appWorxVariables.getAnnotatedText());
                        Properties inCond = new Properties();
                        inCond.put("NAME", inCondName);
                        inCond.put("AND_OR", "AND");
                        inCond.put("ODATE", STAT);
                        successorEntity.addInCondition(inCond);
                        Properties outCond = new Properties();
                        outCond.setProperty("NAME", inCondName);
                        outCond.setProperty("SIGN", "DEL");
                        outCond.setProperty("ODATE", STAT);
                        successorEntity.addOutCondition(outCond);
                        appWorxVariables = new AppWorxVariables(sCurrentJobName);
                        ConditionsGenerator.addVariableMessages(appWorxVariables, successorEntity);
                        String outCondName = String.format(conditionNameFormat, module, appWorxVariables.getAnnotatedText());
                        Properties onStatement = new Properties();
                        onStatement.setProperty("STMT", "*");
                        onStatement.setProperty("CODE", "*");
                        onStatement.setProperty("ACTION", "DOCOND");
                        onStatement.setProperty("NAME", outCondName);
                        onStatement.setProperty("ODATE", STAT);
                        onStatement.setProperty("SIGN", "ADD");
                        successorEntity.addOnStatement(onStatement);
                        Reporter.addMessage(successorEntity.getMessages(), (String)"INF11001", (String)successorEntity.getEntityID(), (String[])new String[]{inCondName, appworxCondition.toString()});
                        continue;
                    }
                    Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11013", (String)successorEntity.getEntityID(), (String[])new String[]{sCondition2, currentRow.toString()});
                    continue;
                }
                Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11009", (String)successorEntity.getEntityID(), (String[])new String[]{currentRow.toString()});
                continue;
            }
            if (null != sCondition2) {
                predecessorsList = ConditionsGenerator.getPredecessorsList((AppWorxEntity)successorEntity.getParent(), sCondition2, false);
                if (!predecessorsList.isEmpty()) {
                    for (AppWorxEntity pred : predecessorsList) {
                        boolean bIsJob;
                        boolean bl = bIsJob = !pred.getJobDetails().getAttr("so_command_type").equals("CHAIN");
                        if (bIsJob) {
                            AppWorxVariables appWorxVariables = new AppWorxVariables(sCondition2);
                            ConditionsGenerator.addVariableMessages(appWorxVariables, successorEntity);
                            ConditionsGenerator.addVariableMessages(appWorxVariables, pred);
                            String sConditionName = sTableName + "_" + appWorxVariables.getAnnotatedText();
                            String sCMD = new ConditionCommandBuilder().setAddAction().setConditionName(sConditionName).build().toCommand();
                            Properties deleteOutcond = new Properties();
                            deleteOutcond.put("CODE", "*");
                            deleteOutcond.put("STMT", "*");
                            deleteOutcond.put("ACTION", "DOCOND");
                            deleteOutcond.put("NAME", sConditionName);
                            deleteOutcond.put("ODATE", STAT);
                            deleteOutcond.put("SIGN", "DEL");
                            pred.addOutCondition(deleteOutcond);
                            LinkedHashMap<String, String> autoEdits = pred.getAutoedits();
                            if (null != autoEdits) {
                                if (!autoEdits.containsKey("%%PRECMD")) {
                                    autoEdits.put("%%PRECMD", sCMD);
                                } else {
                                    Object sValue = autoEdits.get("%%PRECMD");
                                    sValue = sCMD + "&;" + (String)sValue;
                                    autoEdits.put("%%PRECMD", (String)sValue);
                                }
                            }
                            Properties incond = new Properties();
                            incond.put("NAME", sConditionName);
                            incond.put("AND_OR", "AND");
                            incond.put("ODATE", STAT);
                            successorEntity.addInCondition(incond);
                            Reporter.addMessage(successorEntity.getMessages(), (String)"INF11001", (String)successorEntity.getEntityID(), (String[])new String[]{sConditionName, appworxCondition.toString()});
                            continue;
                        }
                        Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11014", (String)successorEntity.getEntityID(), (String[])new String[]{currentRow.toString()});
                    }
                    continue;
                }
                Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11013", (String)successorEntity.getEntityID(), (String[])new String[]{sCondition2, currentRow.toString()});
                continue;
            }
            Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11009", (String)successorEntity.getEntityID(), (String[])new String[]{currentRow.toString()});
        }
    }

    private static void addVariableMessages(AppWorxVariables appWorxVariables, AppWorxEntity entity) {
        for (Properties properties : appWorxVariables.getMessages()) {
            Reporter.addMessage(entity.getMessages(), (String)properties.getProperty("MSGID"), (String)entity.getEntityID(), (String[])((String[])properties.get("RESVAR")));
        }
        AppWorxDefs.addActionsToReporter(entity.getMessages(), appWorxVariables.getActions(), entity.getEntityID());
    }

    private static void generateConditions(String predecessors) {
        if (predecessors != null && !predecessors.isEmpty()) {
            boolean inParenthesis = false;
            boolean andOr = true;
            Matcher matcher = predecessorPattern.matcher(predecessors);
            block28: while (matcher.find()) {
                String match = matcher.group(1);
                boolean local = matcher.group(3) != null && !matcher.group(3).isEmpty();
                String predecessor = matcher.group(4);
                String type = matcher.group(5);
                String conditionOperator = "";
                switch (match) {
                    case "(": {
                        if (inParenthesis) {
                            Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11001", (String)successorEntity.getEntityID(), (String[])new String[]{predecessors});
                        }
                        inParenthesis = true;
                        continue block28;
                    }
                    case ")": {
                        if (!inParenthesis) {
                            Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11002", (String)successorEntity.getEntityID(), (String[])new String[]{predecessors});
                        }
                        inParenthesis = false;
                        continue block28;
                    }
                    case "AND": {
                        andOr = true;
                        continue block28;
                    }
                    case "OR": {
                        andOr = false;
                        continue block28;
                    }
                }
                String conditionDate = "ODAT";
                Object conditionName = predecessor;
                if (!jobAOK || type.equals(SUCCESS_SINCE_LAST_RUN)) {
                    conditionName = "CID" + ++uniqueNumber + "@" + predecessor + "@" + successorEntity.getEntityDisplayName();
                }
                AppWorxEntity root = local ? (AppWorxEntity)successorEntity.getParent() : (AppWorxEntity)AppWorxHierarchyTree.instance().getHierarchyTree();
                ArrayList<AppWorxEntity> predecessorsList = ConditionsGenerator.getPredecessorsList(root, new ArrayList<String>(Arrays.asList(predecessor.split("/"))), local);
                switch (type) {
                    case "Started": {
                        if (jobAOK) {
                            conditionName = (String)conditionName + "@Started";
                        }
                        for (AppWorxEntity appWorxEntity : predecessorsList) {
                            String preCommand = new ConditionCommandBuilder().setAddAction().setConditionName((String)conditionName).setOrderDate(conditionDate).build().toCommand();
                            appWorxEntity.addAutoedit("%%PRECMD", preCommand);
                        }
                        break;
                    }
                    case "S \"SLR\"": 
                    case "S": 
                    case "Success_only": 
                    case "S \"Skip on Failure\"": {
                        if (jobAOK) {
                            conditionName = (String)conditionName + "@OK";
                        }
                        Properties outcond = new Properties();
                        outcond.setProperty("NAME", (String)conditionName);
                        outcond.setProperty("SIGN", "ADD");
                        outcond.setProperty("ODATE", conditionDate);
                        for (AppWorxEntity predecessorEntity : predecessorsList) {
                            predecessorEntity.addOutCondition(outcond);
                        }
                        if (type.equals(SUCCESS_SINCE_LAST_RUN)) {
                            conditionDate = "****";
                        }
                        if (type.equals(SUCCESS_ONLY_WHEN_FINISHED)) break;
                        Reporter.addMessage(successorEntity.getMessages(), (String)"INF11003", (String)successorEntity.getEntityID(), (String[])new String[]{predecessor, type});
                        break;
                    }
                    case "Failure": 
                    case "Failure \"Skip on Success\"": {
                        if (jobAOK) {
                            conditionName = (String)conditionName + "@NOTOK";
                        }
                        Properties onStatement = new Properties();
                        onStatement.setProperty("STMT", "*");
                        onStatement.setProperty("CODE", "NOTOK");
                        onStatement.setProperty("ACTION", "DOCOND");
                        onStatement.setProperty("NAME", (String)conditionName);
                        onStatement.setProperty("ODATE", conditionDate);
                        onStatement.setProperty("SIGN", "ADD");
                        for (AppWorxEntity predecessorEntity : predecessorsList) {
                            predecessorEntity.addOnStatement(onStatement);
                        }
                        if (!type.equals(FAILURE_SKIP_ON_SUCCESS)) break;
                        Reporter.addMessage(successorEntity.getMessages(), (String)"INF11003", (String)successorEntity.getEntityID(), (String[])new String[]{predecessor, type});
                        break;
                    }
                    case "Complete": {
                        if (jobAOK) {
                            conditionName = (String)conditionName + "@Complete";
                        }
                        Properties outcond = new Properties();
                        outcond.setProperty("NAME", (String)conditionName);
                        outcond.setProperty("SIGN", "ADD");
                        outcond.setProperty("ODATE", conditionDate);
                        Properties properties = new Properties();
                        properties.setProperty("STMT", "*");
                        properties.setProperty("CODE", "NOTOK");
                        properties.setProperty("ACTION", "DOCOND");
                        properties.setProperty("NAME", (String)conditionName);
                        properties.setProperty("ODATE", conditionDate);
                        properties.setProperty("SIGN", "ADD");
                        for (AppWorxEntity predecessorEntity : predecessorsList) {
                            predecessorEntity.addOutCondition(outcond);
                            predecessorEntity.addOnStatement(properties);
                        }
                        break;
                    }
                }
                Properties incond = new Properties();
                incond.setProperty("NAME", (String)conditionName);
                incond.setProperty("AND_OR", andOr ? "AND" : "OR");
                incond.setProperty("OP", conditionOperator);
                incond.setProperty("ODATE", conditionDate);
                successorEntity.addInCondition(incond);
                if (!deleteCondition && !type.equals(SUCCESS_SINCE_LAST_RUN)) continue;
                Properties deletecond = new Properties();
                deletecond.setProperty("NAME", (String)conditionName);
                deletecond.setProperty("SIGN", "DEL");
                deletecond.setProperty("ODATE", conditionDate);
                successorEntity.addOutCondition(deletecond);
            }
            if (inParenthesis) {
                Reporter.addMessage(successorEntity.getMessages(), (String)"WRN11002", (String)successorEntity.getEntityID(), (String[])new String[]{predecessors});
            }
        }
    }

    private static ArrayList<AppWorxEntity> getPredecessorsList(AppWorxEntity parent, String predecessorName) {
        return ConditionsGenerator.getPredecessorsList(parent, predecessorName, true);
    }

    private static ArrayList<AppWorxEntity> getPredecessorsList(AppWorxEntity parent, String predecessorName, boolean ignorVariables) {
        ArrayList<AppWorxEntity> predecessorsList = new ArrayList<AppWorxEntity>();
        if (parent != null) {
            String name = predecessorName;
            if (!ignorVariables) {
                name = predecessorName.replaceAll("\\{#\\S+?\\}", "\\\\{#\\\\S+?\\\\}");
            }
            Enumeration<TreeNode> enumeration = parent.children();
            while (enumeration.hasMoreElements()) {
                AppWorxEntity currEntity = (AppWorxEntity)enumeration.nextElement();
                if ((!ignorVariables || !currEntity.getEntityDisplayName().equals(name)) && (ignorVariables || !currEntity.getEntityDisplayName().matches(name))) continue;
                predecessorsList.add(currEntity);
            }
        }
        return predecessorsList;
    }

    private static ArrayList<AppWorxEntity> getPredecessorsList(AppWorxEntity root, ArrayList<String> predecessorNameArr, boolean local) {
        ArrayList<AppWorxEntity> predecessorsList = new ArrayList<AppWorxEntity>();
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            AppWorxEntity currEntity = (AppWorxEntity)enumeration.nextElement();
            if (currEntity.getEntityDisplayName().equals(predecessorNameArr.get(0))) {
                if (predecessorNameArr.size() == 1) {
                    predecessorsList.addAll(ConditionsGenerator.getPredecessorsList((AppWorxEntity)currEntity.getParent(), predecessorNameArr.get(0)));
                    continue;
                }
                predecessorsList.addAll(ConditionsGenerator.getPredecessorsList(currEntity, new ArrayList<String>(predecessorNameArr.subList(1, predecessorNameArr.size())), local));
                continue;
            }
            if (local) continue;
            predecessorsList.addAll(ConditionsGenerator.getPredecessorsList(currEntity, predecessorNameArr, local));
        }
        return predecessorsList;
    }

    static {
        predecessorPattern = Pattern.compile("(\\(|((&/)?(\\S+)\\s*=\\s*(\\S+(\\s+\".*?\")?)\\s*)|AND|OR|\\))");
    }
}

