/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxDefs;
import com.bmc.ctmconvert.appworx.AppWorxEntity;
import com.bmc.ctmconvert.appworx.AppWorxJob;
import com.bmc.ctmconvert.appworx.AppWorxVariables;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AppWorxVariablesHandler {
    private AppWorxEntity entityData;
    private Map<String, String> variables;
    private String originalProductId;
    private AppWorxJob job;
    private boolean isScript;

    public AppWorxVariablesHandler(AppWorxEntity entityData, Map<String, String> variables, String originalProductId, boolean isScriptJob, AppWorxJob job) {
        this.entityData = entityData;
        this.variables = variables;
        this.originalProductId = originalProductId;
        this.job = job;
        this.isScript = isScriptJob;
    }

    public Map<String, String> getVariables() {
        AttrHolderList jobPrompts = this.entityData.getJobPrompts();
        String[] argsArray = new String[jobPrompts.size() + 1];
        String[] argsNames = new String[jobPrompts.size() + 1];
        for (IAttrHolder arg : jobPrompts) {
            argsArray[Integer.parseInt((String)arg.getAttr((String)"so_prompt"))] = arg.getAttr("so_prompt_dflt");
            argsNames[Integer.parseInt((String)arg.getAttr((String)"so_prompt"))] = arg.getAttr("so_prompt_descr");
        }
        if (!this.job.getParentName().equals("EntitesWithoutProcessFlows")) {
            this.overwriteJobValuesWithTheChainValues(argsArray);
        }
        if (this.isScript) {
            this.handleScriptVariables(argsArray);
        } else {
            this.handleVariables(argsArray, argsNames);
        }
        for (Map.Entry<String, String> variable : this.variables.entrySet()) {
            AppWorxVariables appWorxVariables = new AppWorxVariables(variable.getValue());
            for (Properties properties : appWorxVariables.getMessages()) {
                this.job.addMessage(properties.getProperty("MSGID"), (String[])properties.get("RESVAR"));
            }
            AppWorxDefs.addActionsToReporter(this.job.getMessages(), appWorxVariables.getActions(), this.originalProductId);
            variable.setValue(appWorxVariables.getAnnotatedText());
        }
        return this.variables;
    }

    public static String validateVariableName(String variableName) {
        return FieldValidation.instance().validateAndReturnFixedValue("VARIABLE_NAME", variableName);
    }

    private void overwriteJobValuesWithTheChainValues(String[] argsArray) {
        this.entityData.getChainArgs().stream().filter(arg -> Integer.parseInt(arg.getAttr("so_det_arg_no")) < argsArray.length).forEach(arg -> {
            String varNameInChain;
            int argsIndex = Integer.parseInt(arg.getAttr("so_det_arg_no"));
            argsArray[argsIndex] = varNameInChain = this.getVarNameFromChain(arg.getAttr("so_det_arg"));
        });
    }

    private String getVarNameFromChain(String chainprompt) {
        Pattern variablePaterren = Pattern.compile("#(\\d+)");
        Pattern variablePaterren2 = Pattern.compile("\\{#(\\d+)}");
        Matcher matcher = variablePaterren.matcher(chainprompt);
        Matcher matcher2 = variablePaterren2.matcher(chainprompt);
        String[] chainprompts = this.entityData.getParentChainPrompts();
        if (chainprompts.length > 0) {
            chainprompt = this.runOverTheMatchesAndReplace(chainprompt, matcher2, chainprompts);
            chainprompt = this.runOverTheMatchesAndReplace(chainprompt, matcher, chainprompts);
        }
        return chainprompt;
    }

    private String runOverTheMatchesAndReplace(String chainprompt, Matcher matcher, String[] chainprompts) {
        while (matcher.find()) {
            int varNamuber;
            if (matcher.group(1) == null || (varNamuber = Integer.parseInt(matcher.group(1))) <= 0 || varNamuber >= chainprompts.length) continue;
            String varName = AppWorxVariablesHandler.validateVariableName(chainprompts[varNamuber]);
            chainprompt = chainprompt.replace(matcher.group(0), "%%" + varName + ".");
        }
        return chainprompt;
    }

    private void handleVariables(String[] argsArray, String[] variableNames) {
        for (int i = 1; i < argsArray.length; ++i) {
            this.variables.put(GlobalFunctions.addMissingVariablePrefix((String)AppWorxVariablesHandler.validateVariableName(variableNames[i])), argsArray[i]);
        }
    }

    private void handleScriptVariables(String[] argsArray) {
        this.variables.put(String.format("%%%%PARM%d", 1), this.getParm1Value());
        for (int i = 1; i < argsArray.length; ++i) {
            this.variables.put(String.format("%%%%PARM%d", i + 1), argsArray[i]);
        }
    }

    private String getParm1Value() {
        String libraryPath = this.getLibratyPathAccordingToNodePlatform();
        String programName = this.entityData.getJobDetails().getAttr("so_program");
        return libraryPath + "/" + programName;
    }

    private String getLibratyPathAccordingToNodePlatform() {
        String retVal = "";
        String nodePlatform = this.job.getNodePlatform();
        IAttrHolder library = this.entityData.getLibrary();
        if (library != null) {
            if (nodePlatform.equals("Unix")) {
                retVal = library.getAttr("so_library_path_unix");
            } else if (nodePlatform.equals("Windows")) {
                retVal = library.getAttr("so_library_path_nt");
            }
        }
        return retVal;
    }
}

