/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxDefs;
import com.bmc.ctmconvert.appworx.AppWorxJob;
import com.bmc.ctmconvert.appworx.AppWorxVariables;
import com.bmc.ctmconvert.appworx.CsvFileTable;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AppWorxSchedConvertor {
    private static AppWorxSchedConvertor instance = null;
    private final LinkedHashMap<String, LinkedHashSet<AssistingJob>> name2AssistingJobs;
    private final LinkedHashMap<String, LinkedHashSet<Properties>> name2Rbcs;
    private final Map<String, List<Map<String, String[]>>> sched2messages;
    private final Map<String, String> warningIdMessageString = new HashMap<String, String>();
    private final HashMap<String, String> negativeCalendarNameToLastYear = new HashMap();
    private final RulesDataSet rules;
    private UniqueValueGenerator uniqueValueGenerator = new UniqueValueGenerator();

    private AppWorxSchedConvertor() {
        this.name2AssistingJobs = new LinkedHashMap();
        this.name2Rbcs = new LinkedHashMap();
        this.sched2messages = new LinkedHashMap<String, List<Map<String, String[]>>>();
        this.rules = RuleManager.instance().getCurrentRules();
        this.createCalendars();
    }

    public List<Map<String, String[]>> getMessages(AppWorxJob job) {
        ArrayList<Map<String, String[]>> toRet = new ArrayList<Map<String, String[]>>();
        AttrHolderList schedList = job.getEntityData().getSched();
        if (null != schedList && !schedList.isEmpty()) {
            for (IAttrHolder schedAttrs : schedList) {
                if (!this.sched2messages.containsKey(this.createSchedId(schedAttrs))) continue;
                toRet.addAll((Collection<Map<String, String[]>>)this.sched2messages.remove(this.createSchedId(schedAttrs)));
            }
        } else if (job.type().equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
            LinkedHashMap<String, String[]> toRetFirst = new LinkedHashMap<String, String[]>(1);
            toRetFirst.put("INF11004", new String[]{""});
            toRet.add(toRetFirst);
        }
        return toRet;
    }

    private String createSchedId(IAttrHolder schedAtrs) {
        return String.format("%s-:-%s", schedAtrs.getAttr("so_module"), schedAtrs.getAttr("aw_sch_name"));
    }

    private void createCalendars() {
        CsvFileTable calTable = EntityTableManager.get(EntityTableManager.EntityType.so_holiday_grps);
        AttrHolderList calendars = calTable.getAttrHoldersList();
        try (DefCalFile defCal = DefCalFile.createDefCalFile();){
            for (IAttrHolder calendar : calendars) {
                String calendarName = calendar.getAttr("so_holiday_name");
                CtmCalendar ctmCal = new CtmCalendar(calendarName, Params.instance().getDatacenterName());
                ctmCal.setDescription(calendar.getAttr("so_holid_desc"));
                String nextDate = calendar.getAttr("so_holiday");
                int dayIndex = 0;
                int maxYear = 0;
                while (nextDate != null && !nextDate.isEmpty() && nextDate.matches("\\d{8}")) {
                    int month = Integer.parseInt(nextDate.substring(0, 2));
                    int day = Integer.parseInt(nextDate.substring(2, 4));
                    int year = Integer.parseInt(nextDate.substring(4));
                    maxYear = Math.max(maxYear, year);
                    ctmCal.addDay(year, month, day);
                    if (calendar.isFieldExist(String.format("so_holiday_%d", ++dayIndex))) {
                        nextDate = calendar.getAttr(String.format("so_holiday_%d", dayIndex));
                        continue;
                    }
                    nextDate = null;
                }
                defCal.write(ctmCal, false);
                defCal.write(ctmCal, true);
                this.negativeCalendarNameToLastYear.put(this.getValidNegativeCalendarName(calendarName), Integer.toString(maxYear));
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public static AppWorxSchedConvertor instance() {
        if (instance == null) {
            instance = new AppWorxSchedConvertor();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public Set<Properties> getRBCs(AppWorxJob job) {
        String entName = job.getParentName() + job.getEntityData().getEntityDisplayName();
        if (!this.name2Rbcs.containsKey(entName)) {
            AttrHolderList schedList = job.getEntityData().getSched();
            this.name2Rbcs.put(entName, new LinkedHashSet());
            if (!schedList.isEmpty()) {
                for (IAttrHolder sched : schedList) {
                    Properties tmpRbc = this.convertAttrs2Rbc(sched);
                    if (tmpRbc == null) continue;
                    this.name2Rbcs.get(entName).add(tmpRbc);
                }
            }
            if (this.name2Rbcs.get(entName).isEmpty()) {
                this.name2Rbcs.get(entName).add(this.createDefaultRbc(job));
            }
        }
        return this.name2Rbcs.get(entName);
    }

    private Properties createDefaultRbc(AppWorxJob job) {
        Properties toRet = new Properties();
        if (job.type().equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
            toRet.setProperty("NAME", "EMPTY_RBC");
        } else {
            toRet.setProperty("NAME", "*");
        }
        return toRet;
    }

    private Properties convertAttrs2Rbc(IAttrHolder schedAttrs) {
        Properties toRet = null;
        if (this.isActiveSched(schedAttrs)) {
            String[] months;
            toRet = new Properties();
            String rbcUnit = schedAttrs.getAttr("so_sch_grp");
            String calendarName = schedAttrs.getAttr("aw_sch_name") + ":" + schedAttrs.getAttr("so_module");
            String uniqueCalendarName = this.uniqueValueGenerator.getUniqueValue("TAG_NAME", calendarName, 19);
            String validatedCalendarName = FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", uniqueCalendarName);
            toRet.setProperty("NAME", validatedCalendarName);
            this.setActivityPeriod(schedAttrs, toRet);
            for (String month : months = GlobalFunctions.getMonthsArray()) {
                toRet.setProperty(month, "1");
            }
            if (rbcUnit.equals("DAYS")) {
                this.convertDays(schedAttrs, toRet);
            } else if (rbcUnit.equals("WEEKS")) {
                this.convertWeeks(schedAttrs, toRet);
            } else if (rbcUnit.equals("MONTHS")) {
                this.convertMonths(schedAttrs, toRet);
            } else if (rbcUnit.equals("FISCAL") || rbcUnit.equals("WORKDAYS")) {
                String mapKey = this.createSchedId(schedAttrs);
                this.sched2messages.putIfAbsent(mapKey, new ArrayList());
                LinkedHashMap<String, String[]> msg = new LinkedHashMap<String, String[]>();
                String[] msgArgs = new String[]{schedAttrs.getAttr("aw_sch_name"), schedAttrs.getAttr("so_module"), rbcUnit};
                msg.put("WRN11017", msgArgs);
                this.sched2messages.get(mapKey).add(msg);
            } else if (!rbcUnit.equals("MINUTES") && !rbcUnit.equals("HOURS")) {
                toRet.setProperty("DAYSCAL", FieldValidation.instance().validateAndReturnFixedValue("DAYSCAL", rbcUnit));
            }
            if (!toRet.containsKey("WEEKDAYS")) {
                toRet.setProperty("WEEKDAYS", this.weekdays2ctm(schedAttrs.getAttr("aw_days_of_week")));
            }
            if ((toRet.containsKey("WEEKDAYS") || toRet.containsKey("WEEKSCAL")) && (toRet.containsKey("DAYS") || toRet.containsKey("DAYSCAL"))) {
                toRet.setProperty("DAYS_AND_OR", "AND");
            }
            toRet.setProperty("MAXWAIT", this.rules.getStringRule("AppWorx rules", new String[]{"MAXWAIT"}));
            this.setConfcal(toRet, schedAttrs);
        }
        return toRet;
    }

    private void setConfcal(Properties rbc, IAttrHolder schedAttrs) {
        String holidayCal = schedAttrs.getAttr("so_holiday_name");
        if (holidayCal != null && !holidayCal.isEmpty()) {
            String exceptMethod;
            String calendarName = this.getValidNegativeCalendarName(holidayCal);
            rbc.setProperty("CONFCAL", calendarName);
            String mapKey = this.createSchedId(schedAttrs);
            this.sched2messages.putIfAbsent(mapKey, new ArrayList());
            LinkedHashMap<String, Object> msg = new LinkedHashMap<String, String[]>();
            String[] messageArgs = new String[]{calendarName, this.negativeCalendarNameToLastYear.get(calendarName), schedAttrs.getAttr("so_module")};
            this.createWarningMessages(msg, "WRN11028", messageArgs, mapKey);
            switch (exceptMethod = schedAttrs.getAttr("aw_except_method")) {
                case "ND": {
                    rbc.setProperty("SHIFT", "NEXTDAY");
                    break;
                }
                case "N": {
                    rbc.setProperty("SHIFTNUM", "1");
                    break;
                }
                case "S": {
                    break;
                }
                default: {
                    mapKey = this.createSchedId(schedAttrs);
                    this.sched2messages.putIfAbsent(mapKey, new ArrayList());
                    msg = new LinkedHashMap();
                    String[] msgArgs = new String[]{schedAttrs.getAttr("aw_sch_name"), exceptMethod};
                    this.createWarningMessages(msg, "WRN11019", msgArgs, mapKey);
                }
            }
        }
    }

    private String getValidNegativeCalendarName(String name) {
        String name2Use = "not-" + name;
        return FieldValidation.instance().validateAndReturnFixedValue("DAYSCAL", name2Use);
    }

    private void setActivityPeriod(IAttrHolder schedAttrs, Properties toRet) {
        String[] dateArr;
        String endDate = schedAttrs.getAttr("aw_sch_end");
        String startDate = schedAttrs.getAttr("aw_sch_start");
        if (schedAttrs.getAttr("aw_active").equalsIgnoreCase("N")) {
            startDate = "";
            endDate = "10-26-1985";
        }
        if (endDate.matches("^\\d{1,2}-\\d{1,2}-\\d{4}$")) {
            dateArr = endDate.split("-");
            toRet.setProperty("ACTIVE_TILL", String.format("%s%s%s", dateArr[2], dateArr[0], dateArr[1]));
        }
        if (startDate.matches("^\\d{1,2}-\\d{1,2}-\\d{4}$")) {
            dateArr = startDate.split("-");
            toRet.setProperty("ACTIVE_FROM", String.format("%s%s%s", dateArr[2], dateArr[0], dateArr[1]));
        }
    }

    private boolean isActiveSched(IAttrHolder schedAttrs) {
        return !schedAttrs.getAttr("aw_active").equalsIgnoreCase("N") || !this.isPastMmDdYyyy(schedAttrs.getAttr("aw_sch_end"));
    }

    private boolean isPastMmDdYyyy(String date) {
        boolean toRet = false;
        if (date.matches("^\\d{1,2}-\\d{1,2}-\\d{4}&")) {
            String[] dateArr = date.split("-");
            int day = Integer.parseInt(dateArr[1]);
            int month = Integer.parseInt(dateArr[0]);
            GregorianCalendar today = new GregorianCalendar();
            int year = Integer.parseInt(dateArr[2]);
            toRet = today.compareTo(new GregorianCalendar(year, month - 1, day)) > 0;
        }
        return toRet;
    }

    private void convertMonths(IAttrHolder schedAttrs, Properties rbc) {
        boolean isLastOfMonth;
        int interval = schedAttrs.getAttrAsInt("aw_sch_interval");
        String[] fromDate = this.getDateCalcBase(schedAttrs).split("-");
        int month = Integer.parseInt(fromDate[0]);
        int day = Integer.parseInt(fromDate[1]);
        int year = Integer.parseInt(fromDate[2]);
        GregorianCalendar tmpCal = new GregorianCalendar(year, month - 1, day);
        int tmpMonth = tmpCal.get(2);
        tmpCal.add(5, 1);
        boolean bl = isLastOfMonth = tmpCal.get(2) != tmpMonth;
        if (12 % interval == 0) {
            String[] months;
            for (String mon : months = GlobalFunctions.getMonthsArray()) {
                rbc.setProperty(mon, "0");
            }
            int monthIndex = month - 1;
            do {
                rbc.setProperty(months[monthIndex % 12], "1");
            } while ((monthIndex += interval) % 12 != month - 1);
        } else {
            String mapKey = this.createSchedId(schedAttrs);
            this.sched2messages.putIfAbsent(mapKey, new ArrayList());
            LinkedHashMap<String, String[]> msg = new LinkedHashMap<String, String[]>();
            String[] msgArgs = new String[]{Integer.toString(interval), "MONTHS", schedAttrs.getAttr("aw_sch_name"), "0"};
            this.createWarningMessages(msg, "WRN11018", msgArgs, mapKey);
        }
        if (isLastOfMonth) {
            rbc.setProperty("DAYS", "L1");
        } else {
            rbc.setProperty("DAYS", Integer.toString(day));
        }
    }

    private void createWarningMessages(Map<String, String[]> message, String messageId, String[] messageArguments, String schedId) {
        message.put(messageId, messageArguments);
        if (null == this.warningIdMessageString.get(messageId) || !this.warningIdMessageString.get(messageId).equals(Arrays.deepToString(messageArguments))) {
            this.sched2messages.get(schedId).add(message);
            this.warningIdMessageString.put(messageId, Arrays.deepToString(messageArguments));
        }
    }

    private String weekdays2ctm(String appWrxWDays) {
        StringBuilder toRet = new StringBuilder();
        if (appWrxWDays.equals("YYYYYYY")) {
            toRet = new StringBuilder("ALL");
        } else {
            String ctmStartDay = this.getCtmStartDay();
            String[] ctmWeekDaysArr = GlobalFunctions.getWeekDaysArray((String)ctmStartDay);
            String[] appWorxeekDaysArr = GlobalFunctions.getWeekDaysArray((String)"MON");
            for (int i = 0; i < appWrxWDays.length(); ++i) {
                if (appWrxWDays.toUpperCase().charAt(i) != 'Y') continue;
                Integer dayIndex = GlobalFunctions.getDayOfTheWeekCtmIndex((String[])ctmWeekDaysArr, (String)appWorxeekDaysArr[i]);
                toRet.append(dayIndex.toString()).append(",");
            }
        }
        return toRet.toString().replaceAll(",$", "");
    }

    private String getCtmStartDay() {
        return this.rules.getStringRule("AppWorx rules", new String[]{"FIRST_DAY_OF_WEEK"}).substring(0, 3).toUpperCase();
    }

    private void convertDays(IAttrHolder schedAttrs, Properties rbc) {
        int interval = schedAttrs.getAttrAsInt("aw_sch_interval");
        if (interval == 1) {
            rbc.setProperty("DAYS", "ALL");
        } else {
            String mapKey = this.createSchedId(schedAttrs);
            this.sched2messages.putIfAbsent(mapKey, new ArrayList());
            LinkedHashMap<String, String[]> msg = new LinkedHashMap<String, String[]>();
            String[] msgArgs = new String[]{Integer.toString(interval), "DAYS", schedAttrs.getAttr("aw_sch_name"), "1"};
            this.createWarningMessages(msg, "WRN11018", msgArgs, mapKey);
        }
    }

    private String mmddyyyy2weekDay(String date) {
        String[] dateArr = date.split("-");
        String toRet = null;
        if (dateArr.length == 3 && date.matches("[0-9-]+")) {
            int month = Integer.parseInt(dateArr[0]);
            int day = Integer.parseInt(dateArr[1]);
            int year = Integer.parseInt(dateArr[2]);
            GregorianCalendar tmpCal = new GregorianCalendar(year, month - 1, day);
            toRet = tmpCal.getDisplayName(7, 1, Locale.ROOT).toUpperCase();
        }
        return toRet;
    }

    private void convertWeeks(IAttrHolder schedAttrs, Properties rbc) {
        int interval = schedAttrs.getAttrAsInt("aw_sch_interval");
        if (interval == 1) {
            Integer weekDay = GlobalFunctions.getDayOfTheWeekCtmIndex((String[])GlobalFunctions.getWeekDaysArray((String)this.getCtmStartDay()), (String)this.mmddyyyy2weekDay(this.getDateCalcBase(schedAttrs)));
            rbc.setProperty("WEEKDAYS", weekDay.toString());
        } else {
            String mapKey = this.createSchedId(schedAttrs);
            this.sched2messages.putIfAbsent(mapKey, new ArrayList());
            LinkedHashMap<String, String[]> msg = new LinkedHashMap<String, String[]>();
            String[] msgArgs = new String[]{Integer.toString(interval), "WEEKS", schedAttrs.getAttr("aw_sch_name"), "1"};
            this.createWarningMessages(msg, "WRN11018", msgArgs, mapKey);
        }
    }

    public Set<AssistingJob> getSchedJobs(AppWorxJob job) {
        if (!job.getParentName().equals("EntitesWithoutProcessFlows")) {
            String entName = job.getParentName() + job.getEntityData().getEntityDisplayName();
            if (!this.name2AssistingJobs.containsKey(entName)) {
                this.name2AssistingJobs.put(entName, new LinkedHashSet());
                AttrHolderList schedList = job.getEntityData().getSched();
                if (schedList != null && !schedList.isEmpty()) {
                    for (IAttrHolder sched : schedList) {
                        if (!this.isActiveSched(sched)) continue;
                        this.name2AssistingJobs.get(entName).add(this.createAssistingJob(sched, job));
                    }
                }
            }
            return this.name2AssistingJobs.get(entName);
        }
        return Collections.emptySet();
    }

    private AssistingJob createAssistingJob(IAttrHolder sched, AppWorxJob job) {
        Object tableName;
        AssistingJob assistingJob = new AssistingJob((SchedEntity)job);
        String name = job.getJobName();
        name = String.format("SCHED_%s_%s", name, sched.getAttr("aw_sch_name"));
        assistingJob.setAttribute("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", name));
        Object table = job.getParentName();
        if (table == null) {
            table = "";
        }
        if (!((String)table).isEmpty()) {
            table = (String)table + "-";
        }
        table = (String)table + job.getJobName();
        table = "SCHED_" + ((String)table).replace('/', '-');
        table = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", (String)table);
        assistingJob.setAttribute("PARENT_TABLE", (String)table);
        assistingJob.setAttribute("TABLE_NAME", (String)table);
        boolean bConvertToDummy = this.rules.getTaskTypeHandler().isToDummy();
        if (bConvertToDummy) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                assistingJob.setAutoedit("%%$BMCWAIORIGTYPE", "Job");
            }
            assistingJob.setAttribute("TASKTYPE", "Dummy");
        } else {
            assistingJob.setAttribute("TASKTYPE", "Job");
        }
        assistingJob.setAttribute("TAG_RELATIONSHIP", "AND");
        ArrayList<Properties> tags = new ArrayList<Properties>();
        tags.add(this.convertAttrs2Rbc(sched));
        assistingJob.setM_tags(tags);
        for (Properties tag : tags) {
            if (tag.containsKey("ACTIVE_FROM")) {
                assistingJob.setOptionalAttribute("ACTIVE_FROM", tag.getProperty("ACTIVE_FROM"));
            }
            if (!tag.containsKey("ACTIVE_TILL")) continue;
            assistingJob.setOptionalAttribute("ACTIVE_TILL", tag.getProperty("ACTIVE_TILL"));
        }
        String intervalUnit = sched.getAttr("so_sch_grp");
        Integer interval = sched.getAttrAsInt("aw_sch_interval");
        String startTimes = sched.getAttr("aw_multi_start");
        if (intervalUnit.equals("HOURS") || intervalUnit.equals("MINUTES")) {
            String from = sched.getAttr("aw_day_start");
            String until = sched.getAttr("aw_day_end");
            if (from != null && !from.isEmpty()) {
                assistingJob.setAttribute("TIMEFROM", from.replace(":", ""));
            }
            if (until != null && !until.isEmpty()) {
                assistingJob.setAttribute("TIMETO", until.replace(":", ""));
            }
            assistingJob.setAttribute("CYCLIC", "1");
            assistingJob.setAttribute("IND_CYCLIC", "TARGET");
            assistingJob.setAttribute("CYCLIC_TYPE", "Interval");
            assistingJob.setAttribute("INTERVAL", String.format("%05d%c", interval, Character.valueOf(intervalUnit.charAt(0))));
        } else if (!startTimes.isEmpty()) {
            startTimes = startTimes.replace(":", "");
            assistingJob.setAttribute("CYCLIC", "1");
            assistingJob.setAttribute("IND_CYCLIC", "TARGET");
            assistingJob.setAttribute("CYCLIC_TYPE", "SpecificTimes");
            assistingJob.setAttribute("CYCLIC_TIMES_SEQUENCE", startTimes);
        }
        Integer secFromMidnight = sched.getAttrAsInt("aw_start_time");
        if (secFromMidnight != null) {
            Integer hours = secFromMidnight / 3600;
            Integer minutes = secFromMidnight % 3600 / 60;
            assistingJob.setAttribute("TIMEFROM", String.format("%02d%02d", hours, minutes));
        }
        Object object = tableName = job.type().equals((Object)SchedEntity.TYPE.SMART_TABLE) ? job.getJobName() : job.getParentName();
        if (job.type().equals((Object)SchedEntity.TYPE.SUB_TABLE)) {
            tableName = (String)tableName + "/" + job.getJobName();
        }
        String jobName = job.type().equals((Object)SchedEntity.TYPE.JOB) ? job.getJobName() : "\"*\"";
        StringBuilder variables = new StringBuilder();
        Properties where = new Properties();
        where.setProperty("so_module", sched.getAttr("so_module"));
        where.setProperty("aw_sch_name", sched.getAttr("aw_sch_name"));
        AttrHolderList schedArgs = EntityTableManager.get(EntityTableManager.EntityType.aw_sched_args).getAttrHoldersList(where);
        String ctmorderAutoeditSwitch = Params.instance().getGUIVersion().equals("7") ? "-AUTOEDIT" : "-VARIABLE";
        for (IAttrHolder schedArg : schedArgs) {
            AppWorxVariables appWorxVariables = new AppWorxVariables(schedArg.getAttr("so_det_arg"));
            variables.append(String.format("%s %%%%%s \"%s\" ", ctmorderAutoeditSwitch, schedArg.getAttr("so_det_arg_no"), appWorxVariables.getAnnotatedText()));
            for (Properties message : appWorxVariables.getMessages()) {
                Reporter.addMessage(job.getMessages(), (String)message.getProperty("MSGID"), (String)job.originalProductID(), (String[])((String[])message.get("RESVAR")));
            }
            AppWorxDefs.addActionsToReporter(job.getMessages(), appWorxVariables.getActions(), job.originalProductID());
        }
        String embeddedScript = String.format("#!/bin/sh\n\nctmorder -table %s -name %s %s -ODATE ODAT", tableName, jobName, variables);
        assistingJob.setAttribute("USE_INSTREAM_JCL", "Y");
        assistingJob.setAttribute("MEMNAME", "OrderingJob" + (job.getNodePlatform().equals("Windows") ? ".bat" : ""));
        assistingJob.setOptionalAttribute("INSTREAM_JCL", embeddedScript);
        return assistingJob;
    }

    private String getDateCalcBase(IAttrHolder schedAttrs) {
        String candidate = schedAttrs.getAttr("aw_next_rundate");
        if (candidate == null || candidate.isEmpty() || !candidate.matches("\\d{1,2}-\\d{1,2}-\\d{4}")) {
            candidate = schedAttrs.getAttr("aw_sch_frm_date");
        }
        if (candidate == null || candidate.isEmpty() || !candidate.matches("\\d{1,2}-\\d{1,2}-\\d{4}")) {
            candidate = schedAttrs.getAttr("aw_sch_start");
        }
        return candidate;
    }
}

