/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.ConditionsResolver;
import com.bmc.ctmconvert.appworx.CsvFileTable;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;

public class AppWorxEntity
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private IAttrHolder chainDetails;
    private IAttrHolder jobDetails;
    private AttrHolderList schedAttrs;
    private String entityName;
    private static int uniqueNumber = 0;
    private String entityID;
    private ArrayList<Properties> inConds = new ArrayList();
    private ArrayList<Properties> outConds = new ArrayList();
    private ArrayList<Properties> onStatements = new ArrayList();
    private LinkedHashMap<String, String> autoedits = new LinkedHashMap();
    private ArrayList<String> messages = new ArrayList();
    private AttrHolderList chainArgs;
    private AttrHolderList jobPrompts;
    private IAttrHolder library;
    private AttrHolderList conditions;
    private Boolean appworxToControlMConditions = null;

    public AppWorxEntity(String name) {
        this.entityName = name;
        super.setUserObject(this.getEntityDisplayName());
    }

    public AppWorxEntity(IAttrHolder chainDetails, IAttrHolder jobDetails) {
        this.chainDetails = chainDetails;
        this.jobDetails = jobDetails;
        if (jobDetails == null) {
            this.initializeJobDetails();
        }
        this.getSched();
        super.setUserObject(this.getEntityDisplayName());
    }

    public AttrHolderList getSched() {
        if (this.schedAttrs == null) {
            CsvFileTable schedTable = EntityTableManager.get(EntityTableManager.EntityType.aw_module_sched);
            Properties filter = new Properties();
            filter.setProperty("so_module", this.getEntityName());
            this.schedAttrs = schedTable.getAttrHoldersList(filter);
        }
        return this.schedAttrs;
    }

    private void initializeJobDetails() {
        if (this.chainDetails != null) {
            CsvFileTable jobTable = EntityTableManager.get(EntityTableManager.EntityType.so_job_table);
            AttrHolderList jobs = jobTable.getAttrHoldersList("so_module", this.chainDetails.getAttr("so_module_1"));
            if (jobs.size() > 1) {
                ExceptionHandler.writeToExceptionFile((String)("More then one jobTable for: " + this.chainDetails.getAttr("so_module_1")));
            } else if (jobs.isEmpty()) {
                ExceptionHandler.writeToExceptionFile((String)("No entry in the jobTable for: " + this.chainDetails.getAttr("so_module_1")));
            } else {
                this.jobDetails = (IAttrHolder)jobs.get(0);
            }
        }
    }

    public String getEntityName() {
        if (this.entityName == null) {
            if (this.jobDetails != null) {
                this.entityName = this.jobDetails.getAttr("so_module");
            } else if (this.chainDetails != null) {
                this.entityName = this.chainDetails.getAttr("so_module_1");
            }
        }
        return this.entityName;
    }

    public String getEntityDisplayName() {
        String displayName = "";
        displayName = this.chainDetails != null ? this.chainDetails.getAttr("so_task_name") : (this.jobDetails != null ? this.jobDetails.getAttr("so_module") : this.getEntityName());
        return displayName;
    }

    public String getEntityID() {
        if (this.entityID == null) {
            this.entityID = String.format("EID%d@%s", ++uniqueNumber, this.getEntityDisplayName());
        }
        return this.entityID;
    }

    public boolean isChain() {
        return this.jobDetails.getAttr("so_command_type").equals("CHAIN");
    }

    public IAttrHolder getJobDetails() {
        return this.jobDetails;
    }

    public IAttrHolder getChainDetails() {
        return this.chainDetails;
    }

    public void addInCondition(Properties condition) {
        if (condition != null && !condition.isEmpty() && !AppWorxEntity.existInList(this.inConds, condition)) {
            this.inConds.add(condition);
        }
    }

    public void addOutCondition(Properties condition) {
        if (condition != null && !condition.isEmpty() && !AppWorxEntity.existInList(this.outConds, condition)) {
            this.outConds.add(condition);
        }
    }

    public void addOnStatement(Properties onStatement) {
        if (onStatement != null && !onStatement.isEmpty() && !AppWorxEntity.existInList(this.onStatements, onStatement)) {
            this.onStatements.add(onStatement);
        }
    }

    public void addAutoedit(String name, String value) {
        this.autoedits.put(name, value);
    }

    private static boolean existInList(ArrayList<Properties> list, Properties properties) {
        boolean toRet = false;
        if (!list.isEmpty()) {
            for (Properties entry : list) {
                toRet = true;
                for (String key : entry.stringPropertyNames()) {
                    if (properties.contains(key) || entry.getProperty(key).equals(properties.getProperty(key))) continue;
                    toRet = false;
                    break;
                }
                if (!toRet) continue;
                break;
            }
        }
        return toRet;
    }

    public ArrayList<Properties> getInCondition() {
        return this.inConds;
    }

    public ArrayList<Properties> getOutCondition() {
        return this.outConds;
    }

    public ArrayList<Properties> getOnStatements() {
        return this.onStatements;
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    public AttrHolderList getChainArgs() {
        if (this.chainArgs == null) {
            CsvFileTable chainArgsTable = EntityTableManager.get(EntityTableManager.EntityType.so_chain_args);
            Properties where = new Properties();
            where.setProperty("so_module", ((AppWorxEntity)this.getParent()).getEntityName());
            where.setProperty("so_task_name", this.getEntityDisplayName());
            this.chainArgs = chainArgsTable.getAttrHoldersList(where);
        }
        return this.chainArgs;
    }

    public String[] getParentChainPrompts() {
        CsvFileTable jobPromptsTable = EntityTableManager.get(EntityTableManager.EntityType.so_job_prompts);
        AttrHolderList chainPrompts = jobPromptsTable.getAttrHoldersList("so_module", ((AppWorxEntity)this.getParent()).getEntityName());
        String[] promptsArray = new String[chainPrompts.size() + 1];
        for (IAttrHolder arg : chainPrompts) {
            promptsArray[Integer.valueOf((String)arg.getAttr((String)"so_prompt")).intValue()] = arg.getAttr("so_prompt_descr");
        }
        return promptsArray;
    }

    public AttrHolderList getJobPrompts() {
        if (this.jobPrompts == null) {
            CsvFileTable jobPromptsTable = EntityTableManager.get(EntityTableManager.EntityType.so_job_prompts);
            this.jobPrompts = jobPromptsTable.getAttrHoldersList("so_module", this.getEntityName());
        }
        return this.jobPrompts;
    }

    public IAttrHolder getCommandRecord(CsvFileTable soCommandPasthTable) {
        AttrHolderList commandPathRecord;
        IAttrHolder retVal = null;
        String commandType = this.jobDetails.getAttr("so_command_type");
        if (commandType != null && !commandType.isEmpty() && (commandPathRecord = soCommandPasthTable.getAttrHoldersList("so_commd_type", commandType)) != null && !commandPathRecord.isEmpty()) {
            if (commandPathRecord.size() > 1) {
                ConversionLogger.getLogger().info(String.format("More than one command path record defined for %s in folder %s", commandType, EntityTableManager.EntityType.so_command_paths.toString()));
            }
            retVal = (IAttrHolder)commandPathRecord.get(0);
        }
        return retVal;
    }

    public IAttrHolder getLibrary() {
        if (this.library == null) {
            CsvFileTable chainArgsTable = EntityTableManager.get(EntityTableManager.EntityType.so_libraries);
            String libraryName = this.jobDetails.getAttr("so_library");
            if (libraryName != null && !libraryName.isEmpty()) {
                AttrHolderList libraries = chainArgsTable.getAttrHoldersList("so_library", libraryName);
                if (libraries.isEmpty()) {
                    Reporter.addMessage(this.messages, (String)"WRN11029", (String)this.getEntityID(), (String[])new String[]{this.jobDetails.getAttr("so_library"), EntityTableManager.EntityType.so_libraries.toString()});
                } else {
                    this.library = (IAttrHolder)libraries.get(0);
                    if (libraries.size() > 1) {
                        ConversionLogger.getLogger().info(String.format("More than one libary defined for %s in folder %s", libraryName, EntityTableManager.EntityType.so_libraries.toString()));
                    }
                }
            } else {
                Reporter.addMessage(this.messages, (String)"WRN11030", (String)this.getEntityID(), (String[])new String[]{this.jobDetails.getAttr("so_module"), EntityTableManager.EntityType.so_job_table.toString()});
            }
        }
        return this.library;
    }

    public AttrHolderList getConditions() {
        if (this.conditions == null) {
            this.conditions = new AttrHolderList();
            Properties where = new Properties();
            CsvFileTable objectConditionsTable = EntityTableManager.get(EntityTableManager.EntityType.so_object_cond);
            where.put("so_module", this.getEntityName());
            where.put("so_obj_type", "M");
            AttrHolderList moduleConditions = objectConditionsTable.getAttrHoldersList(where);
            AttrHolderList chainConditions = new AttrHolderList();
            if (this.parent != null) {
                where.put("so_module", ((AppWorxEntity)this.parent).getEntityName());
                where.put("so_task_name", this.getEntityDisplayName());
                where.put("so_obj_type", "C");
                chainConditions = objectConditionsTable.getAttrHoldersList(where);
            }
            int size = 0;
            AttrHolderList itemsCounterList = new AttrHolderList();
            itemsCounterList.addAll((Collection)moduleConditions);
            itemsCounterList.addAll((Collection)chainConditions);
            for (IAttrHolder condition : itemsCounterList) {
                int currSocOrder = condition.getAttrAsInt("so_soc_order");
                size = currSocOrder > size ? currSocOrder : size;
            }
            if (size > 0) {
                AttrHolder[] orderedConditionsArray = new AttrHolder[size + 1];
                for (IAttrHolder condition : moduleConditions) {
                    orderedConditionsArray[condition.getAttrAsInt((String)"so_soc_order").intValue()] = condition;
                }
                for (IAttrHolder condition : chainConditions) {
                    orderedConditionsArray[condition.getAttrAsInt((String)"so_soc_order").intValue()] = condition;
                }
                for (AttrHolder condition : orderedConditionsArray) {
                    if (condition == null) continue;
                    this.conditions.add((Object)condition);
                }
            }
            if (this.conditions.size() == 1) {
                String sCondition = ((IAttrHolder)this.conditions.get(0)).getAttr("so_condition_1");
                String sAction = ((IAttrHolder)this.conditions.get(0)).getAttr("so_action");
                this.appworxToControlMConditions = ConditionsResolver.IsSupportedConditionActionPair(sCondition, sAction);
            }
        }
        return this.conditions;
    }

    public boolean hasAppworxToControlMConditions() {
        if (null == this.appworxToControlMConditions) {
            this.appworxToControlMConditions = false;
            this.getConditions();
        }
        return this.appworxToControlMConditions;
    }
}

