/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.CsvFileTable;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class AppWorxEntitiesWithoutParentFileGenerator {
    public void generateCsvFile(Path dataDirectory) {
        Path noProccessFlowJobsFileName = dataDirectory.resolve("EntitesWithoutProcessFlows.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(noProccessFlowJobsFileName, new OpenOption[0]);){
            writer.write("so_module,so_command_type\n");
            CsvFileTable jobTable = EntityTableManager.get(EntityTableManager.EntityType.so_job_table);
            CsvFileTable chainTable = EntityTableManager.get(EntityTableManager.EntityType.so_chain_detail);
            for (IAttrHolder entry : jobTable.getAttrHoldersList()) {
                boolean isJobChain = entry.getAttr("so_command_type").equalsIgnoreCase("CHAIN");
                if (!isJobChain) {
                    this.writeJobWithoutParent(writer, chainTable, entry);
                    continue;
                }
                this.writeSubFoldersWithoutParent(writer, chainTable, entry);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private void writeSubFoldersWithoutParent(BufferedWriter writer, CsvFileTable chainTable, IAttrHolder jobDetailEntry) throws IOException {
        boolean isChainWithoutParent;
        String currentSubFolderName = jobDetailEntry.getAttr("so_module");
        AttrHolderList basicChain = chainTable.getAttrHoldersList("so_module_1", currentSubFolderName);
        AttrHolderList duplictedChain = chainTable.getAttrHoldersList("so_task_name", currentSubFolderName);
        boolean bl = isChainWithoutParent = basicChain.size() != 0 && duplictedChain.size() == 0;
        if (isChainWithoutParent) {
            writer.write(currentSubFolderName + "," + jobDetailEntry.getAttr("so_command_type") + "\n");
        }
    }

    private void writeJobWithoutParent(BufferedWriter writer, CsvFileTable chainTable, IAttrHolder jobDetailEntry) throws IOException {
        String currentJobName = jobDetailEntry.getAttr("so_module");
        AttrHolderList parentsList = chainTable.getAttrHoldersList("so_task_name", currentJobName);
        if (parentsList.size() == 0) {
            writer.write(currentJobName + "," + jobDetailEntry.getAttr("so_command_type") + "\n");
        }
    }
}

