/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.appworx;

import com.bmc.ctmconvert.appworx.AppWorxEntity;
import com.bmc.ctmconvert.appworx.AppWorxHierarchyTree;
import com.bmc.ctmconvert.appworx.EntityTableManager;
import com.bmc.ctmconvert.appworx.NodesTable;
import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class AppWorxAssessmentReport
extends AbstractAssessmentReport {
    private static final String appworxDataTableTitle = "AppWorx Data Tables";
    private static final String appworxHierarchyTreeTitle = "AppWorx Hierarchy Tree";
    private static final String nodesInUseTreeTitle = "Nodes In Use";
    private static final String nodesMappingTreeTitle = "Nodes Mapping";
    private static final String nodesTreeTitle = "Nodes";
    private static final String nodesGroupsTreeTitle = "Node Groups";
    private static final String mappedNodesTreeTitle = "Mapped Nodes";
    private static final String mappedNodesGroupsTreeTitle = "Mapped Node Groups";
    private static final String appWorxTablesTitle = "AppWorxTables";
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private Properties nodesParameters;
    private Pattern parametersPattern;

    public AppWorxAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        NodesTable.destroy();
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
        this.nodesParameters = new Properties();
        this.parametersPattern = Pattern.compile("(#\\S+#)");
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode nodesMapping;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        DefaultMutableTreeNode appworxDataTables = new DefaultMutableTreeNode(appworxDataTableTitle);
        for (EntityTableManager.EntityType table : EntityTableManager.EntityType.values()) {
            if (table.name().equals("EntitesWithoutProcessFlows")) continue;
            DefaultMutableTreeNode tableData = new DefaultMutableTreeNode(table.toString() + " (" + EntityTableManager.get(table).getAttrHoldersList().size() + ")");
            for (IAttrHolder record : EntityTableManager.get(table).getAttrHoldersList()) {
                DefaultMutableTreeNode recordData = new DefaultMutableTreeNode(record.getAttr(table.getTableIDKey()));
                tableData.add(recordData);
            }
            this.nodesParameters.setProperty("#NUMBER_OF_ENTRIES_IN_TABLE#" + String.valueOf((Object)table), "" + tableData.getChildCount());
            appworxDataTables.add(tableData);
        }
        this.nodesParameters.setProperty("#NUMBER_OF_TABLES#", "" + appworxDataTables.getChildCount());
        this.nodesParameters.setProperty("#NUMBER_OF_ENTRIES_IN_TABLE#AppWorxTables", "#NUMBER_OF_ENTRIES_IN_TABLE#");
        root.add(appworxDataTables);
        root.add(this.cloneHierarchyTree());
        DefaultMutableTreeNode nodesInUse = this.getNodesTree(true);
        if (nodesInUse.getChildCount() > 0) {
            root.add(nodesInUse);
        }
        if ((nodesMapping = this.getNodesTree(false)).getChildCount() > 0) {
            root.add(nodesMapping);
        }
        return root;
    }

    private DefaultMutableTreeNode getNodesTree(boolean inUse) {
        Set<String> nodesList;
        HashMap<String, Integer> nodesListHash;
        DefaultMutableTreeNode nodesRoot = new DefaultMutableTreeNode();
        if (inUse) {
            nodesListHash = AppWorxHierarchyTree.instance().getNodesList();
            nodesList = nodesListHash.keySet();
        } else {
            nodesListHash = null;
            nodesList = NodesTable.instance().getNodesList();
        }
        if (nodesList.size() > 0) {
            nodesRoot.setUserObject(inUse ? nodesInUseTreeTitle : nodesMappingTreeTitle);
            DefaultMutableTreeNode nodes = new DefaultMutableTreeNode(inUse ? nodesTreeTitle : mappedNodesTreeTitle);
            DefaultMutableTreeNode nodeGroups = new DefaultMutableTreeNode(inUse ? nodesGroupsTreeTitle : mappedNodesGroupsTreeTitle);
            ArrayList<String> nodesLess25Jobs = new ArrayList<String>();
            for (String node : nodesList) {
                DefaultMutableTreeNode currNode = new DefaultMutableTreeNode(node);
                Properties nodeProperties = NodesTable.instance().getNodeProperties(node);
                if (nodeProperties != null && nodeProperties.getProperty("Group").equals("Y")) {
                    for (String name : (ArrayList)nodeProperties.get("GroupNodeList")) {
                        currNode.add(new DefaultMutableTreeNode(name));
                    }
                    nodeGroups.add(currNode);
                } else {
                    nodes.add(currNode);
                }
                if (!inUse || nodesListHash.get(node) <= 25) continue;
                nodesLess25Jobs.add(node);
            }
            if (nodes.getChildCount() > 0) {
                nodes.setUserObject(String.valueOf(nodes.getUserObject()) + " (" + nodes.getChildCount() + ")");
                this.nodesParameters.setProperty(inUse ? "#NUMBER_OF_NODES#" : "#NUMBER_OF_MAPPED_NODES#", "" + nodes.getChildCount());
                nodesRoot.add(nodes);
            }
            if (nodeGroups.getChildCount() > 0) {
                nodeGroups.setUserObject(String.valueOf(nodeGroups.getUserObject()) + " (" + nodeGroups.getChildCount() + ")");
                this.nodesParameters.setProperty(inUse ? "#NUMBER_OF_NODE_GROUPS#" : "#NUMBER_OF_MAPPED_NODE_GROUPS#", "" + nodeGroups.getChildCount());
                nodesRoot.add(nodeGroups);
            }
            if (inUse && !nodesLess25Jobs.isEmpty()) {
                this.nodesParameters.setProperty("#NUMBER_OF_NODES_LESS_THAN_25_JOBS#", "" + nodesLess25Jobs.size());
                StringBuilder machinesList = new StringBuilder();
                for (String machine : nodesLess25Jobs) {
                    machinesList.append(machine).append("\n");
                }
                this.nodesParameters.setProperty("#LIST_NODE_LESS_25_JOBS#", machinesList.toString());
            }
        }
        return nodesRoot;
    }

    private DefaultMutableTreeNode cloneHierarchyTree() {
        DefaultMutableTreeNode toRet = AppWorxHierarchyTree.instance().getHierarchyTree();
        Enumeration<TreeNode> enumeration = toRet.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            AppWorxEntity entity = (AppWorxEntity)enumeration.nextElement();
            if (entity.getEntityName().equals("EntitesWithoutProcessFlows")) {
                toRet.remove(entity);
            }
            if (entity.isLeaf()) continue;
            entity.setUserObject(String.valueOf(entity.getUserObject()) + " (" + entity.getChildCount() + ")");
        }
        toRet.setUserObject(appworxHierarchyTreeTitle);
        return toRet;
    }

    protected String getJobInfo(String messageID) {
        String[] messagePartArray = messageID.split(";");
        String rootName = null;
        String nodeName = null;
        String entityName = null;
        Object message = null;
        if (messageID == null || messageID.isEmpty()) {
            return "";
        }
        if (messagePartArray.length > 1) {
            rootName = messagePartArray[1];
            if (messagePartArray[1].endsWith(")")) {
                rootName = messagePartArray[1].substring(0, messagePartArray[2].lastIndexOf(" ("));
            }
        }
        if (messagePartArray.length > 2 && messagePartArray[2].endsWith(")")) {
            nodeName = messagePartArray[2];
            if (messagePartArray[2].endsWith(")")) {
                nodeName = messagePartArray[2].substring(0, messagePartArray[2].lastIndexOf(" ("));
            }
        }
        if (messagePartArray.length >= 3 && (entityName = messagePartArray[messagePartArray.length - 1]).endsWith(")")) {
            entityName = entityName.substring(0, entityName.lastIndexOf(" ("));
        }
        if (rootName.equals(appworxDataTableTitle)) {
            if (entityName != null && !entityName.isEmpty()) {
                if (messagePartArray.length > 3) {
                    try {
                        EntityTableManager.EntityType table = EntityTableManager.EntityType.valueOf(nodeName);
                        message = this.getJobInfo((IAttrHolder)EntityTableManager.get(table).getAttrHoldersList(table.getTableIDKey(), entityName).get(0));
                    }
                    catch (IllegalArgumentException e) {
                        ExceptionHandler.writeToExceptionFile((Exception)e);
                    }
                } else {
                    message = entityName + "\n" + this.evaluateDescriptionParameters(entityName, (String)this.m_NodeName_NodeDescription.get(appWorxTablesTitle));
                }
            }
        } else if (rootName.equals(appworxHierarchyTreeTitle)) {
            message = null;
        } else if (rootName.equals(nodesInUseTreeTitle) || rootName.equals(nodesMappingTreeTitle)) {
            if (messagePartArray.length > 3) {
                Properties nodeProperties = NodesTable.instance().getNodeProperties(entityName);
                if (nodeProperties != null) {
                    message = this.getJobInfo(nodeProperties);
                }
            } else if (this.m_NodeName_NodeDescription.containsKey(entityName)) {
                message = (String)this.m_NodeName_NodeDescription.get(entityName);
            }
        }
        return message;
    }

    protected String getJobInfo(DefaultMutableTreeNode node) {
        String message = null;
        if (node != null && node.getClass().equals(AppWorxEntity.class)) {
            AppWorxEntity entity = (AppWorxEntity)node;
            message = this.getJobInfo(entity.getJobDetails());
        }
        return message;
    }

    private String getJobInfo(IAttrHolder data) {
        Object jobInfo = "";
        if (data != null) {
            String[] header = data.getCsvHeader().split(",");
            for (int index = 0; index < header.length; ++index) {
                jobInfo = (String)jobInfo + String.format("%-40s\t: %s%s", header[index], data.getAttr(header[index]), "\n");
            }
        }
        return jobInfo;
    }

    private String getJobInfo(Properties data) {
        Object jobInfo = "";
        if (data != null) {
            for (Object name : data.keySet()) {
                jobInfo = (String)jobInfo + String.format("%-40s\t: %s%s", name, data.get(name), "\n");
            }
        }
        return jobInfo;
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add(appworxDataTableTitle);
        toRet.add(appworxHierarchyTreeTitle);
        toRet.add(nodesInUseTreeTitle);
        toRet.add(nodesMappingTreeTitle);
        return toRet;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        return toRet;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        String[] messagePartArray = parentNodeID.split(";");
        String rootName = null;
        String nodeName = null;
        String entityName = null;
        ArrayList toRet = new ArrayList();
        if (parentNodeID == null || parentNodeID.isEmpty()) {
            return toRet;
        }
        if (messagePartArray.length > 1) {
            rootName = messagePartArray[1];
            if (messagePartArray[1].endsWith(")")) {
                rootName = messagePartArray[1].substring(0, messagePartArray[2].lastIndexOf(" ("));
            }
        }
        if (messagePartArray.length > 2 && messagePartArray[2].endsWith(")")) {
            nodeName = messagePartArray[2];
            if (messagePartArray[2].endsWith(")")) {
                nodeName = messagePartArray[2].substring(0, messagePartArray[2].lastIndexOf(" ("));
            }
        }
        if (messagePartArray.length > 3 && (entityName = messagePartArray[messagePartArray.length - 1]).endsWith(")")) {
            entityName = entityName.substring(0, entityName.lastIndexOf(" ("));
        }
        if (rootName.equals(nodesTreeTitle) && nodeName.equals(nodesGroupsTreeTitle)) {
            toRet = (ArrayList)NodesTable.instance().getNodeProperties(entityName).get("GroupNodeList");
        }
        return toRet;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("Summary:").append("\n").append("\n");
        String extraSummary = null;
        if (this.m_DescriptionXMLReader.isAutoBuildMainSummary()) {
            for (String nodeName : descriptionMap_NodeName_NodeDesc.keySet()) {
                String nodeDescription = this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName));
                descriptionMap_NodeName_NodeDesc.put(nodeName, nodeDescription);
                if (nodeName.compareToIgnoreCase("MainSummary") == 0 || nodeName.compareToIgnoreCase(appWorxTablesTitle) == 0) continue;
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = this.evaluateDescriptionParameters("ExtraSummary", (String)descriptionMap_NodeName_NodeDesc.get(nodeName));
                    continue;
                }
                mainSummary.append(nodeDescription).append("\n").append("\n");
            }
            if (null != extraSummary) {
                mainSummary.append(extraSummary).append("\n").append("\n");
            }
        } else {
            mainSummary.append(this.evaluateDescriptionParameters("MainSummary", (String)descriptionMap_NodeName_NodeDesc.get("MainSummary")));
            String sExtraSummary = (String)descriptionMap_NodeName_NodeDesc.get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append("\n").append("\n").append("ExtraSummary").append("\n").append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary)).append("\n");
            }
        }
        descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName_NodeDesc;
    }

    private String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (sDescription != null && sDescription.contains("#")) {
            Matcher matcher = this.parametersPattern.matcher(sDescription);
            while (matcher.find()) {
                String sNum;
                Object sKey = matcher.group(0);
                if (((String)sKey).equals("#NUMBER_OF_ENTRIES_IN_TABLE#")) {
                    sKey = (String)sKey + sNodeName;
                }
                if (null == (sNum = this.nodesParameters.getProperty((String)sKey))) {
                    sNum = "0";
                }
                sDescription = sDescription.replace(matcher.group(0), sNum);
            }
        }
        return sDescription;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return this.getJobInfo(NodesTable.instance().getNodeProperties(messageID));
    }
}

