/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.Locale;

enum SqlAuthentication {
    NotSpecified,
    SqlPassword,
    ActiveDirectoryPassword,
    ActiveDirectoryIntegrated;


    static SqlAuthentication valueOfString(String value) throws SQLServerException {
        SqlAuthentication method = null;
        if (value.toLowerCase(Locale.US).equalsIgnoreCase(NotSpecified.toString())) {
            method = NotSpecified;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(SqlPassword.toString())) {
            method = SqlPassword;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(ActiveDirectoryPassword.toString())) {
            method = ActiveDirectoryPassword;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(ActiveDirectoryIntegrated.toString())) {
            method = ActiveDirectoryIntegrated;
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidConnectionSetting"));
            Object[] msgArgs = new Object[]{"authentication", value};
            throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
        }
        return method;
    }
}

