/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.variables;

import com.bmc.ctmconvert.common.AutoEditsConcatenator;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.VarTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariablesHandler {
    private static final Pattern VARIABLE_EXPRESSION = Pattern.compile(".*[^\\\\]?(\\^(.*?[^\\\\])\\^).*");
    private static final AutoEditsConcatenator AUTO_EDITS_CONCATENATOR = new AutoEditsConcatenator(Pattern.compile("(\\^.*?[^\\\\]\\^)"));
    public static final String GLOBAL_POOL = "global";
    private final TwsJob twsJob;
    private final VarTable varTable;
    private static final MessageHandler EMPTY_MESSAGE_HANDLER = (messageID, params) -> {};

    public VariablesHandler(TwsJob twsJob, VarTable varTable) {
        this.twsJob = twsJob;
        this.varTable = varTable;
    }

    public static boolean isTWSVariable(String text) {
        Matcher varMatcher = VARIABLE_EXPRESSION.matcher(text);
        return varMatcher.find();
    }

    public String convert(String command) {
        return this.convert(command, EMPTY_MESSAGE_HANDLER);
    }

    public String convert(String input, MessageHandler messageHandler) {
        if (input.matches("^\".+\"$")) {
            input = input.replaceAll("^\"", "").replaceAll("\"$", "");
        }
        input = AUTO_EDITS_CONCATENATOR.concat(input);
        Matcher variableMatcher = VARIABLE_EXPRESSION.matcher(input);
        ArrayList<String> listParametersNotFound = new ArrayList<String>();
        while (variableMatcher.find()) {
            String fullVariable = variableMatcher.group(1);
            String variable = variableMatcher.group(2);
            String cpuName = this.twsJob.GetOrigNodeid();
            ArrayList<String> tables = this.twsJob.getListOfTables();
            String varValue = this.varTable.getVariable(cpuName, tables, variable);
            String tableName = this.getVariableTableName(this.twsJob);
            String autoeditName = this.formatVariable(variable, tableName);
            this.addAutoeditAction(autoeditName, varValue);
            if (varValue == null) {
                listParametersNotFound.add(variable);
            }
            input = input.replace(fullVariable, autoeditName);
            variableMatcher = VARIABLE_EXPRESSION.matcher(input);
        }
        if (!listParametersNotFound.isEmpty()) {
            messageHandler.handleMessage("", new String[0]);
        }
        return input;
    }

    public static MessageHandler createMessageHandler(SchedEntity twsJob, String msgId) {
        return (messageID, params) -> Reporter.addMessage((List)twsJob.getMessages(), (String)msgId, (String)twsJob.generateUniqueID(), (String[])new String[]{twsJob.getJobName(), twsJob.toString()});
    }

    private String formatVariable(String variable, String tableName) {
        return String.format("%%%%\\\\%s\\%s", tableName, variable);
    }

    private void addAutoeditAction(String autoedit, String value) {
        String autoeditValue = value == null ? "" : value;
        Reporter.addGlobalAutoEditAction(this.twsJob.getMessages(), (String)GlobalFunctions.removeVariablePrefix((String)autoedit), (String)autoeditValue, (String)this.twsJob.generateUniqueID());
    }

    private String getVariableTableName(TwsJob twsJob) {
        TwsJob parentTable = twsJob.getParent();
        if (parentTable != null && parentTable.type() != SchedEntity.TYPE.JOB) {
            return Optional.ofNullable(parentTable.getSourceSched().getAttributes().getAttr("vartable")).filter(s -> !s.isBlank()).orElse(GLOBAL_POOL);
        }
        return GLOBAL_POOL;
    }
}

