/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.tasks;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.tws.TwsBaseConvertor;
import com.bmc.ctmconvert.tws.TwsJob;

public class TwsTaskInformaticaConvertor
implements TwsBaseConvertor {
    private TwsJob twsJob;
    private XmlElement taskDefintionXml;

    @Override
    public void convert() {
        this.setDefaultAttributes();
        this.setInformaticaAutoedites();
        this.twsJob.addMessage("WRN6046", this.twsJob.getOriginalJobName(), this.twsJob.getJobName());
    }

    private void setInformaticaAutoedites() {
        XmlElement repFolder = this.taskDefintionXml.getAllDecnedElementByName("jsdlpowercenter:folder").stream().findFirst().orElse(XmlElement.nullXmlElement);
        XmlElement workflow = this.taskDefintionXml.getAllDecnedElementByName("jsdlpowercenter:workflow").stream().findFirst().orElse(XmlElement.nullXmlElement);
        XmlElement repository = this.taskDefintionXml.getAllDecnedElementByName("jsdlpowercenter:repository").stream().findFirst().orElse(XmlElement.nullXmlElement);
        XmlElement service = this.taskDefintionXml.getAllDecnedElementByName("jsdlpowercenter:service").stream().findFirst().orElse(XmlElement.nullXmlElement);
        XmlElement wkfParamFile = this.taskDefintionXml.getAllDecnedElementByName("jsdlpowercenter:wkfParamFile").stream().findFirst().orElse(XmlElement.nullXmlElement);
        this.twsJob.addAutoEdits("%%INF-EXEC_TYPE", "Informatica Workflow");
        this.twsJob.addAutoEdits("%%INF-WORKFLOW_EXE_MODE", "WHOLE");
        this.twsJob.addAutoEdits("%%INF-INSTANCE_NAME", this.twsJob.getJobName());
        this.twsJob.addAutoEdits("%%INF-REP_FOLDER", repFolder.getValue());
        this.twsJob.addAutoEdits("%%INF-WORKFLOW", workflow.getValue());
        this.twsJob.addAutoEdits("%%INF-WORKFLOW_PARAMETERS_FILE", wkfParamFile.getValue());
        this.twsJob.addAutoEdits("%%INF-ACCOUNT", repository.getValue() + "_" + service.getValue());
    }

    private void setDefaultAttributes() {
        this.twsJob.setOptionalAtrribute("TASKTYPE", "Job");
        this.twsJob.setOptionalAtrribute("APPL_FORM", "Informatica");
        this.twsJob.setOptionalAtrribute("APPL_TYPE", "ETL_INFA");
        this.twsJob.setOptionalAtrribute("APPL_VER", "9.0.00");
        this.twsJob.setOptionalAtrribute("CM_VER", "N/A");
    }

    @Override
    public void init(TwsJob twsJob, XmlElement taskDefintionXml) {
        this.twsJob = twsJob;
        this.taskDefintionXml = taskDefintionXml;
    }
}

