/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.tasks;

import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.tws.TwsBaseConvertor;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.VarTable;
import com.bmc.ctmconvert.tws.variables.VariablesHandler;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class TwsTaskExecutableConvertor
implements TwsBaseConvertor {
    private TwsJob twsJob;
    private XmlElement taskDefintionXml;
    private VariablesHandler variablesHandler;
    private MessageHandler messageHandler;

    @Override
    public void init(TwsJob twsJob, XmlElement taskDefintionXml) {
        this.twsJob = twsJob;
        this.taskDefintionXml = taskDefintionXml;
        this.messageHandler = VariablesHandler.createMessageHandler(twsJob, "WRN6012");
        this.variablesHandler = new VariablesHandler(twsJob, VarTable.instance());
    }

    @Override
    public void convert() {
        XmlElement taskExecutableWithPath;
        String scriptPath;
        List taskApplctionXml = this.taskDefintionXml.getAllDecnedElementByName("jsdle:script");
        if (taskApplctionXml.size() == 1) {
            this.twsJob.addAttribute("TASKTYPE", "Job");
            String script = ((XmlElement)taskApplctionXml.get(0)).getValue();
            this.twsJob.addAttribute("INSTREAM_JCL", script);
            this.twsJob.addAttribute("USE_INSTREAM_JCL", "Y");
            this.twsJob.addAttribute("MEMNAME", this.twsJob.getJobName() + ".cmd");
            return;
        }
        List taskExecutableWithPathList = this.taskDefintionXml.getAllDecnedElementByName("jsdle:executable");
        if (taskExecutableWithPathList.size() == 1 && (scriptPath = (taskExecutableWithPath = (XmlElement)taskExecutableWithPathList.get(0)).getAttribute("path")) != null && !scriptPath.isEmpty()) {
            this.twsJob.addAttribute("TASKTYPE", "Command");
            String commandWithArguments = this.addArguments(scriptPath);
            commandWithArguments = this.variablesHandler.convert(commandWithArguments, this.messageHandler);
            this.twsJob.addAttribute("CMDLINE", commandWithArguments);
            return;
        }
        this.twsJob.addMessage("WRN6033", this.twsJob.getOriginalJobName(), this.twsJob.getJobName());
    }

    private String addArguments(String scriptPath) {
        List taskExecutableArgumentsValuesList = this.taskDefintionXml.getAllDecnedElementByName("jsdle:value");
        String arguments = taskExecutableArgumentsValuesList.stream().map(XmlElement::getValue).collect(Collectors.joining(" ")).trim();
        return new StringJoiner(" ").add(scriptPath).add(arguments).toString().trim();
    }
}

