/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws.tasks;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.VarTable;
import com.bmc.ctmconvert.tws.tasks.TwsDBConvertorBase;
import com.bmc.ctmconvert.tws.variables.VariablesHandler;
import java.util.ArrayList;
import java.util.List;

public class TwsDBStoredProcedureConvertor
extends TwsDBConvertorBase {
    private VariablesHandler variablesHandler;

    @Override
    public void init(TwsJob twsJob, XmlElement taskDefinitionXml) {
        super.init(twsJob, taskDefinitionXml);
        this.variablesHandler = new VariablesHandler(twsJob, VarTable.instance());
    }

    @Override
    public void convertJob() {
        this.twsJob.addAutoEdits("%%DB-EXEC_TYPE", "Stored Procedure");
        List taskApplctionXml = this.taskDefinitionXml.getAllDecnedElementByName("jsdldatabase:sqlActionInfo");
        if (!taskApplctionXml.isEmpty()) {
            String schemaName = this.getSchemaName((XmlElement)taskApplctionXml.get(0));
            String storedProcedureName = this.getName((XmlElement)taskApplctionXml.get(0));
            this.twsJob.addAutoEdits("%%DB-STP_NAME", this.variablesHandler.convert(storedProcedureName));
            this.twsJob.addAutoEdits("%%DB-STP_SCHEM", this.variablesHandler.convert(schemaName));
            List parameterTableValues = ((XmlElement)taskApplctionXml.get(0)).getAllDecnedElementByName("jsdldatabase:ParameterTableValues");
            if (parameterTableValues != null) {
                this.fillParametersTable(this.twsJob, parameterTableValues);
            }
        }
        this.twsJob.addMessage("WRN6031", this.twsJob.getOriginalJobName(), this.twsJob.getJobName());
    }

    private void fillParametersTable(TwsJob twsJob, List<XmlElement> parameterTableValues) {
        ArrayList parameterTableVaribles = parameterTableValues.isEmpty() ? new ArrayList() : parameterTableValues.get(0).getAllDecnedElementByName("jsdldatabase:ParameterTableValue");
        for (XmlElement varible : parameterTableVaribles) {
            int varNumber;
            String[] keyValues;
            boolean isNumeric;
            String key = varible.getAttribute("key");
            String value = varible.getValue();
            if (value == null) {
                value = "";
            }
            if (!(isNumeric = (keyValues = key.split(" "))[3].chars().allMatch(Character::isDigit))) {
                varNumber = 0;
                keyValues[2] = "INTEGER";
            } else {
                varNumber = Integer.valueOf(keyValues[3]);
            }
            twsJob.addAutoEdits(String.format("%%%%DB-STP_PARAMS-P%03d-PRM_DIRECTION", varNumber), keyValues[0]);
            twsJob.addAutoEdits(String.format("%%%%DB-STP_PARAMS-P%03d-PRM_NAME", varNumber), keyValues[1]);
            twsJob.addAutoEdits(String.format("%%%%DB-STP_PARAMS-P%03d-PRM_TYPE", varNumber), keyValues[2]);
            twsJob.addAutoEdits(String.format("%%%%DB-STP_PARAMS-P%03d-PRM_VALUE", varNumber), this.variablesHandler.convert(value));
        }
    }

    private String getSchemaName(XmlElement xmlElement) {
        String[] names = this.getAttrName(xmlElement);
        return names.length > 1 ? names[0] : "";
    }

    private String getName(XmlElement xmlElement) {
        String[] names = this.getAttrName(xmlElement);
        if (names.length > 1) {
            return names[1];
        }
        if (names.length == 1) {
            return names[0];
        }
        return "";
    }

    private String[] getAttrName(XmlElement xmlElement) {
        List storedProcedureElement = xmlElement.getAllDecnedElementByName("jsdldatabase:storedProcedure");
        String nameAttr = ((XmlElement)storedProcedureElement.get(0)).getAttribute("NAME".toLowerCase());
        return nameAttr.split("\\$");
    }
}

