/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.tws;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.tws.TwsDefs;
import com.bmc.ctmconvert.tws.TwsJob;
import com.bmc.ctmconvert.tws.VarTable;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TwsOpenToFw {
    private TwsJob twsJob;
    private HashMap<String, String> attributes;
    private TwsDefs sourceDefinition;
    private VarTable varTable;

    public TwsOpenToFw(TwsJob twsJob, HashMap<String, String> attributes, TwsDefs sourceDefinition) {
        this.twsJob = twsJob;
        this.attributes = attributes;
        this.sourceDefinition = sourceDefinition;
        this.varTable = VarTable.instance();
    }

    public ArrayList<AssistingJob> createOpensJobs() {
        ArrayList<AssistingJob> toRet = null;
        ArrayList<String> opensStatements = this.twsJob.getParamValues("OPENS");
        if (opensStatements != null && !opensStatements.isEmpty()) {
            int count = 0;
            for (String statement : opensStatements) {
                ArrayList<AssistingJob> tmpJobsArr;
                String VarExpr = ".*(\\^([^\\^]+)\\^).*";
                Pattern varPattern = Pattern.compile(".*(\\^([^\\^]+)\\^).*");
                Matcher opensStatementMatcher = varPattern.matcher(statement);
                HashMap<CallSite, String> retJobAutoedits = new HashMap<CallSite, String>();
                while (opensStatementMatcher.matches()) {
                    String fullVariable = opensStatementMatcher.group(1);
                    String variable = opensStatementMatcher.group(2);
                    String cpuName = this.twsJob.GetOrigNodeid();
                    ArrayList<String> tables = this.twsJob.getListOfTables();
                    String varValue = this.varTable.getVariable(cpuName, tables, variable);
                    String autoeditName = "%%" + variable;
                    if (varValue == null) {
                        this.twsJob.addMessage("WRN6015", this.twsJob.generateUniqueID(), variable, "DEFAULT_OPENS_VALUE");
                        retJobAutoedits.put((CallSite)((Object)autoeditName), "");
                    } else {
                        retJobAutoedits.put((CallSite)((Object)autoeditName), varValue);
                    }
                    statement = statement.replace(fullVariable, autoeditName);
                    opensStatementMatcher = varPattern.matcher(statement);
                }
                if ((tmpJobsArr = this.opensStatementToJob(statement, count++)) == null) continue;
                for (AssistingJob tmpJob : tmpJobsArr) {
                    if (tmpJob == null) continue;
                    for (String autoeditName : retJobAutoedits.keySet()) {
                        if (((String)retJobAutoedits.get(autoeditName)).isEmpty()) {
                            this.addAutoeditAction(autoeditName, tmpJob.getAttr("JOBNAME"));
                        }
                        tmpJob.setAutoedit(autoeditName, (String)retJobAutoedits.get(autoeditName));
                    }
                    if (this.twsJob.type() == SchedEntity.TYPE.SMART_TABLE) {
                        this.twsJob.addMessage("INF6111", this.twsJob.getOriginalJobName(), this.twsJob.getJobName(), tmpJob.getJobName());
                    } else {
                        this.twsJob.addMessage("INF6110", this.twsJob.getOriginalJobName(), this.twsJob.getParentName(), this.twsJob.getJobName(), tmpJob.getJobName());
                    }
                    toRet = toRet == null ? new ArrayList<AssistingJob>() : toRet;
                    toRet.add(tmpJob);
                }
            }
        }
        return toRet;
    }

    private void addAutoeditAction(String autoeditName, String jobname) {
        Reporter.addGlobalAutoEditAction(this.twsJob.getMessages(), (String)autoeditName, (String)"", (String)jobname);
    }

    private ArrayList<AssistingJob> opensStatementToJob(String statement, Integer count) {
        String node;
        String origOpensStatement = statement;
        ArrayList<AssistingJob> toRet = new ArrayList<AssistingJob>();
        boolean opensToFileWatcher = this.twsJob.isOpensToFileWatcher();
        if (statement.contains("#")) {
            String[] tmpArr = statement.split("#", 2);
            node = tmpArr[0];
            statement = tmpArr[1];
        } else {
            node = this.attributes.get("NODEID");
        }
        if (opensToFileWatcher) {
            String qualifier;
            String file;
            Pattern pattern = Pattern.compile("(.+)\\((.+)\\)");
            Matcher matcher = pattern.matcher(statement);
            if (matcher.matches()) {
                file = matcher.group(1).trim();
                qualifier = matcher.group(2).trim();
                if (qualifier.equalsIgnoreCase("notempty")) {
                    qualifier = "-s %p";
                }
            } else {
                file = statement;
                qualifier = "-f %p";
            }
            boolean inOr = false;
            if (qualifier.startsWith("-")) {
                if (qualifier.contains(" -o ") && qualifier.contains(" -a ")) {
                    this.twsJob.addMessage("WRN6024", this.twsJob.generateUniqueID(), origOpensStatement, "it contains more than one Boolean operator type");
                    return toRet;
                }
            } else {
                String assistingJobName = String.format("%s_opens_%d", this.twsJob.getAttr("JOBNAME"), count);
                String jobId = this.twsJob.getType() == SchedEntity.TYPE.JOB ? assistingJobName + "@" + this.twsJob.getParentName() : assistingJobName + "@" + this.twsJob.getAttr("JOBNAME");
                this.twsJob.addMessage("WRN6024", jobId, origOpensStatement, "File Watcher must be manually adjusted to replace the condition " + qualifier);
                qualifier = "-f %p";
                this.createAssistingJob(count, toRet, node, inOr, 0, null, "-f", file.replace("\"", ""));
                return toRet;
            }
            ArrayList qualifierArray = GlobalFunctions.stringToWords((String)qualifier, null, null, null);
            for (int i = 0; i < qualifierArray.size(); ++i) {
                String opensOperator = null;
                String opensQualifier = null;
                String opensFile = null;
                try {
                    if (((String)qualifierArray.get(i)).matches("-[ao]")) {
                        opensOperator = (String)qualifierArray.get(i++);
                    }
                    if (((String)qualifierArray.get(i)).matches("-[fs]")) {
                        opensQualifier = (String)qualifierArray.get(i++);
                    }
                    if (opensQualifier == null) {
                        opensQualifier = "-f";
                        this.twsJob.addMessage("WRN6024", this.twsJob.generateUniqueID(), origOpensStatement, "Unrecognized qualifier condition, -f was used");
                        opensQualifier = (String)qualifierArray.get(i++);
                    }
                    opensFile = ((String)qualifierArray.get(i)).replace("%p", file).replace("\"", "");
                    if (i + 1 < qualifierArray.size() && ((String)qualifierArray.get(i + 1)).matches("-[ao]")) {
                        opensOperator = (String)qualifierArray.get(i + 1);
                    }
                    if (opensQualifier != null && opensFile != null) {
                        inOr = this.createAssistingJob(count, toRet, node, inOr, i, opensOperator, opensQualifier, opensFile);
                        continue;
                    }
                    this.twsJob.addMessage("WRN6024", this.twsJob.generateUniqueID(), origOpensStatement, "file was not found in opens statement");
                }
                catch (Exception e) {
                    this.twsJob.addMessage("WRN6024", this.twsJob.generateUniqueID(), origOpensStatement, "corrupt test statement");
                }
                break;
            }
        } else {
            AssistingJob opensJob = new AssistingJob((SchedEntity)this.twsJob);
            if (opensJob.getAttr("OWNER") == null || opensJob.getAttr("OWNER").isEmpty()) {
                opensJob.setAttribute("OWNER", this.twsJob.applyFieldConversion("OWNER"));
            }
            String instream = null;
            if (this.sourceDefinition.getCpus().isWindowsNode(node)) {
                HashMap<String, String> assistAutoEdits = new HashMap<String, String>();
                instream = this.opens2windowsScript(statement, assistAutoEdits);
                for (String name : assistAutoEdits.keySet()) {
                    opensJob.setAutoedit(name, assistAutoEdits.get(name));
                }
            } else {
                instream = this.opens2unixScript(statement);
            }
            opensJob.setOptionalAttribute("INSTREAM_JCL", instream);
            opensJob.setAttribute("USE_INSTREAM_JCL", "Y");
            opensJob.setAttribute("MEMNAME", ".cmd");
            if (this.twsJob.isDummyConversion()) {
                if (!Params.instance().getGUIVersion().equals("7")) {
                    opensJob.setAutoedit("%%$BMCWAIORIGTYPE", "Job");
                }
                opensJob.setAttribute("TASKTYPE", "Dummy");
            } else {
                opensJob.setAttribute("TASKTYPE", "Job");
            }
            opensJob.setAttribute("JOBNAME", String.format("%s_opens_%d", this.twsJob.getAttr("JOBNAME"), count));
            opensJob.setAttribute("TABLE_NAME", this.twsJob.createTableNameForAssistingJob());
            opensJob.setAttribute("PARENT_TABLE", this.twsJob.createTableNameForAssistingJob());
            String validatedNodeId = FieldValidation.instance().validateAndReturnFixedValue("NODEID", node);
            opensJob.setAttribute("NODEID", validatedNodeId);
            Properties stmt = new Properties();
            stmt.put("ACTION", "DOCOND");
            stmt.put("CODE", "*TEST SUCCESSFULL*");
            stmt.put("NAME", String.format("%s_opens_%d", this.twsJob.generateUniqueID(), count));
            stmt.put("ODATE", "ODAT");
            stmt.put("SIGN", "ADD");
            opensJob.addOnStmt(stmt);
            Properties outCondition = new Properties();
            outCondition.put("NAME", stmt.get("NAME"));
            outCondition.put("ODATE", stmt.get("ODATE"));
            outCondition.put("SIGN", "DEL");
            this.twsJob.addOutCond(outCondition);
            stmt = new Properties();
            stmt.put("ACTION", "SPCYC");
            stmt.put("CODE", "*TEST SUCCESSFULL*");
            stmt.put("STMT", "*");
            opensJob.addOnStmt(stmt);
            opensJob.setAttribute("CYCLIC", "1");
            Properties inCond = new Properties();
            inCond.put("NAME", String.format("%s_opens_%d", this.twsJob.generateUniqueID(), count));
            inCond.put("ODATE", "ODAT");
            inCond.put("AND_OR", "AND");
            this.twsJob.addInCond(inCond);
            toRet.add(opensJob);
        }
        return toRet;
    }

    private boolean createAssistingJob(Integer count, ArrayList<AssistingJob> toRet, String node, boolean inOr, int i, String opensOperator, String opensQualifier, String opensFile) {
        AssistingJob tmpJob = new AssistingJob((SchedEntity)this.twsJob);
        if (tmpJob.getAttr("OWNER") == null || tmpJob.getAttr("OWNER").isEmpty()) {
            tmpJob.setAttribute("OWNER", this.twsJob.applyFieldConversion("OWNER"));
        }
        if (this.twsJob.isDummyConversion()) {
            tmpJob.setAttribute("TASKTYPE", "Dummy");
        } else {
            tmpJob.setAttribute("TASKTYPE", "Job");
        }
        tmpJob.setAttribute("JOBNAME", String.format("%s_opens_%d", this.twsJob.getAttr("JOBNAME"), count));
        tmpJob.setAttribute("TABLE_NAME", this.twsJob.createTableNameForAssistingJob());
        tmpJob.setAttribute("PARENT_TABLE", this.twsJob.createTableNameForAssistingJob());
        String validatedNodeId = FieldValidation.instance().validateAndReturnFixedValue("NODEID", node);
        tmpJob.setAttribute("NODEID", validatedNodeId);
        tmpJob.setAttribute("MEMLIB", "Not in use for File Watcher jobs");
        tmpJob.setOptionalAttribute("APPL_FORM", "File Watcher");
        tmpJob.setOptionalAttribute("APPL_TYPE", "FileWatch");
        tmpJob.setOptionalAttribute("APPL_VER", "9.0.00.300");
        tmpJob.setOptionalAttribute("CM_VER", "8.0.00");
        tmpJob.setAutoedit("%%FileWatch-FILE_PATH", opensFile);
        tmpJob.setAutoedit("%%FileWatch-MIN_DET_SIZE", opensQualifier.equalsIgnoreCase("-s") ? "1" : "0");
        tmpJob.setAutoedit("%%FileWatch-INT_FILE_SEARCHES", "60");
        tmpJob.setAutoedit("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
        tmpJob.setAutoedit("%%FileWatch-NUM_OF_ITERATIONS", "3");
        tmpJob.setAutoedit("%%FileWatch-TIME_LIMIT", "0");
        tmpJob.setAutoedit("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
        tmpJob.setAutoedit("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
        tmpJob.setAutoedit("%%FileWatch-PATH", "Not in use for File Watcher jobs");
        tmpJob.setAutoedit("%%FileWatch-MODE", "CREATE");
        tmpJob.setAutoedit("%%FileWatch-FILESIZE_WILDCARD", "Y");
        tmpJob.setAutoedit("%%FileWatch-START_TIME", "NOW");
        tmpJob.setAutoedit("%%FileWatch-STOP_TIME", "0");
        tmpJob.setAttribute("MEMNAME", tmpJob.getAttr("JOBNAME"));
        tmpJob.setAutoedit("%%FileWatch-TIME_LIMIT", Integer.toString(1380));
        Object operatorSuffix = "";
        if (opensOperator != null && opensOperator.toLowerCase().equalsIgnoreCase("-a")) {
            operatorSuffix = "_" + i / 3;
        }
        Properties outCondition = new Properties();
        outCondition.put("NAME", String.format("%s_opens_%d%s", this.twsJob.generateUniqueID(), count, operatorSuffix));
        outCondition.put("ODATE", "ODAT");
        outCondition.put("SIGN", "ADD");
        tmpJob.addOutCondition(outCondition);
        if (opensOperator == null || !inOr) {
            Properties inCond = new Properties();
            inCond.put("NAME", outCondition.get("NAME"));
            inCond.put("ODATE", outCondition.get("ODATE"));
            inCond.put("AND_OR", "AND");
            this.twsJob.addInCond(inCond);
            Properties outCondition2 = new Properties();
            outCondition2.put("NAME", outCondition.get("NAME"));
            outCondition2.put("ODATE", outCondition.get("ODATE"));
            outCondition2.put("SIGN", "DEL");
            this.twsJob.addOutCond(outCondition2);
            boolean bl = inOr = opensOperator != null && opensOperator.matches("-o");
        }
        if (this.twsJob.isCyclic()) {
            if (this.attributes.containsKey("CYCLIC")) {
                tmpJob.setAttribute("CYCLIC", this.attributes.get("CYCLIC"));
            }
            if (this.attributes.containsKey("MAXRERUN")) {
                tmpJob.setAttribute("MAXRERUN", this.attributes.get("MAXRERUN"));
            }
            if (this.attributes.containsKey("CYCLIC_TYPE")) {
                tmpJob.setAttribute("CYCLIC_TYPE", this.attributes.get("CYCLIC_TYPE"));
            }
            if (this.attributes.containsKey("INTERVAL")) {
                tmpJob.setAttribute("INTERVAL", this.attributes.get("INTERVAL"));
            }
            if (this.attributes.containsKey("IND_CYCLIC")) {
                tmpJob.setAttribute("IND_CYCLIC", this.attributes.get("IND_CYCLIC"));
            }
        }
        toRet.add(tmpJob);
        return inOr;
    }

    private String opens2windowsScript(String statement, HashMap<String, String> assistAutoEdits) {
        String qualifier;
        String file;
        Pattern pattern = Pattern.compile("(.+)\\((.+)\\)");
        Matcher matcher = pattern.matcher(statement);
        if (matcher.matches()) {
            file = matcher.group(1).trim();
            qualifier = matcher.group(2).trim();
            if (qualifier.equalsIgnoreCase("notempty")) {
                qualifier = "-s %p";
            }
        } else {
            file = statement;
            qualifier = "-f %p";
        }
        qualifier = qualifier.replace("%p", file);
        qualifier = qualifier.trim();
        StringBuilder instream = new StringBuilder();
        if (qualifier.matches(".+ -[ao] .+")) {
            pattern = Pattern.compile("((-[rwdefs]) (.+?) (-[ao]))(.*)");
            matcher = pattern.matcher(qualifier);
            Integer paramCount = 0;
            while (matcher.matches()) {
                Integer n = paramCount;
                paramCount = paramCount + 1;
                String test = matcher.group(2);
                String subject = matcher.group(3);
                String operator = matcher.group(4);
                String tail = matcher.group(5);
                instream.append(this.testToBatchScriptLine(test, paramCount, operator));
                assistAutoEdits.put(String.format("%%%%PARM%d", paramCount), subject);
                matcher = pattern.matcher(tail);
            }
        } else {
            String[] testArr = qualifier.split(" ", 2);
            assistAutoEdits.put(String.format("%%%%PARM%d", 1), testArr[1]);
            instream.append(this.testToBatchScriptLine(testArr[0], 1, null));
        }
        instream.append(":FAIL\nexit /b 0\n");
        instream.append(":SUCCESS\necho TEST SUCCESSFULL\nexit /b 0\n");
        return instream.toString();
    }

    private String testToBatchScriptLine(String test, Integer param, String operator) {
        String testFormat = null;
        String returnString = null;
        if (operator == null || operator.isEmpty()) {
            operator = "-o";
        }
        if (operator.equals("-a")) {
            testFormat = "if not %s goto FAIL\n";
        } else if (operator.equals("-o")) {
            testFormat = "if %s goto SUCCESS\n";
        }
        if (test.equals("-d")) {
            String testSubject = "exist %" + param.toString() + "\\NUL";
            returnString = String.format(testFormat, testSubject);
        } else if (test.equals("-r") || test.equals("-f")) {
            String testSubject = "exist %" + param.toString();
            returnString = String.format(testFormat, testSubject);
        } else if (test.equals("-e")) {
            returnString = String.format("dir %%%d > NUL\n%s", param, String.format(testFormat, "%ERRORLEVEL% EQU 0"));
        } else if (test.equals("-w")) {
            returnString = String.format("echo @%%~a%d@ | findstr /R \"@[^r]*@\" | findstr /V @@ > NUL\n%s", param, String.format(testFormat, "%ERRORLEVEL% EQU 0"));
        } else if (test.equals("-s")) {
            if (operator.equals("-o")) {
                returnString = String.format("if not \"%%~z%d\" == \"0\" goto SUCCESS\n", param);
            } else {
                returnString = String.format("if not exist %%%d goto FAIL\n", param);
                returnString = String.format("%sif \"%%~z%d\" == \"0\" goto FAIL\n", returnString, param);
            }
        }
        return returnString;
    }

    private String opens2unixScript(String statement) {
        String qualifier;
        String file;
        Pattern pattern = Pattern.compile("(.+)\\((.+)\\)");
        Matcher matcher = pattern.matcher(statement);
        if (matcher.matches()) {
            file = matcher.group(1).trim();
            qualifier = matcher.group(2).trim();
            if (qualifier.equalsIgnoreCase("notempty")) {
                qualifier = "-s %p";
            }
        } else {
            file = statement;
            qualifier = "-r %p";
        }
        qualifier = qualifier.replace("%p", file);
        StringBuilder instream = new StringBuilder();
        instream.append("#!/bin/sh\n");
        instream.append(String.format("if [ %s ]; then\n", qualifier));
        instream.append("\techo TEST SUCCESSFULL\n");
        instream.append("fi\n");
        return instream.toString();
    }

    public void setVarTable(VarTable varTable) {
        this.varTable = varTable;
    }
}

